#ifndef __licenseconnectionserver_h__
#define __licenseconnectionserver_h__

#pragma once

#include <Drei/ThreadPool.h>
#include <Drei/TsidMap.h>

class CAuthentication;
class CProtocolBuilder;
class CJobQueue;
class CLicenseConnectionClient;
namespace DreiNetwork
{
	struct MessagePostee;
}

//////////////////////////////////////////////////////////////////////////

class IProxyConnectionHandler
{
public:
	virtual void OnConnect(uint32 streamId, bool& createConnectionInstance) = 0;
	virtual void OnReceive(const char* buffer, uint32 len, bool& createConnectionInstance) = 0;
};

class CProxyConnectionHandler : public IProxyConnectionHandler
{
public:
	CProxyConnectionHandler(const std::string& targetServerIp, int targetServerPort, const std::string& authStr);
	virtual void OnConnect(uint32 streamId, bool& createConnectionInstance);
	virtual void OnReceive(const char* buffer, uint32 len, bool& createConnectionInstance);

private:
	std::string m_targetServerIp;
	std::string m_authStr;
	int m_targetServerPort;
};

class CNullProxyConnectionHandler : public IProxyConnectionHandler
{
public:
	virtual void OnConnect(uint32 streamId, bool& createConnectionInstance);
	virtual void OnReceive(const char* buffer, uint32 len, bool& createConnectionInstance);
};

//////////////////////////////////////////////////////////////////////////

class CLicenseConnectionServer : public DreiNetwork::ThreadPool
{
public:
	CLicenseConnectionServer();
	~CLicenseConnectionServer(void);

	bool	Init(CJobQueue* que);
	void	Fini();

public:
	virtual bool	Begin() { return true; }
	virtual void	Update();
	virtual void	End() {}

public:
	void SetProxy(const std::string& targetServerIp, int targetServerPort, const std::string& authStr);

protected:
	void OnConnect(DreiNetwork::MessagePostee& postee, const char* buffer, uint32 len);
	void OnReceive(DreiNetwork::MessagePostee& postee, const char* buffer, uint32 len);
	void OnClose(DreiNetwork::MessagePostee& postee);
	void InitConnection();

private:
	CJobQueue*					m_jobQueue;
	CLicenseConnectionClient* m_licenseConnectionClient;
	IProxyConnectionHandler* m_proxyHandler;
};

#endif // __licenseconnectionserver_h__