#include "stdafx.h"
#ifdef USING_DATABASE_MODE

#include "LicenseDBJob.h"
#include "ServerLog.h"
#include "StringFilter.h"

const char* EvalLicenseRight = "EVAL_APPROVED";
const char* FloatLicenseRight = "MKT_EDU";
const uint32 QueryStringLength = 512;

const char* BadCharacterForQuery1 = "--";
const char* BadCharacterForQuery2 = "'";

const static bool LeaveLogSelectQuery = false;
const static bool LeaveLogModificationQuery = true;

// Database table names
const char* CompanyTable = "sf_company";
const char* CompanyRightTable = "sf_company_rights";
const char* GeneratedLicenseKeyTable = "sf_license_keys_generated";
const char* AssignedLicenseKeyTable = "sf_license_keys_assigned";
const char* SandboxUserTable = "sf_sandbox_students";

CAuthenticateLicenseKey::CAuthenticateLicenseKey(std::string licenseKey, std::string ip, std::string mac) : 
		m_licenseKey(licenseKey),
		m_ip(ip),
		m_mac(mac),
		m_connection(NULL)
{
	m_param.isValid = false;
	m_param.hasFloatConnectRight = false;
	m_param.hasEvalRight = false;
	m_param.remainSecond = 0;
	m_param.floatLicenses = 0;
	RemoveBadCharacter();
}

CAuthenticateLicenseKey::~CAuthenticateLicenseKey()
{
}

void CAuthenticateLicenseKey::SetMySQLConnection( CMySQLConnection& conn )
{
	m_connection = &conn;
}

SSelectAssignedKeyParam& CAuthenticateLicenseKey::ResultSet()
{
	return m_param;
}

bool CAuthenticateLicenseKey::FetchAssignedKey()
{
	char query[QueryStringLength] = {0,};
	sprintf(query, 
		"SELECT CompanyID, Ip, Mac, connecttype, floatlicenses FROM %s WHERE LicKey='%s' AND IsValid=1;", 
		AssignedLicenseKeyTable, 
		m_licenseKey.c_str());
	bool result = m_connection->ExecuteQuery(query, LeaveLogSelectQuery);
	if (false == result)
		return false;

	result = m_connection->StoreResult();
	if (false == result)
		return false;

	bool retResult = false;
	while(m_connection->FetchRow())
	{
		int index = 0;
		int companyID = 0;
		char ip[32] = {0,};
		char mac[32] = {0,};
		int floatConnectionCount = 0;
		int connectType = 0;
		if ( false == m_connection->GetData(index++, &companyID))
			break;
		if ( false == m_connection->GetData(index++, ip))
			break;
		if ( false == m_connection->GetData(index++, mac))
			break;
		if ( false == m_connection->GetData(index++, &connectType))
			break;
		if ( false == m_connection->GetData(index++, &floatConnectionCount))
			break;

		m_param.companyID = companyID;
		m_param.ipAddress = ip;
		m_param.macAddress = mac;
		//m_param.allowFloatConnection = (allowFloatConnection==1)?true:false;
		m_param.connectType = connectType;
		m_param.floatLicenses = floatConnectionCount;
		retResult = true;
	}
	m_connection->FreeResult();
	return retResult;
}

bool CAuthenticateLicenseKey::FetchGeneratedKey()
{
	char query[QueryStringLength] = {0,};
	sprintf(query, 
		"SELECT CompanyID, connecttype, floatlicenses FROM %s WHERE LicKey='%s';", 
		GeneratedLicenseKeyTable, 
		m_licenseKey.c_str());
	bool result = m_connection->ExecuteQuery(query, LeaveLogSelectQuery);
	if (false == result)
		return false;

	result = m_connection->StoreResult();
	if (false == result)
		return false;

	bool retResult = false;
	while(m_connection->FetchRow())
	{
		int index = 0;
		int companyID = 0;
		int floatConnectionCount = 0;
		int connectType = 0;
		if ( false == m_connection->GetData(index++, &companyID))
			break;
		if ( false == m_connection->GetData(index++, &connectType))
			break;
		if ( false == m_connection->GetData(index++, &floatConnectionCount))
			break;

		m_param.companyID = companyID;
		//m_param.allowFloatConnection = (allowFloatConnection==1)?true:false;
		m_param.connectType = connectType;
		m_param.floatLicenses = floatConnectionCount;
		retResult = true;
	}
	m_connection->FreeResult();
	return retResult;
}

bool CAuthenticateLicenseKey::MoveKeyFromGeneratedToAssigned()
{
	char query[QueryStringLength] = {0,};
	sprintf(query, 
		"SELECT CompanyID, connecttype, floatlicenses FROM %s WHERE LicKey='%s';", 
		GeneratedLicenseKeyTable, m_licenseKey.c_str());
	bool result = m_connection->ExecuteQuery(query, LeaveLogSelectQuery);
	if (false == result)
		return false;

	result = m_connection->StoreResult();
	if (false == result)
		return false;

	int companyID = 0;
	int connectType = 0;
	int floatlicenses = 0;
	bool retResult = false;
	while(m_connection->FetchRow())
	{
		int index = 0;
		if ( false == m_connection->GetData(index++, &companyID))
			break;
		if ( false == m_connection->GetData(index++, &connectType))
			break;
		if ( false == m_connection->GetData(index++, &floatlicenses))
			break;
		retResult = true;
		m_param.companyID = companyID;
		m_param.ipAddress = m_ip;
		m_param.macAddress = m_mac;
		m_param.connectType = connectType;
		m_param.floatLicenses = floatlicenses;
	}
	m_connection->FreeResult();

	if (false == retResult)
		return false;

#if 0
	//int allowFloatConnection = 0;
	//if (HasFloatRight())
	//	allowFloatConnection = 1;
#endif

	sprintf(query, 
		"INSERT %s(LicKey, Ip, Mac, CompanyID, connecttype, floatlicenses, IsValid, LastPing) VALUE('%s', '%s', '%s', %d, %d, %d, 1, NOW());", 
		AssignedLicenseKeyTable,
		m_licenseKey.c_str(),
		m_ip.c_str(),
		m_mac.c_str(),
		companyID,
		m_param.connectType,
		m_param.floatLicenses
		);
	result = m_connection->ExecuteQuery(query, LeaveLogModificationQuery);
	if (false == result)
		return false;

	sprintf(query, 
		"DELETE FROM %s WHERE LicKey='%s';", 
		GeneratedLicenseKeyTable, m_licenseKey.c_str());
	result = m_connection->ExecuteQuery(query, LeaveLogModificationQuery);
	if (false == result)
	{
		sprintf(query, 
			"DELETE FROM %s WHERE LicKey='%s';", 
			AssignedLicenseKeyTable,
			m_licenseKey.c_str());
		m_connection->ExecuteQuery(query, LeaveLogModificationQuery);
		return false;
	}

	return true;
}

bool CAuthenticateLicenseKey::UpdateLastPing()
{
	char query[QueryStringLength] = {0,};
	sprintf(query, 
		"UPDATE %s SET LastPing=NOW() WHERE LicKey='%s';", 
		AssignedLicenseKeyTable,
		m_licenseKey.c_str());
	bool result = m_connection->ExecuteQuery(query, LeaveLogModificationQuery);
	return result;
}

bool CAuthenticateLicenseKey::HasValidTerm()
{
	char query[QueryStringLength] = {0,};
	sprintf(query, 
		"SELECT IsValid, UNIX_TIMESTAMP(DATE_ADD(EvalStartDate, INTERVAL EvalDuration DAY)) - UNIX_TIMESTAMP(NOW()) FROM %s WHERE CompanyID = %d;", 
		CompanyTable,
		m_param.companyID);
	bool result = m_connection->ExecuteQuery(query, LeaveLogSelectQuery);
	if (false == result)
		return false;

	result = m_connection->StoreResult();
	if (false == result)
		return false;

	int companyID = 0;
	bool retResult = false;
	while(m_connection->FetchRow())
	{
		int index = 0;
		int remainSecond = 0;
		int isValid = 0;
		if ( false == m_connection->GetData(index++, &isValid))
			break;
		if ( false == m_connection->GetData(index++, &remainSecond))
			break;
		m_param.isValid = (isValid==1)?true:false;
		m_param.remainSecond = (remainSecond < 0)?0:remainSecond;

		retResult = true;
	}
	m_connection->FreeResult();
	return retResult;
}

bool CAuthenticateLicenseKey::HasEvalRight()
{
	char query[QueryStringLength] = {0,};
	sprintf(query, 
		"select CompanyId from %s where CompanyId = %d and RightId = '%s';", 
		CompanyRightTable, m_param.companyID, EvalLicenseRight);
	bool result = m_connection->ExecuteQuery(query, LeaveLogSelectQuery);
	if (false == result)
		return false;

	result = m_connection->StoreResult();
	if (false == result)
		return false;

	bool retResult = false;
	while(m_connection->FetchRow())
	{
		int index = 0;
		int companyId = 0;
		if ( false == m_connection->GetData(index++, &companyId))
			break;

		m_param.hasEvalRight = true;
		retResult = true;
	}
	m_connection->FreeResult();
	return retResult;
}

bool CAuthenticateLicenseKey::HasFloatRight()
{
	char query[QueryStringLength] = {0,};
	sprintf(query, 
		"select CompanyId from %s where CompanyId = %d and RightId = '%s';", 
		CompanyRightTable, m_param.companyID, FloatLicenseRight);
	bool result = m_connection->ExecuteQuery(query, LeaveLogSelectQuery);
	if (false == result)
		return false;

	result = m_connection->StoreResult();
	if (false == result)
		return false;

	bool retResult = false;
	while(m_connection->FetchRow())
	{
		int index = 0;
		int companyId = 0;
		if ( false == m_connection->GetData(index++, &companyId))
			break;

		m_param.hasFloatConnectRight = true;
		retResult = true;
	}
	m_connection->FreeResult();
	return retResult;
}

EPMErrorCode CAuthenticateLicenseKey::AssignedKeyProcess()
{
	if (false == FetchAssignedKey())
		return PMEC_KEY_NOT_FOUND;

	UpdateLastPing();
	if (false == HasValidTerm())
		return PMEC_KEY_EXPIRED;

	if (false == HasEvalRight())
		return PMEC_KEY_EXPIRED;

	HasFloatRight();
	return PMEC_NO_ERROR;
}

EPMErrorCode CAuthenticateLicenseKey::GeneratedKeyProcess()
{
	if (false == FetchGeneratedKey())
		return PMEC_KEY_NOT_FOUND;

	if (false == HasValidTerm())
		return PMEC_KEY_EXPIRED;

	if (false == HasEvalRight())
		return PMEC_KEY_EXPIRED;

	HasFloatRight();
	return PMEC_NO_ERROR;
}

void CAuthenticateLicenseKey::RemoveBadCharacter()
{
	CStringFilter filter;
	filter.RemoveSpecificString(m_licenseKey, BadCharacterForQuery1);
	filter.RemoveSpecificString(m_licenseKey, BadCharacterForQuery2);

	filter.RemoveSpecificString(m_ip, BadCharacterForQuery1);
	filter.RemoveSpecificString(m_ip, BadCharacterForQuery2);

	filter.RemoveSpecificString(m_mac, BadCharacterForQuery1);
	filter.RemoveSpecificString(m_mac, BadCharacterForQuery2);
}

//////////////////////////////////////////////////////////////////////////

CUpdateUsageTimeAndVersion::CUpdateUsageTimeAndVersion(const std::string& licenseKey, const std::string& appname, const std::string& version, uint32 usageTime) :
	m_licenseKey(licenseKey),
	m_appname(appname),
	m_version(version),
	m_usageTime(usageTime)
{
}

void CUpdateUsageTimeAndVersion::SetMySQLConnection( CMySQLConnection& conn )
{
	m_connection = &conn;
}

void CUpdateUsageTimeAndVersion::Execute()
{
	std::string appInfo = m_appname;
	appInfo += " ";
	appInfo += m_version;
	char query[QueryStringLength] = {0,};
	sprintf(query, 
		"UPDATE %s SET Version='%s', UsageTime=UsageTime+%d WHERE LicKey='%s';", 
		AssignedLicenseKeyTable, appInfo.c_str(), m_usageTime, m_licenseKey.c_str());
	m_connection->ExecuteQuery(query, LeaveLogModificationQuery);
}

//////////////////////////////////////////////////////////////////////////

CSandboxStudent::CSandboxStudent()
{

}

CSandboxStudent::~CSandboxStudent()
{

}

void CSandboxStudent::SetMySQLConnection( CMySQLConnection& conn )
{
	m_connection = &conn;
}

ELoginAccountResult CSandboxStudent::Authenticate( const std::string& usernameParam, const std::string& passwordParam, const std::string& licenseKeyParam, bool& agreelicenseFlag )
{
	std::string username = usernameParam;
	RemoveBadCharacter(username);
	std::string password = passwordParam;
	RemoveBadCharacter(password);
	std::string licenseKey = licenseKeyParam;
	RemoveBadCharacter(licenseKey);

	if (false == HasFloatRight(licenseKey))
		return eLA_InvalidLicense;
	ELoginAccountResult accountResultCode = IsValidAccount(username, password);
	agreelicenseFlag = IsAgreeLicense(username);
	if (eLA_Success == accountResultCode)
		UpdateLastPing(username);
	return accountResultCode;
}

bool CSandboxStudent::HasFloatRight(const std::string& licenseKey)
{
	return true;
#if 0
	char query[QueryStringLength] = {0,};
	sprintf(query, 
		"select CompanyId from %s where CompanyId = %d and RightId = '%s';", 
		CompanyRightTable, m_param.companyID, FloatLicenseRight);
	bool result = m_connection->ExecuteQuery(query);
	if (false == result)
		return false;

	result = m_connection->StoreResult();
	if (false == result)
		return false;

	bool retResult = false;
	while(m_connection->FetchRow())
	{
		int index = 0;
		int companyId = 0;
		if ( false == m_connection->GetData(index++, &companyId))
			break;

		m_param.hasFloatConnectRight = true;
		retResult = true;
	}
	m_connection->FreeResult();
	return retResult;
#endif
}

ELoginAccountResult CSandboxStudent::IsValidAccount(const std::string& account, const std::string& password)
{
	char query[QueryStringLength] = {0,};
	sprintf(query, 
		"select authcode from %s where username = '%s' and password = '%s';", 
		SandboxUserTable, account.c_str(), password.c_str());
	bool result = m_connection->ExecuteQuery(query, LeaveLogSelectQuery);
	if (false == result)
		return eLA_Undefined;

	result = m_connection->StoreResult();
	if (false == result)
		return eLA_InvalidAccount;

	ELoginAccountResult resultCode = eLA_InvalidAccount;
	while(m_connection->FetchRow())
	{
		int index = 0;
		char authCode[256] = {0,};
		if ( false == m_connection->GetData(index++, authCode))
			break;

		if ('1' == authCode[0])
			resultCode = eLA_Success;
		else
			resultCode = eLA_InactiveAccount;

	}
	m_connection->FreeResult();
	return resultCode;
}

bool CSandboxStudent::ExistUsername( const std::string& username )
{
	char query[QueryStringLength] = {0,};
	sprintf(query, 
		"select id from %s where username = '%s';", SandboxUserTable, username.c_str());
	bool result = m_connection->ExecuteQuery(query, LeaveLogSelectQuery);
	if (false == result)
		return false;

	result = m_connection->StoreResult();
	if (false == result)
		return false;

	bool retResult = false;
	while(m_connection->FetchRow())
	{
		int index = 0;
		int userId = 0;
		if ( false == m_connection->GetData(index++, &userId))
			break;
		retResult = true;
	}
	m_connection->FreeResult();
	return retResult;
}

bool CSandboxStudent::ExistEmail( const std::string& email )
{
	char query[QueryStringLength] = {0,};
	sprintf(query, 
		"select id from %s where email = '%s';", SandboxUserTable, email.c_str());
	bool result = m_connection->ExecuteQuery(query, LeaveLogSelectQuery);
	if (false == result)
		return false;

	result = m_connection->StoreResult();
	if (false == result)
		return false;

	bool retResult = false;
	while(m_connection->FetchRow())
	{
		int index = 0;
		int userId = 0;
		if ( false == m_connection->GetData(index++, &userId))
			break;
		retResult = true;
	}
	m_connection->FreeResult();
	return retResult;
}

ECreateAccountResult CSandboxStudent::CreateAccount( const SCreateAccountParam& param, const std::string& licenseKey )
{
	if (ExistUsername(param.username))
		return eCA_DuplicateUsername;
	//if (ExistEmail(param.email))
	//	return eCA_DuplicateEmail;
	if (false == IsValidDomain(param.email, licenseKey))
		return eCA_InvalidDomain;

	bool result = CreateAccountImpl(param);
	return result?eCA_Success:eCA_Undefined;
}

bool CSandboxStudent::CreateAccountImpl( const SCreateAccountParam& param )
{
	char query[QueryStringLength] = {0,};
	sprintf(query, 
		"INSERT INTO %s(username, password, email, firstname, lastname, address, city, state, zipcode, country ) VALUES('%s', '%s','%s','%s','%s','%s','%s','%s','%s','%s');",
		SandboxUserTable, 
		param.username.c_str(),
		param.password.c_str(), 
		param.email.c_str(),
		param.firstname.c_str(),
		param.lastname.c_str(),
		param.address.c_str(),
		param.city.c_str(),
		param.state.c_str(),
		param.zipcode.c_str(),
		param.country.c_str());
	bool result = m_connection->ExecuteQuery(query, LeaveLogModificationQuery);
	return result;
}

bool CSandboxStudent::SelectUserId( const std::string& username, uint32& userId )
{
	char query[QueryStringLength] = {0,};
	sprintf(query, 
		"select id from %s WHERE username = '%s';", SandboxUserTable, username.c_str());
	bool result = m_connection->ExecuteQuery(query, LeaveLogSelectQuery);
	if (false == result)
		return false;

	result = m_connection->StoreResult();
	if (false == result)
		return false;

	bool retResult = false;
	while(m_connection->FetchRow())
	{
		int index = 0;
		
		if ( false == m_connection->GetData(index++, (int*)&userId))
			break;

		retResult = true;
	}
	m_connection->FreeResult();
	return retResult;
}


bool CSandboxStudent::SelectPassword( const std::string& username, uint32& userId, std::string& password )
{
	char query[QueryStringLength] = {0,};
	sprintf(query, 
		"select id, password from %s WHERE username = '%s';", SandboxUserTable, username.c_str());
	bool result = m_connection->ExecuteQuery(query, LeaveLogSelectQuery);
	if (false == result)
		return false;

	result = m_connection->StoreResult();
	if (false == result)
		return false;

	bool retResult = false;
	while(m_connection->FetchRow())
	{
		int index = 0;
		char tempPassword[128] = {0,};
		if ( false == m_connection->GetData(index++, (int*)&userId))
			break;
		if ( false == m_connection->GetData(index++, tempPassword))
			break;
		password = tempPassword;
		retResult = true;
	}
	m_connection->FreeResult();
	return retResult;
}


bool CSandboxStudent::SelectPasswordByEmail( const std::string& email, uint32& userId, std::string& password )
{
	char query[QueryStringLength] = {0,};
	sprintf(query, 
		"select id, password from %s WHERE email = '%s';", SandboxUserTable, email.c_str());
	bool result = m_connection->ExecuteQuery(query, LeaveLogSelectQuery);
	if (false == result)
		return false;

	result = m_connection->StoreResult();
	if (false == result)
		return false;

	bool retResult = false;
	while(m_connection->FetchRow())
	{
		int index = 0;
		char tempPassword[128] = {0,};
		if ( false == m_connection->GetData(index++, (int*)&userId))
			break;
		if ( false == m_connection->GetData(index++, tempPassword))
			break;
		password = tempPassword;
		retResult = true;
		break;
	}
	m_connection->FreeResult();
	return retResult;
}


void CSandboxStudent::UpdateLastPing(const std::string& username)
{
	char query[QueryStringLength] = {0,};
	sprintf(query, 
		"UPDATE %s SET lastping=NOW() WHERE username = '%s';", SandboxUserTable, username.c_str());
	bool result = m_connection->ExecuteQuery(query, LeaveLogModificationQuery);
}

bool CSandboxStudent::IsAgreeLicense(const std::string& username)
{
	char query[QueryStringLength] = {0,};
	sprintf(query, 
		"SELECT agreelicense FROM %s WHERE username = '%s';", SandboxUserTable, username.c_str());
	bool result = m_connection->ExecuteQuery(query, LeaveLogSelectQuery);
	if (false == result)
		return false;

	result = m_connection->StoreResult();
	if (false == result)
		return false;

	bool retResult = false;
	while(m_connection->FetchRow())
	{
		int index = 0;
		int agreeLicenseFlag = 0;
		if ( false == m_connection->GetData(index++, &agreeLicenseFlag))
			break;

		if (1 == agreeLicenseFlag)
			retResult = true;
	}
	m_connection->FreeResult();
	return retResult;

}

void CSandboxStudent::UpdateAgreeLicense( const std::string& username )
{
	char query[QueryStringLength] = {0,};
	sprintf(query, 
		"UPDATE %s SET agreelicense=1 WHERE username = '%s';", SandboxUserTable, username.c_str());
	bool result = m_connection->ExecuteQuery(query, LeaveLogModificationQuery);
}

void CSandboxStudent::RemoveBadCharacter(std::string& target)
{
	CStringFilter filter;
	filter.RemoveSpecificString(target, BadCharacterForQuery1);
	filter.RemoveSpecificString(target, BadCharacterForQuery2);
}
bool CSandboxStudent::IsValidDomain(const std::string& email, const std::string& licenseKey)
{
	int companyID = 0;
	std::string companyDomain;
	if (false == GetCompanyID(licenseKey, companyID))
		return false;
	if (false == GetComapnyDomain(companyID, companyDomain))
		return false;
	if (false == IsEqualEmailDomain(email, companyDomain))
		return false;

	return true;
}

bool CSandboxStudent::GetCompanyID( const std::string& licenseKey, int& companyID )
{
	char query[QueryStringLength] = {0,};
	sprintf(query, 
		"SELECT CompanyID FROM %s WHERE LicKey='%s';", AssignedLicenseKeyTable, licenseKey.c_str());
	bool result = m_connection->ExecuteQuery(query, LeaveLogSelectQuery);
	if (false == result)
		return false;

	result = m_connection->StoreResult();
	if (false == result)
		return false;

	bool retResult = false;
	while(m_connection->FetchRow())
	{
		int index = 0;
		if ( false == m_connection->GetData(index++, &companyID))
			break;
		retResult = true;
	}
	m_connection->FreeResult();
	return retResult;
}

bool CSandboxStudent::GetComapnyDomain( const int& companyID, std::string& domain )
{
	char query[QueryStringLength] = {0,};
	sprintf(query, "SELECT Domain FROM %s WHERE CompanyID = %d;", CompanyTable, companyID);
	bool result = m_connection->ExecuteQuery(query, LeaveLogSelectQuery);
	if (false == result)
		return false;

	result = m_connection->StoreResult();
	if (false == result)
		return false;

	bool retResult = false;
	while(m_connection->FetchRow())
	{
		int index = 0;
		char tempDomain[128] = {0,};
		if ( false == m_connection->GetData(index++, tempDomain))
			break;

		domain = tempDomain;
		retResult = true;
	}
	m_connection->FreeResult();
	return retResult;

}

bool CSandboxStudent::IsEqualEmailDomain( const std::string& userEmail, const std::string& companyDomainParam )
{
	const char* SeparaterChar = ";";
	const char* AtChar = "@";
	if (userEmail.find(AtChar) == std::string::npos)
		return false;

	std::string userDomain = userEmail.substr(userEmail.find(AtChar), userEmail.length()-userEmail.find(AtChar));
	std::string companyDomain = companyDomainParam;
	while ( companyDomain.find(SeparaterChar) != std::string::npos )
	{
		std::string oneDomain = companyDomain.substr(0, companyDomain.find(SeparaterChar));
		if (oneDomain == userDomain)
			return true;

		std::string removeStr = oneDomain + ";";
		companyDomain.erase( companyDomain.find(removeStr), removeStr.length() );
	}
	return false;
}
#endif // USING_DATABASE_MODE

