#ifndef __licensedbjob_h__
#define __licensedbjob_h__

#pragma once

#ifdef USING_DATABASE_MODE

#include <string>
#include "MySQLConnection.h"
#include "LicenseServerCommon.h"

//////////////////////////////////////////////////////////////////////////
struct SSelectAssignedKeyParam
{
	uint32 companyID;
	std::string ipAddress;	
	std::string macAddress;
	uint32 remainSecond;
	uint32 floatLicenses;
	uint8 connectType;
	//bool allowFloatConnection;
	bool isValid;
	bool hasEvalRight;
	bool hasFloatConnectRight;
};

class CAuthenticateLicenseKey
{
public:
	CAuthenticateLicenseKey(std::string licenseKey, std::string ip, std::string mac);
	virtual ~CAuthenticateLicenseKey();

public:
	SSelectAssignedKeyParam& ResultSet();
	void SetMySQLConnection(CMySQLConnection& conn);

	EPMErrorCode AssignedKeyProcess();
	EPMErrorCode GeneratedKeyProcess();
	bool MoveKeyFromGeneratedToAssigned();

protected:
	bool FetchAssignedKey();
	bool FetchGeneratedKey();
	bool HasValidTerm();
	bool HasEvalRight();
	bool HasFloatRight();
	bool UpdateLastPing();
	void RemoveBadCharacter();
	
private:
	std::string	m_licenseKey;
	std::string	m_ip;
	std::string	m_mac;
	SSelectAssignedKeyParam	m_param;
	CMySQLConnection* m_connection;
};

//////////////////////////////////////////////////////////////////////////

class CUpdateUsageTimeAndVersion
{
public:
	CUpdateUsageTimeAndVersion(const std::string& licenseKey, const std::string& appname, const std::string& version, uint32 usageTime);
	virtual ~CUpdateUsageTimeAndVersion() {}

public:
	void SetMySQLConnection(CMySQLConnection& conn);
	void Execute();

protected:
//	bool Update

private:
	CMySQLConnection* m_connection;
	std::string m_appname;
	std::string m_version;
	std::string m_licenseKey;
	uint32 m_usageTime;
};

//////////////////////////////////////////////////////////////////////////


class CSandboxStudent
{
public:
	CSandboxStudent();
	virtual ~CSandboxStudent();

public:
	void SetMySQLConnection(CMySQLConnection& conn);
	ELoginAccountResult Authenticate(const std::string& username, const std::string& password, const std::string& licenseKey, bool& agreelicenseFlag);
	ECreateAccountResult CreateAccount(const SCreateAccountParam& param, const std::string& licenseKey);
	bool SelectUserId(const std::string& username, uint32& userId);
	bool SelectPassword(const std::string& username, uint32& userId, std::string& password);
	bool SelectPasswordByEmail(const std::string& email, uint32& userId, std::string& password);
	void UpdateAgreeLicense(const std::string& username);

protected:
	bool HasFloatRight(const std::string& licenseKey);
	ELoginAccountResult IsValidAccount(const std::string& username, const std::string& password);
	bool ExistUsername(const std::string& username);
	bool ExistEmail(const std::string& email);
	bool CreateAccountImpl(const SCreateAccountParam& param);
	void UpdateLastPing(const std::string& username);
	bool IsAgreeLicense(const std::string& username);
	void RemoveBadCharacter(std::string& target);
	bool IsValidDomain(const std::string& email, const std::string& licenseKey);
	bool GetCompanyID(const std::string& licenseKey, int& companyID);
	bool GetComapnyDomain(const int& companyID, std::string& domain);
	bool IsEqualEmailDomain(const std::string& userEmail, const std::string& companyDomain);

private:
	CMySQLConnection* m_connection;

};

//////////////////////////////////////////////////////////////////////////

#endif // USING_DATABASE_MODE


#endif // __licensedbjob_h__