#ifndef __networkclient_h__
#define __networkclient_h__

#pragma once

#include <Drei/MemoryObject.h>

class CJobQueue;
class CProtocolBuilder;
class CProtocolAssembler;

class CNetworkClient : public DreiNetwork::MemoryObject
{
public:
	CNetworkClient(uint32 streamId, CJobQueue* que);
	~CNetworkClient(void);

	void	OnAccept(const char* buffer, uint32 len);
	void	OnReceive(const char* buffer, uint32 len);
	void	OnClose();

protected:
	TAGES_EXPORT	void	PacketHandle_Login(CProtocolBuilder& packet);
	TAGES_EXPORT	void	PacketHandle_Auth(CProtocolBuilder& packet);
	TAGES_EXPORT	void	PacketHandle_CreateAccount(CProtocolBuilder& packet);
	TAGES_EXPORT	void	PacketHandle_LoginAccount(CProtocolBuilder& packet);
	TAGES_EXPORT	void	PacketHandle_PasswordRemind(CProtocolBuilder& packet);

	TAGES_EXPORT	void	PacketHandle_RequestCreaterAccount(CProtocolBuilder& packet);
	TAGES_EXPORT	void	PacketHandle_RequestLoginAccount(CProtocolBuilder& packet);
	TAGES_EXPORT	void	PacketHandle_LicenseAgree(CProtocolBuilder& packet);
	TAGES_EXPORT	void	PacketHandle_RequestLicenseAgree(CProtocolBuilder& packet);
	TAGES_EXPORT	void	PacketHandle_RequestPasswordRemind(CProtocolBuilder& packet);


private:
	CJobQueue*					m_jobQueue;
	CProtocolAssembler*	m_assembler;
	uint32							m_streamId;
	std::string					m_remoteIp;
};

#endif // __networkclient_h__