#ifndef __networkserver_h__
#define __networkserver_h__

#pragma once

#include <Drei/ThreadPool.h>
#include <Drei/TsidMap.h>

class CAuthentication;
class CProtocolBuilder;
class CJobQueue;
class CNetworkClient;
namespace DreiNetwork
{
	struct MessagePostee;
}

class CNetworkServer : public DreiNetwork::ThreadPool
{
public:
	typedef DreiNetwork::TsMapT<CNetworkClient, 1024>	ClientMapType;
	CNetworkServer();
	~CNetworkServer(void);

	bool	Init(CJobQueue* que);
	void	Fini();

public:
	virtual bool	Begin() { return true; }
	virtual void	Update();
	virtual void	End() {}

protected:
	void	OnAccept(DreiNetwork::MessagePostee& postee, const char* buffer, uint32 len);
	void	OnReceive(DreiNetwork::MessagePostee& postee, const char* buffer, uint32 len);
	void	OnClose(DreiNetwork::MessagePostee& postee);

private:
	bool								m_init;
	CJobQueue*					m_jobQueue;
	ClientMapType*			m_clientMap;
};

#endif // __networkserver_h__