#ifndef __processjob_h__
#define __processjob_h__

#pragma once

#include "SmallObj.h"
#include "LicenseServerCommon.h"

class CMySQLConnection;
class CUniKeyManager;
class CClientModeManager;
class CDatabaseModeManager;

class CAbstractJob : public Loki::SmallObject<>
{
public:
	virtual ~CAbstractJob(){};
	virtual	void	DBExecute(CDatabaseModeManager& mgr) {}
	virtual	void	UniKeyExecute(CUniKeyManager& unikey) {}
	virtual	void	ClientModeExecute(CClientModeManager& mgr) {}
	virtual	void	Complete() = 0;
};

//////////////////////////////////////////////////////////////////////////
class CLoginJob : public CAbstractJob
{
public:
	CLoginJob(std::string received, uint32 streamId, uint32 tick);
	virtual ~CLoginJob() {};

public:
	virtual	void	DBExecute(CDatabaseModeManager& mgr);
	TAGES_EXPORT	virtual	void	UniKeyExecute(CUniKeyManager& unikey);
	TAGES_EXPORT	virtual	void	ClientModeExecute(CClientModeManager& mgr);
	TAGES_EXPORT	virtual	void	Complete();

protected:
	void MakeEncryptionKey(uint32 seed);

private:
	std::string		m_encryptionKey;
	EPMErrorCode	m_result;
	uint32 m_streamId;
	uint32 m_tick;
	uint32 m_remainSecond;
	uint32 m_floatLicenses;
	bool m_allowFloatConnection;
	std::string m_receivedString;
	std::string m_sessionId;
};

//////////////////////////////////////////////////////////////////////////
class CAuthJob : public CAbstractJob
{
public:
	CAuthJob(std::string received, uint32 streamId, uint32 tick);
	virtual ~CAuthJob() {};

public:
	virtual	void	DBExecute(CDatabaseModeManager& mgr);
	TAGES_EXPORT	virtual	void	UniKeyExecute(CUniKeyManager& unikey);
	TAGES_EXPORT	virtual	void	ClientModeExecute(CClientModeManager& mgr);
	TAGES_EXPORT	virtual	void	Complete();

private:
	EPMErrorCode	m_result;
	uint32	m_streamId;
	uint32	m_tick;
	std::string m_receivedString;
};

//////////////////////////////////////////////////////////////////////////
class CLogoffJob : public CAbstractJob
{
public:
	CLogoffJob(std::string& key, std::string& mac, uint32 streamId, uint32 tick);
	virtual ~CLogoffJob() {};

public:
	virtual	void	DBExecute(CDatabaseModeManager& mgr);
	virtual	void	UniKeyExecute(CUniKeyManager& unikey);
	virtual	void	ClientModeExecute(CClientModeManager& mgr);
	virtual	void	Complete();

private:
	std::string		m_key;
	std::string		m_mac;
	bool					m_result;
	uint32	m_streamId;
	uint32	m_tick;
};

//////////////////////////////////////////////////////////////////////////
// Client -> Local Server

class CCreateAccountJob : public CAbstractJob
{
public:
	CCreateAccountJob(std::string received, uint32 streamId);
	virtual ~CCreateAccountJob() {};

public:
	TAGES_EXPORT	virtual	void	ClientModeExecute(CClientModeManager& mgr);
	TAGES_EXPORT	virtual	void	Complete() {}

private:
	std::string m_receivedString;
	uint32 m_streamId;
};

//////////////////////////////////////////////////////////////////////////
// Client -> Local Server

class CLoginAccountJob : public CAbstractJob
{
public:
	CLoginAccountJob(std::string received, uint32 streamId);
	virtual ~CLoginAccountJob() {};

public:
	TAGES_EXPORT virtual void ClientModeExecute(CClientModeManager& mgr);
	TAGES_EXPORT virtual void Complete() {}

private:
	std::string m_receivedString;
	uint32 m_streamId;
};

//////////////////////////////////////////////////////////////////////////
// Client -> Local Server

class CPasswordRemindJob : public CAbstractJob
{
public:
	CPasswordRemindJob(std::string received, uint32 streamId);
	virtual ~CPasswordRemindJob() {};

public:
	TAGES_EXPORT virtual void ClientModeExecute(CClientModeManager& mgr);
	TAGES_EXPORT virtual void Complete() {}

private:
	std::string m_receivedString;
	uint32 m_streamId;
};

//////////////////////////////////////////////////////////////////////////
// Global server -> Local server

class CCreateAccount4LicenseConnection : public CAbstractJob
{
public:
	CCreateAccount4LicenseConnection(std::string received, uint32 streamId);
	virtual ~CCreateAccount4LicenseConnection() {};

public:
	TAGES_EXPORT	virtual	void	ClientModeExecute(CClientModeManager& mgr);
	TAGES_EXPORT	virtual	void	Complete();

private:
	std::string m_receivedString;
	uint32 m_streamId;
};

//////////////////////////////////////////////////////////////////////////
// Global server -> Local server

class CLoginAccount4LicenseConnection : public CAbstractJob
{
public:
	CLoginAccount4LicenseConnection(std::string received, uint32 streamId);
	virtual ~CLoginAccount4LicenseConnection() {};

public:
	TAGES_EXPORT	virtual	void	ClientModeExecute(CClientModeManager& mgr);
	TAGES_EXPORT	virtual	void	Complete();

private:
	std::string m_receivedString;
	uint32 m_streamId;
};

//////////////////////////////////////////////////////////////////////////
// Global server -> Local server

class CConnectionEstblished4LicenseConnection : public CAbstractJob
{
public:
	CConnectionEstblished4LicenseConnection(uint32 streamId);
	virtual ~CConnectionEstblished4LicenseConnection() {};

public:
	TAGES_EXPORT	virtual	void	ClientModeExecute(CClientModeManager& mgr);
	TAGES_EXPORT	virtual	void	Complete();

private:
	uint32 m_streamId;
};


//////////////////////////////////////////////////////////////////////////
// Global server -> Local server

class CConnectionClose4LicenseConnection : public CAbstractJob
{
public:
	CConnectionClose4LicenseConnection(uint32 streamId);
	virtual ~CConnectionClose4LicenseConnection() {};

public:
	TAGES_EXPORT	virtual	void	ClientModeExecute(CClientModeManager& mgr);
	TAGES_EXPORT	virtual	void	Complete();

private:
	uint32 m_streamId;
};

//////////////////////////////////////////////////////////////////////////
// Global server -> Local server

class CLoginResult4LicenseConnection : public CAbstractJob
{
public:
	CLoginResult4LicenseConnection(std::string received, uint32 streamId, uint32 tick);
	virtual ~CLoginResult4LicenseConnection() {};

public:
	TAGES_EXPORT	virtual	void	ClientModeExecute(CClientModeManager& mgr);
	TAGES_EXPORT	virtual	void	Complete() {};

private:
	std::string m_receivedString;
	uint32 m_streamId;
};

//////////////////////////////////////////////////////////////////////////
// Global server -> Local server

class CPasswordRemind4LicenseConnection : public CAbstractJob
{
public:
	CPasswordRemind4LicenseConnection(std::string received, uint32 streamId);
	virtual ~CPasswordRemind4LicenseConnection() {};

public:
	TAGES_EXPORT	virtual	void	ClientModeExecute(CClientModeManager& mgr);
	TAGES_EXPORT	virtual	void	Complete() {};

private:
	std::string m_receivedString;
	uint32 m_streamId;
};

//////////////////////////////////////////////////////////////////////////
// Local server -> Global server

class CCreateAccountRequest : public CAbstractJob
{
public:
	CCreateAccountRequest(std::string received, uint32 streamId);
	virtual ~CCreateAccountRequest() {};

public:
	virtual	void	DBExecute(CDatabaseModeManager& mgr);
	virtual	void	Complete() {};

protected:
	bool SendEmailToUser(uint32 userId);

private:
	std::string m_receivedString;
	uint32 m_streamId;
};

//////////////////////////////////////////////////////////////////////////
// Local server -> Global server

class CLoginAccountRequest : public CAbstractJob
{
public:
	CLoginAccountRequest(std::string received, uint32 streamId);
	virtual ~CLoginAccountRequest() {};

public:
	virtual	void	DBExecute(CDatabaseModeManager& mgr);
	virtual	void	Complete() {};

protected:
	std::string GenerateSessionKey(const std::string& account);

private:
	std::string m_receivedString;
	uint32 m_streamId;
};

//////////////////////////////////////////////////////////////////////////
// Local server -> Global server

class CLicenseAgreeJob : public CAbstractJob
{
public:
	CLicenseAgreeJob(std::string received, uint32 streamId);
	virtual ~CLicenseAgreeJob() {};

public:
	TAGES_EXPORT virtual void ClientModeExecute(CClientModeManager& mgr);
	TAGES_EXPORT virtual void Complete() {};

private:
	std::string m_receivedString;
	uint32 m_streamId;
};

//////////////////////////////////////////////////////////////////////////
// Local server -> Global server

class CLicenseAgreeRequestJob : public CAbstractJob
{
public:
	CLicenseAgreeRequestJob(std::string received, uint32 streamId);
	virtual ~CLicenseAgreeRequestJob() {};

public:
	virtual	void	DBExecute(CDatabaseModeManager& mgr);
	virtual	void	Complete() {};

private:
	std::string m_receivedString;
	uint32 m_streamId;
};

//////////////////////////////////////////////////////////////////////////
// Local server -> Global server

class CPasswordRemindRequestJob : public CAbstractJob
{
public:
	CPasswordRemindRequestJob(std::string received, uint32 streamId);
	virtual ~CPasswordRemindRequestJob() {};

public:
	virtual	void	DBExecute(CDatabaseModeManager& mgr);
	virtual	void	Complete() {};

private:
	std::string m_receivedString;
	uint32 m_streamId;
};

//////////////////////////////////////////////////////////////////////////


#endif // __processjob_h__