#include "stdafx.h"
#include "Server.h"
#include "NetworkServer.h"
#include "UniKeyManager.h"
#include "JobQueue.h"
#include "DatabaseServer.h"
#include "UniKeyServer.h"
#include "ClientModeServer.h"
#include "ServerConfig.h"
#include "ServerLog.h"
#include <ace/Event.h>

CServer::CServer(void) : 
	m_networkServer(NULL), 
	m_jobServer(NULL),
	m_jobQueue(NULL)
{
}

CServer::~CServer(void)
{
}

bool CServer::Init()
{
	InitLogger();
	m_jobQueue = new CJobQueue();
	if (false == m_jobQueue->Init())
		return false;

	const char* ConfigFilename = "LicenseServerConfig.txt";
	if (false == CServerConfig::Load(ConfigFilename))
	{
		printf("Can not find config file.(%s)\n", ConfigFilename);
		return false;
	}

	printf("Read config from %s.\n", ConfigFilename);
	bool initResult = false;

	initResult = InitDatabase();
	if (false == initResult)
		initResult = InitClientmode();
	if (false == initResult)
		initResult = InitDongle();

	if (false == initResult)
		return false;

	m_networkServer = new CNetworkServer();
	if (false == m_networkServer->Init(m_jobQueue))
		return false;

	m_jobServer->MakeConnectionWithGlobalServer();

	return true;
}

void CServer::Fini()
{
	m_jobQueue->Fini();

	m_networkServer->Fini();
	delete m_networkServer;
	m_networkServer = NULL;

	if (NULL != m_jobServer)
	{
		m_jobServer->Fini();
		delete m_jobServer;
		m_jobServer = NULL;
	}

	delete m_jobQueue;
	m_jobQueue = NULL;
	FiniLogger();
}

bool CServer::Update()
{
	//EventSleep(10000);
	m_jobServer->Update();
	ServerLoggerSingleton::instance()->Update();
	return true;
}

void CServer::EventSleep(int32 ms)
{
	ACE_Time_Value waitTime(ms/1000, (ms%1000)*1000);
	ACE_Event eventObj;
	eventObj.wait(&waitTime, 0);
}

void CServer::InitLogger()
{
	ServerLoggerSingleton::instance()->Init();
}

void CServer::FiniLogger()
{
	ServerLoggerSingleton::instance()->Fini();
}

bool CServer::InitDongle()
{
	if (HasClientModeConfigure())
		return false;
#ifdef USING_UNIKEY_MODE
	printf("Try Dongle mode.\n");
	m_jobServer = new CUniKeyServer();
	if (m_jobServer->Init(m_jobQueue))
	{
		printf("Dongle mode success.\n");
		return true;
	}
	delete m_jobServer;
	m_jobServer = NULL;
	printf("Dongle mode fail.\n");
#endif // USING_UNIKEY_MODE
	return false;
}

bool CServer::InitDatabase()
{
#ifdef USING_DATABASE_MODE
	printf("Try Database mode.\n");
	m_jobServer = new CDatabaseServer();
	if (m_jobServer->Init(m_jobQueue))
	{
		printf("Database mode success.\n");
		return true;
	}
	delete m_jobServer;
	m_jobServer = NULL;
	printf("Database mode fail.\n");
#endif // USING_DATABASE_MODE
	return false;
}

bool CServer::InitClientmode()
{
	if (false == HasClientModeConfigure())
		return false;
#ifdef USING_CLIENT_MODE
	printf("Try Client mode.\n");
	m_jobServer = new CClientModeServer();
	if (m_jobServer->Init(m_jobQueue))
	{
		printf("Client mode success.\n");
		return true;
	}
	delete m_jobServer;
	m_jobServer = NULL;
	printf("Client mode fail.\n");
#endif // USING_CLIENT_MODE
	return false;
}

bool CServer::HasClientModeConfigure()
{
	std::string licenseKey = CServerConfig::GetValue<std::string>("ClientModeLicenseKey");
	return (false == licenseKey.empty());
}