#ifndef __serverlog_h__
#define __serverlog_h__

#pragma once

#include <Drei/Logger.h>

const static int LogFilenameSize = 128;

namespace DreiNetwork
{ 
	class CycleChecker;
}

class CServerLog
{
public:
	CServerLog(void);
	~CServerLog(void);

	bool Init();
	void Fini();
	void Update();

	DreiNetwork::Logger*	GetDBLogger();
	DreiNetwork::Logger*	GetPacketLogger();
	DreiNetwork::Logger*	GetErrorLogger();

protected:
	void LogFileSizeCheck();

private:
	DreiNetwork::Logger*	m_dbLogger;
	DreiNetwork::Logger*	m_packetLogger;
	DreiNetwork::Logger*	m_errorLogger;

	char m_dbLogFilename[LogFilenameSize];
	char m_packetLogFilename[LogFilenameSize];
	char m_errorLogFilename[LogFilenameSize];

	DreiNetwork::CycleChecker* m_logFileSizeCheckTimer;
};

typedef ACE_Singleton<CServerLog, ACE_Thread_Mutex> ServerLoggerSingleton;
#define DBLogger ServerLoggerSingleton::instance()->GetDBLogger()
#define PacketLogger ServerLoggerSingleton::instance()->GetPacketLogger()
#define ErrorLogger ServerLoggerSingleton::instance()->GetErrorLogger()

#endif // __serverlog_h__