#include "stdafx.h"
#include "StringFilter.h"
#include "AesCryptography.h"
#include "LicenseServerCommon.h"
#include "ace/UUID.h"

CStringFilter::CStringFilter(void)
{
}

CStringFilter::~CStringFilter(void)
{
}

void CStringFilter::RemoveSpecificString( std::string& target, const std::string& remove)
{
	while ( target.find(remove) != std::string::npos )
		target.erase( target.find(remove), remove.length() );
}

void CStringFilter::Convert2SmallLetter( std::string& source )
{
	for(int i=0; i<(int)source.length();++i)
	{
		int swap = tolower(source.at(i));
		source.at(i) = swap;
	}
}

static const std::string base64_chars = 
"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

static inline bool is_base64(uint8 c) 
{
	return (isalnum(c) || (c == '+') || (c == '/'));
}

std::string CStringFilter::Base64Encode( uint8 const* bytes_to_encode, uint32 in_len )
{
	std::string ret;
	int i = 0;
	int j = 0;
	uint8 char_array_3[3];
	uint8 char_array_4[4];

	while (in_len--) 
	{
		char_array_3[i++] = *(bytes_to_encode++);
		if (i == 3) 
		{
			char_array_4[0] = (char_array_3[0] & 0xfc) >> 2;
			char_array_4[1] = ((char_array_3[0] & 0x03) << 4) + ((char_array_3[1] & 0xf0) >> 4);
			char_array_4[2] = ((char_array_3[1] & 0x0f) << 2) + ((char_array_3[2] & 0xc0) >> 6);
			char_array_4[3] = char_array_3[2] & 0x3f;

			for(i = 0; (i <4) ; i++)
				ret += base64_chars[char_array_4[i]];
			i = 0;
		}
	}

	if (i)
	{
		for(j = i; j < 3; j++)
			char_array_3[j] = '\0';

		char_array_4[0] = (char_array_3[0] & 0xfc) >> 2;
		char_array_4[1] = ((char_array_3[0] & 0x03) << 4) + ((char_array_3[1] & 0xf0) >> 4);
		char_array_4[2] = ((char_array_3[1] & 0x0f) << 2) + ((char_array_3[2] & 0xc0) >> 6);
		char_array_4[3] = char_array_3[2] & 0x3f;

		for (j = 0; (j < i + 1); j++)
			ret += base64_chars[char_array_4[j]];

		while((i++ < 3))
			ret += '=';
	}

	return ret;
}

std::string CStringFilter::Base64Decode( std::string const& encoded_string )
{
	int in_len = (int)encoded_string.size();
	int i = 0;
	int j = 0;
	int in_ = 0;
	uint8 char_array_4[4], char_array_3[3];
	std::string ret;

	while (in_len-- && ( encoded_string[in_] != '=') && is_base64(encoded_string[in_])) 
	{
		char_array_4[i++] = encoded_string[in_]; in_++;
		if (i ==4) 
		{
			for (i = 0; i <4; i++)
				char_array_4[i] = (uint8)base64_chars.find(char_array_4[i]);

			char_array_3[0] = (char_array_4[0] << 2) + ((char_array_4[1] & 0x30) >> 4);
			char_array_3[1] = ((char_array_4[1] & 0xf) << 4) + ((char_array_4[2] & 0x3c) >> 2);
			char_array_3[2] = ((char_array_4[2] & 0x3) << 6) + char_array_4[3];

			for (i = 0; (i < 3); i++)
				ret += char_array_3[i];
			i = 0;
		}
	}

	if (i) 
	{
		for (j = i; j <4; j++)
			char_array_4[j] = 0;

		for (j = 0; j <4; j++)
			char_array_4[j] = (uint8)base64_chars.find(char_array_4[j]);

		char_array_3[0] = (char_array_4[0] << 2) + ((char_array_4[1] & 0x30) >> 4);
		char_array_3[1] = ((char_array_4[1] & 0xf) << 4) + ((char_array_4[2] & 0x3c) >> 2);
		char_array_3[2] = ((char_array_4[2] & 0x3) << 6) + char_array_4[3];

		for (j = 0; (j < i - 1); j++) 
			ret += char_array_3[j];
	}

	return ret;

}
//////////////////////////////////////////////////////////////////////////

void GenerateEncryptKey::Generate(uint32 seed, char* outputBuffer, uint32 len)
{
	CAesCryptography cryptObj;
	cryptObj.SetKeyValue(UniKeyDataCryptKey, sizeof(UniKeyDataCryptKey));
	char* buffer = new char[len];
	sprintf(buffer, "aekqutc8id72zty%04d", seed);
	for(uint32 i=0; i<len-1; ++i)
		buffer[i] ^= ++seed;
	cryptObj.EncryptBuffer((uint8*)buffer, len-1, (uint8*)outputBuffer);
	ConvertASCCode((uint8*)outputBuffer, len-1);
	outputBuffer[len-1] = 0;
	delete []  buffer;
}

void GenerateEncryptKey::ConvertASCCode(uint8* buffer, uint32 len)
{
	for(uint32 i=0; i<len; ++i)
	{
		buffer[i] %= 77;
		buffer[i] += 48;
		if (buffer[i] == ';')
			buffer[i] = '0';
	}
}

void GenerateEncryptKey::Generate(const std::string& seed, char* outputBuffer, uint32 len)
{
	CAesCryptography cryptObj;
	cryptObj.SetKeyValue(UniKeyDataCryptKey, sizeof(UniKeyDataCryptKey));
	char* buffer = new char[len];
	sprintf(buffer, "btuiu5cwid72zty1b3e");
	int copyLen = ((int)seed.size()>len)?len:(int)seed.size();
	for(int i=0;i<copyLen;++i)
		buffer[i] = seed.at(i);
	cryptObj.EncryptBuffer((uint8*)buffer, len-1, (uint8*)outputBuffer);
	ConvertASCCode((uint8*)outputBuffer, len-1);
	outputBuffer[len-1] = 0;
	delete []  buffer;
}

void GenerateEncryptKey::RandomGenerate(const std::string& seed, char* outputBuffer, uint32 len)
{
	CAesCryptography cryptObj;
	cryptObj.SetKeyValue(UniKeyDataCryptKey, sizeof(UniKeyDataCryptKey));
	char xorKey = rand()%128;
	char* buffer = new char[len];
	int copyLen = ((int)seed.size()>len)?len:(int)seed.size();
	for(int i=0;i<copyLen;++i)
		buffer[i] = seed.at(i);
	buffer[5] = xorKey;
	cryptObj.EncryptBuffer((uint8*)buffer, len-1, (uint8*)outputBuffer);
	ConvertASCCode((uint8*)outputBuffer, len-1);
	outputBuffer[len-1] = 0;
	delete []  buffer;
}

std::string GenerateEncryptKey::GenerateGuid()
{
	ACE_Utils::UUID newGuid;
	ACE_Utils::UUID_GENERATOR::instance()->generate_UUID(newGuid);
	std::string sessionId = newGuid.to_string()->c_str();
	return sessionId;
}