#ifndef __stringfilter_h__
#define __stringfilter_h__

#pragma once

//////////////////////////////////////////////////////////////////////////

class CStringFilter
{
public:
	CStringFilter(void);
	~CStringFilter(void);

public:
	void RemoveSpecificString( std::string& target, const std::string& remove);
	void Convert2SmallLetter(std::string& source);
	std::string Base64Encode(uint8 const* bytes_to_encode, uint32 in_len);
	std::string Base64Decode(std::string const& encoded_string);
};


//////////////////////////////////////////////////////////////////////////

class CCharactorRange
{
public:
	CCharactorRange(int bottom, int top) : m_bottom(bottom), m_top(top)
	{}

	bool IsValid(char ch)
	{
		if (m_bottom <= ch && m_top >= ch)
			return true;
		return false;
	}

private:
	int m_bottom;
	int m_top;
};

//////////////////////////////////////////////////////////////////////////

class CAbstractValidCheck
{
public:
	CAbstractValidCheck(CAbstractValidCheck* decorator, CCharactorRange* range) 
		: m_decorator(decorator), m_range(range)
	{}

	virtual ~CAbstractValidCheck()
	{
		if (NULL != m_range)
		{
			delete m_range;
			m_range = NULL;
		}
	}

	bool IsValid(std::string targetString) 
	{
		for(size_t i=0; i<targetString.length(); ++i)
		{
			if (IsValid(targetString.at(i)))
				continue;
			return false;
		}
		return true;
	}

protected:
	bool IsValid(char ch)
	{
		bool result = m_range->IsValid(ch);
		if (NULL == m_decorator)
			return result;
		else
			return (result || m_decorator->IsValid(ch));
	}

private:
	CAbstractValidCheck* m_decorator;
	CCharactorRange* m_range;
};

//////////////////////////////////////////////////////////////////////////

class CEngLowerString : public CAbstractValidCheck
{
public:
	CEngLowerString(CAbstractValidCheck* decorator) 
		: CAbstractValidCheck(decorator, new CCharactorRange(97, 122))
	{}
};

class CEngUpperString : public CAbstractValidCheck
{
public:
	CEngUpperString(CAbstractValidCheck* decorator) 
		: CAbstractValidCheck(decorator, new CCharactorRange(65, 90))
	{}
};

class CNumericString : public CAbstractValidCheck
{
public:
	CNumericString(CAbstractValidCheck* decorator) 
		: CAbstractValidCheck(decorator, new CCharactorRange(48, 58))
	{}
};

//////////////////////////////////////////////////////////////////////////

class CSymbolStringGroup0 : public CAbstractValidCheck
{
public:
	CSymbolStringGroup0(CAbstractValidCheck* decorator) 
		: CAbstractValidCheck(decorator, new CCharactorRange(33, 47))
	{}
};

class CSymbolStringGroup1 : public CAbstractValidCheck
{
public:
	CSymbolStringGroup1(CAbstractValidCheck* decorator) 
		: CAbstractValidCheck(decorator, new CCharactorRange(58, 64))
	{}
};

class CSymbolStringGroup2 : public CAbstractValidCheck
{
public:
	CSymbolStringGroup2(CAbstractValidCheck* decorator) 
		: CAbstractValidCheck(decorator, new CCharactorRange(91, 96))
	{}
};

class CSymbolStringGroup3 : public CAbstractValidCheck
{
public:
	CSymbolStringGroup3(CAbstractValidCheck* decorator) 
		: CAbstractValidCheck(decorator, new CCharactorRange(123, 126))
	{}
};

//////////////////////////////////////////////////////////////////////////

class GenerateEncryptKey
{
public:
	TAGES_EXPORT	void Generate(uint32 seed, char* outputBuffer, uint32 len);
	TAGES_EXPORT	void Generate(const std::string& seed, char* outputBuffer, uint32 len);
	TAGES_EXPORT	void RandomGenerate(const std::string& seed, char* outputBuffer, uint32 len);
	TAGES_EXPORT	std::string GenerateGuid();

protected:
	void ConvertASCCode(uint8* buffer, uint32 len);
};
//////////////////////////////////////////////////////////////////////////

#endif // __stringfilter_h__