////////////////////////////////////////////////////////////////////////////
//
//  Crytek Source File.
//  Copyright (C), Crytek Studios, 2009.
// -------------------------------------------------------------------------
//  File name:   UniKeyManager.h
//  Version:     v1.00
//  Created:     13/08/2009 by Younggi Lim
//  Compilers:   Visual Studio.NET
//  Description: make easy to use UniKey Api
// -------------------------------------------------------------------------
//  History:
//
////////////////////////////////////////////////////////////////////////////
#ifndef __unikeymanager_h__
#define __unikeymanager_h__

#pragma once

#include "LicenseServerCommon.h"

class CUserPool;
class CEncryptedLicenseData;

class CUniKeyManager
{
public:
	CUniKeyManager();
	~CUniKeyManager();

	bool	Find();
	bool	LoginUniKey();
	void	LogOffUniKey();

	TAGES_EXPORT	EPMErrorCode	LoginUser(uint32 userId, std::string key, std::string mac);
	TAGES_EXPORT	void	LogoffUser(uint32 userId);
	TAGES_EXPORT	EPMErrorCode	AuthenticateUser(uint32 userId, std::string key, std::string mac);
	TAGES_EXPORT	TimeType	GetRemainSecond(); 
	TAGES_EXPORT	void GetLicenseKey(std::string& key);

protected:
	TAGES_EXPORT	bool	ValidKey(std::string& key);
	TAGES_EXPORT	bool	ValidDate(const TimeType& start, const TimeType& expire, const TimeType& last) const;
	TAGES_EXPORT	bool	CheckUnikeyIsOn();
	TAGES_EXPORT	void	WriteLoginTime();
	TAGES_EXPORT	void	WriteValidityTime();
	uint32 GetTick();
	void ConvertToDate(const TimeType paramRemainSecond, uint32& month, uint32& day, uint32& hour);
	
private:
	uint16							m_handle;
	bool								m_unikeyOn;
	uint32							m_unikeyLastCheckTick;
	uint32							m_unikeyLoginWriteTick;
	CUserPool*					m_userPool;
	CEncryptedLicenseData* m_licenseData;
};


#endif // __unikeymanager_h__