#include "stdafx.h"
#include "UniKeyServer.h"
#include "JobQueue.h"
#include "UniKeyManager.h"

CUniKeyServer::CUniKeyServer(void) 
	: m_init(false), m_jobQueue(NULL), m_unikey(new CUniKeyManager())
{
}

CUniKeyServer::~CUniKeyServer(void)
{
	SAFE_DELETE(m_unikey);
}

bool CUniKeyServer::Init(CJobQueue* que)
{
	if (false == m_unikey->LoginUniKey())
		return false;
	m_jobQueue = que;
	m_init = true;
	return true;
}

void CUniKeyServer::Fini()
{
	if (false == m_init)
		return;

	m_unikey->LogOffUniKey();
}

void CUniKeyServer::Update()
{
	while(true)
	{
		CAbstractJob* job = m_jobQueue->PopWork(-1);
		if (NULL == job)
			break;
		job->UniKeyExecute(*m_unikey);
		job->Complete();
		delete job;
		job = NULL;
		if (m_jobQueue->Empty())
			break;
	}
}