#include "stdafx.h"
#include "UserPool.h"

CUserPool::CUserPool(void) : m_maxUser(0)
{
}

CUserPool::~CUserPool(void)
{
}

void CUserPool::SetMaxUser( uint32 maxUser )
{
	m_maxUser = maxUser;
	AdjustUserCount();
}

bool CUserPool::Login( uint32 userId, std::string mac )
{
	if (m_userContainer.size() >= m_maxUser)
		return false;

	m_userContainer.insert(std::make_pair(userId, mac));
	return true;
}

void CUserPool::Logoff( uint32 userId)
{
	if (m_userContainer.size() <= 0)
		return;

	UserPoolIterator remove = m_userContainer.find(userId);
	if (m_userContainer.end() == remove)
		return;

	m_userContainer.erase(remove);
}

bool CUserPool::Authenticate( uint32 userId, std::string mac )
{
	UserPoolIterator iter = m_userContainer.find(userId);
	if (m_userContainer.end() == iter)
		return false;
	if (iter->second != mac)
		return false;

	return true;
}

void CUserPool::AdjustUserCount()
{
	while (m_userContainer.size() > m_maxUser)
	{
		UserPoolIterator iter = m_userContainer.begin();
		if (iter == m_userContainer.end())
			break;

		Logoff(iter->first);
		if (m_userContainer.size() <= 0)
			break;
	} 
}