#ifndef __userpool_h__
#define __userpool_h__

#pragma once

#include <map>

class CUserPool
{
public:
	typedef std::map<uint32, std::string> UserPoolType;
	typedef UserPoolType::iterator				UserPoolIterator;
	typedef UserPoolType::const_iterator	UserPoolConstIterator;

	CUserPool(void);
	~CUserPool(void);

	TAGES_EXPORT	void SetMaxUser(uint32 maxUser);
	TAGES_EXPORT	bool Login(uint32 userId, std::string mac);
	TAGES_EXPORT	void Logoff(uint32 userId);
	TAGES_EXPORT	bool Authenticate(uint32 userId, std::string mac);

protected:
	TAGES_EXPORT	void AdjustUserCount();

private:
	uint32				m_maxUser;
	UserPoolType	m_userContainer;
};

#endif // __userpool_h__