// MySQLReplicater.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include "ReplicateDBJob.h"
#include "ProtocolBuilder.h"

bool	ReplicateDB()
{
	const char* ConfigFilename = "MySQLReplicaterConfig.txt";
	FILE* r = fopen(ConfigFilename, "rb");
	if (NULL == r)
	{
		printf("Cannot find %s.\n", ConfigFilename);
		return false;
	}

	const int MaxConfigFileLength = 1024*4;
	char* fileBuffer = new char[MaxConfigFileLength];
	size_t fileSize = fread(fileBuffer, 1, MaxConfigFileLength, r);
	fclose(r);

	std::string readString(fileBuffer, fileSize);
	delete [] fileBuffer;
	while ( readString.find("\r\n") != std::string::npos )
	{
		readString.erase ( readString.find ("\r\n"), 2 );
	}

	CProtocolBuilder builder;
	builder.Parse(readString);
	std::string srcDBIp = builder.GetValue<std::string>("SrcDBIp");
	int srcDBPort = builder.GetValue<uint32>("SrcDBPort");
	std::string srcDBUser = builder.GetValue<std::string>("SrcDBUser");
	std::string srcDBPass = builder.GetValue<std::string>("SrcDBPass");
	std::string srcDefaultDB = builder.GetValue<std::string>("SrcDefaultDB");
	std::string dstDBIp = builder.GetValue<std::string>("DstDBIp");
	int dstDBPort = builder.GetValue<uint32>("DstDBPort");
	std::string dstDBUser = builder.GetValue<std::string>("DstDBUser");
	std::string dstDBPass = builder.GetValue<std::string>("DstDBPass");
	std::string dstDefaultDB = builder.GetValue<std::string>("DstDefaultDB");

	printf("Initialize database.\n");
	CMySQLConnection connSrc;
	CMySQLConnection connDst;
	connSrc.Init();
	connDst.Init();
	printf("Connect source database(%s).\n", srcDBIp.c_str());
	bool result = connSrc.Connect(srcDBIp.c_str(), srcDBPort, srcDBUser.c_str(), srcDBPass.c_str(), srcDefaultDB.c_str());
	if (false == result)
	{
		printf("Connect database fail(%s).\n", srcDBIp.c_str());
		return false;
	}
	printf("Connect source database success.\n");

	printf("Connect destination database(%s).\n", dstDBIp.c_str());
	result = connDst.Connect(dstDBIp.c_str(), dstDBPort, dstDBUser.c_str(), dstDBPass.c_str(), dstDefaultDB.c_str());
	if (false == result)
	{
		printf("Connect database fail(%s).\n", dstDBIp.c_str());
		return false;
	}
	printf("Connect destination database success.\n");
	
	CReplicateJob job(connSrc, connDst);
	int tableIndex = 0;
	while(true)
	{
		char fieldName[32] = {0,};
		sprintf(fieldName, "Table%d", tableIndex);
		std::string targetTable = builder.GetValue<std::string>(fieldName);
		if (targetTable.empty())
			break;
		printf("Target table(%s)\n", targetTable.c_str());
		job.AddTable(targetTable.c_str());
		++tableIndex;
	}

	printf("Check table exist.\n");
	result = job.ExistTables();
	if (result)
	{
		printf("Table exists on target database(%s). Drop it(Y/N)?", dstDBIp.c_str());
		char inputChar = getchar();
		if ('Y' == inputChar || 'y' == inputChar)
		{
			job.DropTables();
			printf("Table droped.\n");
		}
		else
		{
			printf("Canceled.\n");
		}
	}

	printf("Copy table start.\n");
	result = job.CopyTables();
	if (false == result)
		printf("Copy table fail.\n");
	else
		printf("Copy table success.\n");

	printf("Disconnect databases.\n");
	connSrc.Disconnect();
	connDst.Disconnect();
	return result;
}

int main(int argc, char* argv[])
{
	if (ReplicateDB())
		printf("MySQL database replicate success.\n");
	else
		printf("MySQL database replicate fail.\n");

	printf("Press any key.\n");
	getchar();
	getchar();

	//ALTER TABLE SF_COMPANY RENAME sf_company; 
	//ALTER TABLE SF_LICENSE_KEYS_ASSIGNED RENAME sf_license_keys_assigned; 
	//ALTER TABLE SF_LICENSE_KEYS_GENERATED RENAME sf_license_keys_generated; 
	//ALTER TABLE SF_COMPANY_RIGHTS RENAME sf_company_rights; 
	return 0;
}

