#include "stdafx.h"
#include "ReplicateDBJob.h"
#include <algorithm>

//////////////////////////////////////////////////////////////////////////

CReplicateJob::CReplicateJob(CMySQLConnection& src, CMySQLConnection& dst) : 
		m_connSrc(src), 
		m_connDst(dst)
{
}

CReplicateJob::~CReplicateJob()
{
}

void CReplicateJob::AddTable( const char* tablename )
{
	std::vector<std::string>::iterator iter = find(m_tableList.begin(), m_tableList.end(), tablename);
	if (iter != m_tableList.end())
		return;
	m_tableList.push_back(tablename);
}

bool CReplicateJob::ExistTables()
{
	std::vector<std::string>::iterator currentIter = m_tableList.begin();
	std::vector<std::string>::iterator endIter = m_tableList.end();
	while(currentIter != endIter)
	{
		if (ExistTable(currentIter->c_str()))
			return true;
		++currentIter;
	}
	return false;
}

bool CReplicateJob::ExistTable(const char* tablename )
{
	char query[256] = {0,};
	sprintf(query, "show tables like '%s';", tablename);
	bool result = m_connDst.ExecuteQuery(query, false);
	if (false == result)
		return false;

	result = m_connDst.StoreResult();
	if (false == result)
		return false;

	bool retResult = false;
	while(m_connDst.FetchRow())
	{
		int index = 0;
		char tables[64] = {0,};
		if ( false == m_connDst.GetData(index++, tables))
			break;

		retResult = true;
	}
	m_connDst.FreeResult();
	return retResult;

}

bool CReplicateJob::DropTables()
{
	std::vector<std::string>::iterator currentIter = m_tableList.begin();
	std::vector<std::string>::iterator endIter = m_tableList.end();
	while(currentIter != endIter)
	{
		DropTable(currentIter->c_str());
		++currentIter;
	}
	return true;
}

bool CReplicateJob::DropTable( const char* tablename )
{
	char query[256] = {0,};
	sprintf(query, "drop table %s;", tablename);
	return m_connDst.ExecuteQuery(query, false);
}

bool CReplicateJob::CopyTables()
{
	std::vector<std::string>::iterator currentIter = m_tableList.begin();
	std::vector<std::string>::iterator endIter = m_tableList.end();
	while(currentIter != endIter)
	{
		if (false == CopyTableOnly(currentIter->c_str()))
			return false;
		if (false == CopyTableData(currentIter->c_str()))
			return false;
		++currentIter;
	}
	return true;
}

bool CReplicateJob::CopyTableOnly( const char* tablename )
{
	printf("Create table(%s) on destination database.\n", tablename);
	char query[256] = {0,};
	char tableCreateQuery[1024*2] = {0,};
	sprintf(query, "show create table %s;", tablename);
	bool result = m_connSrc.ExecuteQuery(query, false);
	if (false == result)
		return false;

	result = m_connSrc.StoreResult();
	if (false == result)
		return false;

	bool retResult = false;
	while(m_connSrc.FetchRow())
	{
		char tablename[64] = {0,};
		int index = 0;
		
		if ( false == m_connSrc.GetData(index++, tablename))
			break;
		if ( false == m_connSrc.GetData(index++, tableCreateQuery))
			break;

		retResult = true;
	}
	m_connSrc.FreeResult();

	result = m_connDst.ExecuteQuery(tableCreateQuery, false);
	if (false == result)
		return false;

	return true;
}

bool CReplicateJob::CopyTableData( const char* tablename )
{
	printf("Copy table(%s) on destination database.\n", tablename);
	char query[256] = {0,};
	sprintf(query, "select * from %s;", tablename);
	bool result = m_connSrc.ExecuteQuery(query, false);
	if (false == result)
		return false;

	result = m_connSrc.StoreResult();
	if (false == result)
		return false;

	unsigned int fieldCount = m_connSrc.GetFieldCount();
	bool retResult = false;
	while(m_connSrc.FetchRow())
	{
		ResetFieldPartString();
		ResetValuePartString();
		bool isNumeric = false;
		int index = 0;
		for(unsigned int i=0; i<fieldCount; ++i)
		{
			int fieldLength = m_connSrc.GetFieldNameLength(index);
			int valueLength = m_connSrc.GetFieldValueLength(index);
			char* fieldName = new char[fieldLength+4];
			char* fieldValue = new char[valueLength+4];
			memset(fieldName, 0, fieldLength);
			memset(fieldValue, 0, valueLength);

			if ( false == m_connSrc.GetFieldInfo(index++, fieldName, fieldValue, isNumeric))
				break;

			BuildFieldPartString(fieldName);
			BuildValuePartString(fieldValue, isNumeric);
			delete [] fieldName;
			delete [] fieldValue;
			fieldName	= NULL;
			fieldValue = NULL;
		}

		m_fieldPartString.erase(m_fieldPartString.length()-2, 2);
		m_valuePartString.erase(m_valuePartString.length()-2, 2);
		size_t QueryLength = m_fieldPartString.length() + m_valuePartString.length() + 256;
		std::string insertQueryString;
		insertQueryString.reserve(QueryLength);
		insertQueryString = "INSERT INTO ";
		insertQueryString += tablename;
		insertQueryString += "(";
		insertQueryString += m_fieldPartString;
		insertQueryString += ") ";
		insertQueryString += "VALUES(";
		insertQueryString += m_valuePartString;
		insertQueryString += ");";

		result = m_connDst.ExecuteQuery(insertQueryString.c_str(), false);
	}
	m_connSrc.FreeResult();

	return true;
}

void CReplicateJob::BuildFieldPartString( const char* fieldName)
{
	m_fieldPartString += fieldName;
	m_fieldPartString += ", ";
}

void CReplicateJob::BuildValuePartString( const char* fieldValue, bool isNumeric)
{
	if (false == isNumeric)
		m_valuePartString += "'";
	m_valuePartString += fieldValue;

	if (false == isNumeric)
		m_valuePartString += "'";
	m_valuePartString += ", ";
}

void CReplicateJob::ResetFieldPartString()
{
	m_fieldPartString.clear();
}

void CReplicateJob::ResetValuePartString()
{
	m_valuePartString.clear();
}