#ifndef __licensedbjob_h__
#define __licensedbjob_h__

#pragma once

#include <string>
#include <vector>
#include "MySQLConnection.h"

//////////////////////////////////////////////////////////////////////////
class CReplicateJob
{
public:
	CReplicateJob(CMySQLConnection& src, CMySQLConnection& dst);
	virtual ~CReplicateJob();

public:
	void	AddTable(const char* tablename);
	bool	ExistTables();
	bool	DropTables();
	bool	CopyTables();
	

protected:
	bool	ExistTable(const char* tablename);
	bool	DropTable(const char* tablename);
	bool	CopyTableOnly(const char* tablename);
	bool	CopyTableData(const char* tablename);

	void	ResetFieldPartString();
	void	ResetValuePartString();
	void	BuildFieldPartString(const char* fieldName);
	void	BuildValuePartString(const char* fieldValue, bool isNumeric);
	
private:
	CMySQLConnection& m_connDst;
	CMySQLConnection& m_connSrc;
	std::vector<std::string>	m_tableList;

	std::string	m_fieldPartString;
	std::string	m_valuePartString;
};


#endif // __licensedbjob_h__