////////////////////////////////////////////////////////////////////////////
//
//  Crytek Source File.
//  Copyright (C), Crytek Studios, 2009.
// -------------------------------------------------------------------------
//  File name:   CachedLicense.h
//  Version:     v1.00
//  Created:     28/08/2009 by Younggi Lim
//  Compilers:   Visual Studio.NET
//  Description: license authenticate without internet connection
// -------------------------------------------------------------------------
//  History:
//
////////////////////////////////////////////////////////////////////////////

#include "StdAfx.h"

//#ifdef USING_LICENSE_PROTECTION

#include <time.h>
#include "CachedLicense.h"
#include "AesCryptography.h"

const uint8 CachedLicenseCryptKey[] = {0x28, 0x3E, 0xD4, 0xAA, 0x72, 0x16, 0x1E, 0x2B};

CCachedLicense::CCachedLicense(void) : m_cryptObj(new CAesCryptography()), m_load(false), m_validCheckSum(false)
{
	m_cryptObj->SetKeyValue(CachedLicenseCryptKey, sizeof(CachedLicenseCryptKey));
	srand((unsigned int)time(NULL));
}

CCachedLicense::~CCachedLicense(void)
{
	if (NULL != m_cryptObj)
	{
		delete m_cryptObj;
		m_cryptObj = NULL;
	}
}

bool CCachedLicense::MakeFile( const char* filename, uint32 remainSecond, const char* licenseKey, const char* ip, const char* mac ) const
{
	remove(filename);
	FILE* r = NULL;
	errno_t err = fopen_s(&r, filename, "wb");
	if (0 != err)
		return false;
	const uint32 LicenseDataSize = sizeof(SCachedLicenseInfo);
	const uint32 LicenseFileSize = LicenseDataSize+sizeof(uint16);
	uint8* fileBuffer = new uint8[LicenseFileSize];
	memset(fileBuffer, 0, LicenseFileSize);
	SCachedLicenseInfo licenseInfo;
	time(&licenseInfo.startTime);
	licenseInfo.expireTime = licenseInfo.startTime+remainSecond;
	strcpy_s(licenseInfo.licenseKey, 64, licenseKey);
	strcpy_s(licenseInfo.ip, 17, ip);
	strcpy_s(licenseInfo.mac, 18, mac);

	MakeRandomBuffer(licenseInfo.dummyData0, DummyDataLength0);
	MakeRandomBuffer(licenseInfo.dummyData1, DummyDataLength1);
	MakeRandomBuffer(licenseInfo.dummyData2, DummyDataLength2);
	MakeRandomBuffer(licenseInfo.dummyData3, DummyDataLength3);
	MakeRandomBuffer(licenseInfo.dummyData4, DummyDataLength4);

	uint16 checkSum = ComputeCheckSum((const char*)&licenseInfo, LicenseDataSize);
	m_cryptObj->EncryptBuffer((uint8*)&licenseInfo, LicenseDataSize, (uint8*)fileBuffer);
	memcpy(&fileBuffer[LicenseDataSize], &checkSum, sizeof(uint16));
	uint32 writeBufferSize = fwrite(fileBuffer, 1, LicenseFileSize, r);
	fclose(r);
	delete [] fileBuffer;
	return true;
}

bool CCachedLicense::LoadFile( const char* filename )
{
	FILE* r = NULL;
	errno_t err = fopen_s(&r, filename, "rb");
	if (0 != err)
		return false;

	const uint32 LicenseDataSize = sizeof(SCachedLicenseInfo);
	const uint32 LicenseFileSize = LicenseDataSize+sizeof(uint16);
	uint8* fileBuffer = new uint8[LicenseFileSize];
	memset(fileBuffer, 0, LicenseFileSize);
	uint32 readBufferSize = fread(fileBuffer, 1, LicenseFileSize, r);
	if (readBufferSize != LicenseFileSize)
	{
		delete [] fileBuffer;
		fclose(r);
		return false;
	}
	memset(&m_licenseInfo, 0, LicenseDataSize);
	m_cryptObj->DecryptBuffer((uint8*)fileBuffer, LicenseDataSize, (uint8*)&m_licenseInfo);

	uint16 savedCheckSum = 0;
	memcpy(&savedCheckSum, &fileBuffer[LicenseDataSize], sizeof(uint16));
	uint16 computedCheckSum = ComputeCheckSum((const char*)&m_licenseInfo, LicenseDataSize);
	if (computedCheckSum == savedCheckSum)
		m_validCheckSum = true;
	fclose(r);
	delete [] fileBuffer;
	m_load = true;
	return true;
}

void CCachedLicense::MakeRandomBuffer( char* buffer, uint32 len ) const
{
	for(uint32 i=0; i<len; ++i)
		buffer[i] = rand();
}

bool CCachedLicense::ValidLicense( const char* licenseKey, const char* ip, const char* mac ) const
{
	if (false == m_load)
		return false;
	if (false == m_validCheckSum)
		return false;
	if ( 0 != strcmp(licenseKey, m_licenseInfo.licenseKey) )
		return false;
	if ( 0 != strcmp(ip, m_licenseInfo.ip) )
		return false;
	if ( 0 != strcmp(mac, m_licenseInfo.mac) )
		return false;

	time_t currentTime;
	time(&currentTime);
	if (m_licenseInfo.expireTime <= currentTime)
		return false;
	if (m_licenseInfo.startTime > currentTime)
		return false;

	return true;
}

uint16 CCachedLicense::ComputeCheckSum( const char* buffer, uint32 len ) const
{
	uint32 result = 0;
	for(uint32 i=0;i<len;++i)
	{
		result += buffer[i];
		if (USHRT_MAX <= result)
			result %= USHRT_MAX;
	}
	result ^= 12731;
	return (uint16)result;
}

//#endif // USING_LICENSE_PROTECTION