////////////////////////////////////////////////////////////////////////////
//
//  Crytek Source File.
//  Copyright (C), Crytek Studios, 2009.
// -------------------------------------------------------------------------
//  File name:   CachedLicense.h
//  Version:     v1.00
//  Created:     28/08/2009 by Younggi Lim
//  Compilers:   Visual Studio.NET
//  Description: license authenticate without internet connection
// -------------------------------------------------------------------------
//  History:
//
////////////////////////////////////////////////////////////////////////////
#ifndef __cachedlicense_h__
#define __cachedlicense_h__

#pragma once

//#ifdef USING_LICENSE_PROTECTION

const uint32 DummyDataLength0 = 223;
const uint32 DummyDataLength1 = 1032;
const uint32 DummyDataLength2 = 779;
const uint32 DummyDataLength3 = 592;
const uint32 DummyDataLength4 = 376;

class CAesCryptography;

class CCachedLicense
{
public:
	struct SCachedLicenseInfo
	{
		time_t startTime;
		char dummyData0[DummyDataLength0];
		time_t expireTime;
		char dummyData1[DummyDataLength1];
		char licenseKey[64];
		char dummyData2[DummyDataLength2];
		char ip[17];
		char dummyData3[DummyDataLength3];
		char mac[18];
		char dummyData4[DummyDataLength4];
	};
	
	CCachedLicense();
	virtual ~CCachedLicense();

	bool	MakeFile(const char* filename, uint32 remainSecond, const char* licenseKey, const char* ip, const char* mac) const;
	bool	LoadFile(const char* filename);
	bool	ValidLicense(const char* licenseKey, const char* ip, const char* mac) const;

protected:
	void	MakeRandomBuffer(char* buffer, uint32 len) const;
	uint16	ComputeCheckSum(const char* buffer, uint32 len) const;

private:
	CAesCryptography*		m_cryptObj;
	SCachedLicenseInfo	m_licenseInfo;
	bool								m_load;
	bool								m_validCheckSum;
};

//#endif // USING_LICENSE_PROTECTION

#endif // __cachedlicense_h__
