#include <stdafx.h>

#include "ProtectionManager.h"
#include "LicenseConnection.h"
#include "CachedLicense.h"
#include <Windows.h>
#include "ProtocolBuilder.h"

#define LICENSE_SERVER_IP "127.0.0.1"
const char* CachedLicenseFile = "SandboxCachedLicense.dat";
const uint32	CachedLicenseFileMakeTerm = 20*1000;	// 10 second

static const std::string base64_chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";


std::string Base64Encode(const char* pBytesToEncode) 
{
	unsigned int in_len = (uint32)strlen(pBytesToEncode);

	std::string ret;
	int i = 0;
	int j = 0;
	unsigned char char_array_3[3];
	unsigned char char_array_4[4];

	while (in_len--) 
	{
		char_array_3[i++] = (unsigned char)*(pBytesToEncode++);
		if (i == 3) {
			char_array_4[0] = (char_array_3[0] & 0xfc) >> 2;
			char_array_4[1] = ((char_array_3[0] & 0x03) << 4) + ((char_array_3[1] & 0xf0) >> 4);
			char_array_4[2] = ((char_array_3[1] & 0x0f) << 2) + ((char_array_3[2] & 0xc0) >> 6);
			char_array_4[3] = char_array_3[2] & 0x3f;

			for(i = 0; (i <4) ; i++)
				ret += base64_chars[char_array_4[i]];
			i = 0;
		}
	}

	if (i)
	{
		for(j = i; j < 3; j++)
			char_array_3[j] = '\0';

		char_array_4[0] = (char_array_3[0] & 0xfc) >> 2;
		char_array_4[1] = ((char_array_3[0] & 0x03) << 4) + ((char_array_3[1] & 0xf0) >> 4);
		char_array_4[2] = ((char_array_3[1] & 0x0f) << 2) + ((char_array_3[2] & 0xc0) >> 6);
		char_array_4[3] = char_array_3[2] & 0x3f;

		for (j = 0; (j < i + 1); j++)
			ret += base64_chars[char_array_4[j]];

		while((i++ < 3))
			ret += '=';

	}

	return ret;
}

//////////////////////////////////////////////////////////////////////////
CProtectionManager::CProtectionManager() 
	:	m_licenseConnection(new CLicenseConnection()), 
	m_lastCachedLicenseFileMakeTick(0)
{
}


//////////////////////////////////////////////////////////////////////////
CProtectionManager::~CProtectionManager()
{
	CloseLicenseServerConnection();
	if (NULL != m_licenseConnection)
	{
		delete m_licenseConnection;
		m_licenseConnection = NULL;
	}
}


//////////////////////////////////////////////////////////////////////////
bool CProtectionManager::GetKeyFromRegistry(string& sKey)
{
	sKey = "5DB6-8428-80B6-6D21";
	return true;
	//CEngineSettingsManager esm;
	//if (!esm.HasKey("EDT_InstanceKey"))
	//	return false;

	//esm.GetValueByRef("EDT_InstanceKey",sKey);
	//return true;
}

bool CProtectionManager::GetLocalIPAddress(string& ip)
{
	return true;
}

bool CProtectionManager::GetLocalMacAddress(string& mac)
{
	return true;
}


//////////////////////////////////////////////////////////////////////////
int CProtectionManager::ConnectToLicenseServer()
{
	string ip = LICENSE_SERVER_IP;
	int port = 25379;

	//ICVar* pIPCVar = gEnv->pConsole->GetCVar("net_proxy_ip");
	//if (pIPCVar && strlen(pIPCVar->GetString())>0)
	//	ip = pIPCVar->GetString();
	//ICVar* pPortCVar = gEnv->pConsole->GetCVar("net_proxy_port");
	//if (pPortCVar && pPortCVar->GetIVal())
	//	port = pPortCVar->GetIVal();

	//if (false == m_clientSocket->InitSocket())
	//	return 2;
	//if (false == m_clientSocket->Connect(ip.c_str(), port))
	//	return 3;

	return 0;
}


//////////////////////////////////////////////////////////////////////////
void CProtectionManager::CloseLicenseServerConnection()
{
	//m_clientSocket->FiniSocket();
}


EPMErrorCode CProtectionManager::RetrieveClientDataNew( SClientData &data )
{
	string ip, strPort;
	if (!SetupConnectionInfoFromRegistry(data.sKey, ip, strPort))
		return PMEC_KEY_NOT_FOUND;
	int port = atoi(strPort.c_str());
	EPMErrorCode retCode = PMEC_NO_ERROR;
	retCode = ServerAuthenticate(data.sKey, ip, port);
	if (PMEC_NO_ERROR == retCode)
		return retCode;

#ifdef USING_CACHED_LICENSE
	bool cachedResule = CachedAuthenticate(data.sKey);
	if (cachedResule)
		return PMEC_NO_ERROR;
#endif
	return retCode;
}

bool CProtectionManager::SetupConnectionInfoFromRegistry(string& sKey, string& serverIp, string& serverPort)
{
	FILE* r = fopen("SandboxClientConfig.txt", "rb");
	if (NULL == r)
		return false;

	const int BufferMax = 1024;
	char* fileBuffer = new char[BufferMax];
	size_t fileSize = fread(fileBuffer, 1, BufferMax, r);
	fclose(r);

	std::string readString(fileBuffer, fileSize);
	delete [] fileBuffer;
	while ( readString.find("\r\n") != std::string::npos )
	{
		readString.erase ( readString.find ("\r\n"), 2 );
	}

	CProtocolBuilder builder;
	builder.Parse(readString);
	sKey = builder.GetValue<std::string>("LicenseKey");
	serverIp = builder.GetValue<std::string>("ServerIp");
	serverPort = builder.GetValue<std::string>("ServerPort");
	m_username = builder.GetValue<std::string>("Username");
	m_password = builder.GetValue<std::string>("Password");
	m_application = builder.GetValue<std::string>("Application");

	std::string net_proxy_ip = builder.GetValue<std::string>("net_proxy_ip");
	if (false == net_proxy_ip.empty())
	{
		std::string sAuthUser = builder.GetValue<std::string>("net_proxy_user");
		std::string sAuthPass = builder.GetValue<std::string>("net_proxy_pass");
		std::string sAuthUserPass = sAuthUser+":"+sAuthPass;
		std::string sAuthInfo;
		if (false == sAuthUser.empty())
			sAuthInfo = Base64Encode(sAuthUserPass.c_str());
		std::string sProxyPort = builder.GetValue<std::string>("net_proxy_port");
		int proxyPort = atoi(sProxyPort.c_str());

		m_licenseConnection->SetProxy(net_proxy_ip, proxyPort, sAuthInfo);
	}
	return true;
}

EPMErrorCode CProtectionManager::ServerAuthenticate( const string& key, const string& ip, int port )
{
	if (false == m_username.empty())
		m_licenseConnection->SetAccountInfo(m_username, m_password);
	m_licenseConnection->SetConnectionInfo(ip.c_str(), port);
	m_licenseConnection->SetAppName(m_application);
	m_licenseConnection->SetVersion("0.0.2");
	EPMErrorCode retCode = m_licenseConnection->Authenticate(key.c_str());
	if (PMEC_NO_ERROR == retCode)
	{
		string key;
		m_licenseConnection->GetLicenseKey(key);
		//WriteLicenseKeyToRegistry(key);
#ifdef USING_CACHED_LICENSE
		MakeCachedLicenseFile(key, m_licenseConnection->GetRemainSecond());
#endif
	}
	else
	{
		uint32 ms = m_licenseConnection->GetDisconnectedPeriod();
		uint32 sec = ms/1000; 
		printf("Disconnected Period(%d sec, %d ms)\n", sec, ms);
	}
	return retCode;
}

bool CProtectionManager::CachedAuthenticate( const string& key )
{
	string localIp, localMac;
	GetLocalIPAddress(localIp);
	GetLocalMacAddress(localMac);
	char szAdjustedPath[1024] = {0,};
	MakeUserPath(CachedLicenseFile, szAdjustedPath);

	CCachedLicense cachedLicense;
	if (false == cachedLicense.LoadFile(szAdjustedPath))
		return false;
	return cachedLicense.ValidLicense(key.c_str(), localIp.c_str(), localMac.c_str());
}

void CProtectionManager::MakeCachedLicenseFile( const string& key, uint32 remainSecond )
{
	if (0 == remainSecond)
		return;

	uint32 currentTick = GetTickCount();
	if (0 == m_lastCachedLicenseFileMakeTick)
		m_lastCachedLicenseFileMakeTick = currentTick-CachedLicenseFileMakeTerm;
	if ((currentTick-m_lastCachedLicenseFileMakeTick) < CachedLicenseFileMakeTerm)
		return;

	m_lastCachedLicenseFileMakeTick = currentTick;

	string localIp, localMac;
	GetLocalIPAddress(localIp);
	GetLocalMacAddress(localMac);

	CCachedLicense cachedLicense;
	char szAdjustedPath[1024] = {0,};
	MakeUserPath(CachedLicenseFile, szAdjustedPath);
	cachedLicense.MakeFile(
		szAdjustedPath, 
		remainSecond, 
		key.c_str(), 
		localIp.c_str(), 
		localMac.c_str());
}

void CProtectionManager::MakeUserPath( const char* filename, char* newPath )
{
	strcpy(newPath, filename);
}

uint32 CProtectionManager::GetDisconnectedPeriod()
{
	return m_licenseConnection->GetDisconnectedPeriod();
}

ECreateAccountResult CProtectionManager::RequestCreateAccount( const SCreateAccountParam& param )
{
	return m_licenseConnection->RequestCreateAccount(param);
}

ELoginAccountResult CProtectionManager::RequestLoginAccount()
{
	bool agreeLicenseFlag = false;
	return m_licenseConnection->RequestLoginAccount(m_username, m_password, agreeLicenseFlag);
}

bool CProtectionManager::RequestPasswordRemind()
{
	//"younggi@crytek.de"
	return m_licenseConnection->RequestPasswordRemind(m_username, "");
}