#pragma once
#include "LicenseServerCommon.h"
using namespace std;

// Data which is filled partially on client side and completed from license server side.
struct SClientData
{
	string sKey;
	unsigned int iRemainingDays;
	string sVersion;
};

class CLicenseConnection;

// For interface description, see IProtectionManager
class CProtectionManager
{
public:
	CProtectionManager();
	~CProtectionManager();

	EPMErrorCode	RetrieveClientDataNew(SClientData &data);
	uint32				GetDisconnectedPeriod();
	ECreateAccountResult RequestCreateAccount( const SCreateAccountParam& param);
	ELoginAccountResult RequestLoginAccount();
	bool RequestPasswordRemind();

private:

	// System information

	bool	GetKeyFromRegistry(string& sKey);
	bool	GetLocalIPAddress(string& ip);
	bool	GetLocalMacAddress(string& mac);
	bool	SetupConnectionInfoFromRegistry(string& sKey, string& serverIp, string& serverPort);
	EPMErrorCode	ServerAuthenticate(const string& key, const string& ip, int port);
	bool					CachedAuthenticate(const string& key);
	void					MakeUserPath( const char* filename, char* newPath );
	void					MakeCachedLicenseFile(const string& key, uint32 remainSecond);
	// Server communication

	int					ConnectToLicenseServer();
	void					CloseLicenseServerConnection();
	EPMErrorCode			RegisterClientWithKeyOld(SClientData& data, const string& ip, const string& mac);

private:
	CLicenseConnection*		m_licenseConnection;
	uint32			m_lastCachedLicenseFileMakeTick;
	std::string	m_username;
	std::string	m_password;
	std::string	m_application;
};


