// SandboxClient.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include "ProtectionManager.h"
//#include <Windows.h>
#include <ace/ACE.h>

#define EnumToString(x) (#x)

void ShowProtectionErrorMessage(EPMErrorCode pmec);
void GetSpecificErrorMessage( EPMErrorCode errorCode, char* titleMsg, char* captionMsg );

int _tmain(int argc, _TCHAR* argv[])
{
	ACE::init();
	SClientData clientData;
	CProtectionManager protectionMgr;
	//if (PMEC_NO_ERROR != protectionMgr.RetrieveClientDataNew(clientData))
	//{
	//	printf("Autheticate fail at startup.\n");
	//	getchar();
	//	return 0;
	//}

	while(true)
	{
		Sleep(1000);
		EPMErrorCode retcode = protectionMgr.RetrieveClientDataNew(clientData);

		if ( PMEC_NO_ERROR == retcode)
		{
			printf("Autheticate success.\n");
			continue;
		}
		printf("Error code %d\n", retcode);
		if ( PMEC_REQUEST_ACCOUNTLOGIN == retcode)
		{
			protectionMgr.RequestLoginAccount();
			continue;
			//protectionMgr.RequestPasswordRemind();
			//break;
			
		}
		//const unsigned int FifteenMinute = 15*1000*60;
		const unsigned int FifteenMinute = 1000*10;
		//const unsigned int FifteenMinute = 30*1000;
		if (PMEC_CONNECT_FAILED==retcode && protectionMgr.GetDisconnectedPeriod()<FifteenMinute)
			continue;
		ShowProtectionErrorMessage(retcode);

		if (PMEC_NO_ERROR != retcode)
			break;
		
	}
	getchar();
	ACE::fini();
	return 0;
}

void ShowProtectionErrorMessage(EPMErrorCode errorCode)
{
	const int ErrorMessageSize = 1024;
	char titleErrorMessage[ErrorMessageSize] = {0,};
	char captionErrorMessage[ErrorMessageSize] = {0,};
	GetSpecificErrorMessage(errorCode, titleErrorMessage, captionErrorMessage);
	MessageBox(0, captionErrorMessage, titleErrorMessage, MB_ICONINFORMATION | MB_OK | MB_APPLMODAL | MB_TOPMOST);
}

void GetSpecificErrorMessage( EPMErrorCode errorCode, char* titleMsg, char* captionMsg )
{
	const char* ValidationErrorMsg = "Your License could not be validated.\nIn order to help you solving any connectivity issues, please provide the error code in the title of this dialog.";
	if (PMEC_CONNECT_FAILED == errorCode)
	{
		strcpy(captionMsg, "Could not connect to the License Server. Please establish an internet connection.\nIf you still cannot connect, check your firewall or contact Crytek to resolve this issue.");
		strcpy(titleMsg, "Connection Error 0x100");
	}
	else if (PMEC_PROXY_CONNECT_FAILED == errorCode)
	{
		strcpy(captionMsg, "Could not authenticate at proxy. Please verify your proxy settings.\nIf you still cannot connect, check your firewall or contact Crytek to resolve this issue.");
		strcpy(titleMsg, "Connection Error 0x110");
	}	
	else if (PMEC_CANT_WRITE_TO_SOCKET == errorCode)
	{
		strcpy(captionMsg, "Could not write to the License Server. Please check your firewall or contact Crytek to resolve this issue.");
		strcpy(titleMsg, "Connection Error 0x200");
	}
	else if (PMEC_CANT_READ_FROM_SOCKET == errorCode)
	{
		strcpy(captionMsg, "Could not read from the License Server. Please check your firewall or contact Crytek to resolve this issue.");
		strcpy(titleMsg, "Connection Error 0x300");
	}
	else if (PMEC_NETWORK_DEVICE == errorCode)
	{
		strcpy(captionMsg, "Could not find your network device.\nPlease check your device or contact Crytek to resolve this issue.");
		strcpy(titleMsg, "Connection Error 0x400");
	}	
	else if (PMEC_KEY_EXPIRED == errorCode)
	{
		strcpy(captionMsg, ValidationErrorMsg);
		strcpy(titleMsg, "Validation Error 0x100");
	}
	else if (PMEC_KEY_INVALID == errorCode)
	{
		strcpy(captionMsg, ValidationErrorMsg);
		strcpy(titleMsg, "Validation Error 0x200");
	}
	else if (PMEC_INVALID_TIMEFRAME == errorCode)
	{
		strcpy(captionMsg, ValidationErrorMsg);
		strcpy(titleMsg, "Validation Error 0x300");
	}
	else if (PMEC_KEY_NOT_FOUND == errorCode)
	{
		strcpy(captionMsg, ValidationErrorMsg);
		strcpy(titleMsg, "Validation Error 0x400");
	}
	else if (PMEC_OVER_CONNECTION == errorCode)
	{
		strcpy(captionMsg, ValidationErrorMsg);
		strcpy(titleMsg, "Validation Error 0x500");
	}
	else if (PMEC_NO_DONGLE == errorCode)
	{
		strcpy(captionMsg, ValidationErrorMsg);
		strcpy(titleMsg, "Validation Error 0x600");
	}
	else if (PMEC_INVALID_ADDRESS == errorCode)
	{
		strcpy(captionMsg, ValidationErrorMsg);
		strcpy(titleMsg, "Validation Error 0x700");
	}
	else if (PMEC_REGISTRY_NOT_FOUND == errorCode)
	{
		strcpy(captionMsg, "Could not find a valid License Information. Please run SettingsMgr or Sandbox to validate your CryENGINE installation.");
		strcpy(titleMsg, "Validation Error 0x800");
	}
	else if (PMEC_DOUBLE_LOGIN == errorCode)
	{
		strcpy(captionMsg, ValidationErrorMsg);
		strcpy(titleMsg, "Validation Error 0x900");
	}
	else if (PMEC_INVALID_CONNECT_TYPE == errorCode)
	{
		strcpy(captionMsg, "The License Key you entered is not meant for this type of application. License Keys can be of following types:\n");
		strcat(captionMsg, "- SDK activation (Sandbox & Tools)\n");
		strcat(captionMsg, "- Use of the Educational License Server only\n");
		strcat(captionMsg, "- Launcher application only\n");
		strcat(captionMsg, "Please double check the type of license you have and contact Crytek support if necessary.");
		strcpy(titleMsg, "Validation Error 0x110");
	}
	else if (PMEC_OLD_APP_VERSION == errorCode)
	{
		strcpy(captionMsg, "The version of this application is deprecated.\n");
		strcat(captionMsg, "Please download new version on mycryengine.com.\n");
		strcpy(titleMsg, "Validation Error 0x120");
	}
	else
	{
		char unknownErrorTitle[128] = {0,};
		sprintf(unknownErrorTitle, "Unknown Error 0x%d", (int)errorCode);
		strcpy(captionMsg, ValidationErrorMsg);
		strcpy(titleMsg, unknownErrorTitle);
	}
}