#include "StdAfx.h"
#include "Client.h"
#include <Drei/NetworkFacade.h>
#include <Drei/ProactorFactory.h>
#include "ClientTask.h"

CClient::CClient(void) : m_task(NULL)
{
}

CClient::~CClient(void)
{
}

bool CClient::Init()
{
	ACE::init();
	using namespace DreiNetwork;
	SystemConfig config;
	config.Worker_Thread_Count = 1;
	config.Receive_Buffer_Len = 1024*4;
	config.Interval_Send_Term = 20;
	config.Send_Mode = eSM_Interval;

	if (false == NetworkInstance->Create<ProactorFactory>())
		return false;
	if (false == NetworkInstance->Open(&config))
		return false;

	m_task = new CClientTask();
	if (false == m_task->Open(1))
		return false;

	return true;
}

bool CClient::Connect( const char* ip, const int port )
{
	using namespace DreiNetwork;
	return NetworkInstance->Connect(ip, port, ReceiveQueueId);
}

void CClient::Fini()
{
	using namespace DreiNetwork;
	NetworkInstance->Close();

	m_task->Close();
	delete m_task;
	m_task = NULL;

	NetworkInstance->Destroy();
}