#include "StdAfx.h"
#include "ClientConfig.h"
#include "ProtocolBuilder.h"
#include <ace/Guard_T.h>

unsigned int CClientConfig::SendTerm;
unsigned int CClientConfig::ConnectTerm;
unsigned int CClientConfig::ClientCount;
std::string	CClientConfig::ServerIp;
int CClientConfig::ServerPort;
uint32 CClientConfig::_currentConnection = 0;
ACE_Thread_Mutex	CClientConfig::_lock;
uint32 CClientConfig::DisconnectProbability=10;

CClientConfig::CClientConfig(void)
{
}

CClientConfig::~CClientConfig(void)
{
}

bool CClientConfig::Load( const char* filename )
{
	FILE* r = NULL;
	errno_t err = fopen_s(&r, filename, "rb");
	if (0 != err)
		return false;

	const int BufferMax = 1024;
	char* fileBuffer = new char[BufferMax];
	size_t fileSize = fread(fileBuffer, 1, BufferMax, r);
	fclose(r);

	std::string readString(fileBuffer, fileSize);
	delete [] fileBuffer;
	while ( readString.find("\r\n") != std::string::npos )
	{
		readString.erase ( readString.find ("\r\n"), 2 );
	}

	CProtocolBuilder builder;
	builder.Parse(readString);
	SendTerm = builder.GetValue<uint32>("SendTerm");
	ConnectTerm = builder.GetValue<uint32>("ConnectTerm");
	ClientCount = builder.GetValue<uint32>("ClientCount");
	ServerPort = builder.GetValue<int>("ServerPort");
	ServerIp = builder.GetValue<std::string>("ServerIp");
	DisconnectProbability = builder.GetValue<uint32>("DisconnectProbability");
	return true;
}

uint32 CClientConfig::GetCurrentConnection()
{
	ACE_Guard<ACE_Thread_Mutex> guard(_lock);
	return _currentConnection;
}

void CClientConfig::IncreaseCurrentConnection()
{
	ACE_Guard<ACE_Thread_Mutex> guard(_lock);
	++_currentConnection;
}

void CClientConfig::DecreaseCurrentConnection()
{
	ACE_Guard<ACE_Thread_Mutex> guard(_lock);
	--_currentConnection;
}