#include "StdAfx.h"
#include "ClientTask.h"
#include <Drei/NetworkFacade.h>
#include <Drei/MessageHeader.h>
#include "ProtocolBuilder.h"
#include "ProtocolAssembler.h"
#include "LicenseServerCommon.h"
#include "ClientConfig.h"

const char* SendPacketFile = "SendPacket.txt";

CClientTask::CClientTask(void)
{
}

CClientTask::~CClientTask(void)
{
}

void CClientTask::Update()
{
	using namespace DreiNetwork;
	ACE_Message_Block* commandBlock = NULL;
	if ( false == NetworkInstance->PopMessage(ReceiveQueueId, &commandBlock, -1))
		return;

	MessagePostee postee;
	memcpy(&postee, commandBlock->rd_ptr(), sizeof(MessagePostee));
	commandBlock->rd_ptr(sizeof(MessagePostee));
	ACE_Message_Block* payloadBlock = commandBlock->cont();

	switch(postee.command)
	{
	case eMH_Establish:
		OnConnect(postee.stream_id);
		break;
	case eMH_Read:
		OnReceive(postee.stream_id, payloadBlock->rd_ptr(), (::uint32)payloadBlock->length());
		break;
	case eMH_Close:
		OnClose(postee.stream_id);
		break;
	}
	commandBlock->release();
}

void CClientTask::OnConnect( unsigned int streamId )
{
	CClientConfig::IncreaseCurrentConnection();
	//SendLoginPacket(streamId);
	SendFileToPacket(streamId, SendPacketFile);
}

void CClientTask::OnReceive( unsigned int streamId, const char* buffer, uint32 len )
{
	CProtocolAssembler assembler;
	uint32 bufferOffset = 0;
	assembler.ApplyBuffer(buffer, bufferOffset, len);

	CProtocolBuilder builder;
	builder.EncryptKey((unsigned char*)NetworkCryptKey, sizeof(NetworkCryptKey));
	if (false == assembler.AssembleBuilder(builder))
		return;

	//CProtocolBuilder builder;
	std::string received = builder.MakeString();
	printf("[%02d]Receive(%s)\n", streamId, received.c_str());
	//builder.Parse(received);
	std::string packetType = builder.GetValue<std::string>("type");
	unsigned int tick = builder.GetValue<unsigned int>("tick");
	if (0 != tick)
		printf("Elasped tick(%d)\n", GetTickCount()-tick);

	if ("auth" == packetType)
		PacketHandle_Auth(streamId, builder);
	else if ("login" == packetType)
		PacketHandle_Login(streamId, builder);
	else if ("loginaccount" == packetType)
		PacketHandle_LoginAccount(streamId, builder);
}

void CClientTask::OnClose( unsigned int streamId )
{
}

void CClientTask::SendLoginPacket(unsigned int streamId)
{
	CProtocolBuilder builder;
	builder.EncryptKey((unsigned char*)NetworkCryptKey, sizeof(NetworkCryptKey));
	builder.Add("type", "login");
	builder.Add("key", "A4EC-5087-63FC-13CD");
	builder.Add("mac", "00:21:85:19:94:45");
	builder.Add("ip", "192.168.9.60");
	const uint32 MaxBuffer = 1024;
	char sendBuffer[MaxBuffer] = {0,};
	uint32 sendSize = builder.MakeBuffer(sendBuffer, MaxBuffer);
	NetworkInstance->SendRequest(streamId, sendBuffer, sendSize);
}

void CClientTask::SendFileToPacket(unsigned int streamId, const char* filename)
{
	FILE* r = NULL;
	errno_t err = fopen_s(&r, filename, "rb");
	if (0 != err)
		return;

	const int BufferMax = 1024;
	char* fileBuffer = new char[BufferMax];
	size_t fileSize = fread(fileBuffer, 1, BufferMax, r);
	fclose(r);

	CProtocolBuilder builder;
	builder.EncryptKey((unsigned char*)NetworkCryptKey, sizeof(NetworkCryptKey));
	builder.Parse(std::string(fileBuffer, fileSize));
	delete [] fileBuffer;
	int delay = CClientConfig::SendTerm;
	uint32 tick = GetTickCount()+delay;
	builder.Add("tick", tick);

	std::string sendString = builder.MakeString();
	printf("[%02d]Send(%s)\n", streamId, sendString.c_str());

	const uint32 MaxBuffer = 1024;
	char sendBuffer[MaxBuffer] = {0,};
	uint32 sendSize = builder.MakeBuffer(sendBuffer, MaxBuffer);
	NetworkInstance->SendReserve(streamId, sendBuffer, sendSize, delay);
}

void CClientTask::PacketHandle_Auth( uint32 streamId, CProtocolBuilder& packet )
{
	//if ((rand()%100)<=CClientConfig::DisconnectProbability)
	//{
	//	CClientConfig::DecreaseCurrentConnection();
	//	printf("Current Connecttion = %d\n", CClientConfig::GetCurrentConnection());
	//	NetworkInstance->CloseStream(streamId);
	//}
	//else

	SendFileToPacket(streamId, SendPacketFile);
}

void CClientTask::PacketHandle_Login( uint32 streamId, CProtocolBuilder& packet )
{
	SendFileToPacket(streamId, SendPacketFile);
}

void CClientTask::PacketHandle_Logoff( uint32 streamId, CProtocolBuilder& packet )
{
}

void CClientTask::PacketHandle_LoginAccount( uint32 streamId, CProtocolBuilder& packet )
{
	SendFileToPacket(streamId, SendPacketFile);
}