#pragma once

#include <Drei/ThreadPool.h>

class CProtocolBuilder;

class CClientTask : public DreiNetwork::ThreadPool
{
public:
	CClientTask(void);
	~CClientTask(void);

	virtual bool	Begin() { return true; }
	virtual void	Update();
	virtual void	End() {}

protected:
	void	OnConnect(unsigned int streamId);
	void	OnReceive(unsigned int streamId, const char* buffer, uint32 len);
	void	OnClose(unsigned int streamId);

	void	SendLoginPacket(unsigned int streamId);
	void	SendFileToPacket(unsigned int streamId, const char* filename);

	void	PacketHandle_Auth(uint32 streamId, CProtocolBuilder& packet);
	void	PacketHandle_Login(uint32 streamId, CProtocolBuilder& packet);
	void	PacketHandle_Logoff(uint32 streamId, CProtocolBuilder& packet);
	void	PacketHandle_LoginAccount(uint32 streamId, CProtocolBuilder& packet);
};
