// TestClient.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include <Windows.h>
#include "Client.h"
#include "ClientConfig.h"

int _tmain(int argc, _TCHAR* argv[])
{
	srand((unsigned)time(NULL));
	CClient client;
	if (client.Init())
		printf("Client start success.\n");
	else
		printf("Client start fail.\n");

	if (CClientConfig::Load("TestClientConfig.txt"))
		printf("Load Config success.\n");
	else
		printf("Load Config fail.\n");

	printf("Connect Start.\n");
	for(unsigned int i=0; i<CClientConfig::ClientCount; ++i)
	{
		client.Connect(CClientConfig::ServerIp.c_str(), CClientConfig::ServerPort);
		Sleep(CClientConfig::ConnectTerm);
	}

	printf("Connect finished.\n");
	while(true)
	{
		if (CClientConfig::GetCurrentConnection() < CClientConfig::ClientCount)
		{
			client.Connect(CClientConfig::ServerIp.c_str(), CClientConfig::ServerPort);
			continue;
		}
		Sleep(3000);
	}
	getchar();
	client.Fini();
	return 0;
}

