#ifndef HEADER_Helpers
#define HEADER_Helpers

#include <string>

inline void ClampToLastSpace(std::string& source)
{
	size_t f = source.rfind(' ');
	if (f == std::string::npos)
		return;

	source.resize(f);
}

//

inline LCQuat32 QuaternionExponent(LCf32 x, LCf32 y, LCf32 z)
{
	LCf32 length = ::sqrtf(x*x + y*y + z*z);
	if (length > 0.0f)
	{
		LCQuat32 q;
		LCf32 s = ::sinf(length) / length;
		q.x = x * s;
		q.y = y * s;
		q.z = z * s;
		q.w = ::cosf(length);
		return q;
	}

	LCQuat32 q;
	q.x = 0.0f;
	q.y = 0.0f;
	q.z = 0.0f;
	q.w = 1.0f;
	return q;
}

#endif // HEADER_Helpers
