#ifndef HEADER_Actor
#define HEADER_Actor

class CActor :
	public ILCActor
{
public:
	struct SNode
	{
		std::string name;
		Vec3f32 position;
		Quatf32 orientation;
	};

public:
	static CActor* Create(const char* name, const LCSet* pSet)
	{
		return new CActor(name, pSet);
	}

private:
	CActor(const char* name, const LCSet* pSet)
   {
	   m_name = name;
	   m_pSet = pSet;

	   LCu32 nodeCount = pSet ? pSet->GetNodeCount() : 0;

	   ::printf("Creating Actor \"%s\" with %d nodes:\n", name, nodeCount);
/*	   for (LCu32 i=0; i<nodeCount; ++i)
	   {
		   ::printf("[%2d] \"%s\", parent: %d\n", i,
			   set.GetNodeName(i), set.GetNodeParent(i));
	   }
*/
   }

public:
	void Release() { delete this; }

	const LCSet* GetSet() { return m_pSet; }

	unsigned int GetNodeCount() { return (unsigned int)m_nodes.size(); }
	SNode* GetNodeByIndex(unsigned int index) { return &m_nodes[index]; }
	SNode* GetNodeByName(LCString name)
	{
		unsigned int count = (unsigned int)m_nodes.size();
		for (unsigned int i=0; i<count; ++i)
		{
			if (::stricmp(m_nodes[i].name.c_str(), name))
				continue;

			return &m_nodes[i];
		}

		return NULL;
	}

	// ILCActor
public:
	void SetPosition(LCString name, LCu32 time, const LCVec3f32& position)
	{
		SNode& node = AddNode(name);
		node.position.x = position.x / 1000.0f;
		node.position.y = position.y / 1000.0f;
		node.position.z = position.z / 1000.0f;
	}

	void SetOrientation(LCString name, LCu32 time, const LCQuat32& orientation)
	{
		SNode& node = AddNode(name);
		node.orientation = ::exp(Vec3f32(
			orientation.x, orientation.y, orientation.z));
	}

	void SetScale(LCString name, LCu32 time, const LCVec3f32& scale)
	{
	}

private:
	SNode& AddNode(LCString name)
	{
		unsigned int nodeCount = (unsigned int)m_nodes.size();
		for (unsigned int i=0; i<nodeCount; ++i)
		{
			if (::stricmp(m_nodes[i].name.c_str(), name))
				continue;

			return m_nodes[i];
		}

		SNode node;
		node.name = name;
		m_nodes.push_back(node);
		return m_nodes.back();
	}

private:
	std::string m_name;
	const LCSet* m_pSet;

	std::vector<SNode> m_nodes;
};

#endif // HEADER_Actor
