#include <stdio.h>
#include <fcntl.h>
#include <io.h>

#include <Windows.h>

//

HINSTANCE appInstance = NULL;
HWND appWindow = NULL;

//

void CreateConsole()
{
	AllocConsole();

	// Redirect unbuffered stdout to the console.
	HANDLE handle = ::GetStdHandle(STD_OUTPUT_HANDLE);
	int h = ::_open_osfhandle((intptr_t)handle, _O_TEXT);
	FILE* pFile = ::_fdopen(h, "w");
	*stdout = *pFile;
	::setvbuf(stdout, NULL, _IONBF, 0);

	// Redirect unbuffered stdin to the console.
	handle = ::GetStdHandle(STD_INPUT_HANDLE);
	h = ::_open_osfhandle((intptr_t)handle, _O_TEXT);
	pFile = ::_fdopen(h, "r");
	*stdin = *pFile;
	::setvbuf(stdin, NULL, _IONBF, 0);

	// Redirect unbuffered stderr to the console.
	handle = ::GetStdHandle(STD_ERROR_HANDLE);
	h = ::_open_osfhandle((intptr_t)handle, _O_TEXT);
	pFile = ::_fdopen(h, "w");
	*stderr = *pFile;
	::setvbuf(stderr, NULL, _IONBF, 0);

	::printf("Redirecting STD I/O to console...\n");
}

void OnMouseDown(char key);
void OnMouseUp(char key);
void OnMouseMove(int x, int y);

void OnKeyDown(char key);
void OnKeyUp(char key);
LRESULT CALLBACK WindowProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message)
	{
	case WM_KEYDOWN:
		::OnKeyDown(char(wParam));
		return true;

	case WM_KEYUP:
		::OnKeyUp(char(wParam));
		return true;

	case WM_MOUSEMOVE:
		break;

	case WM_RBUTTONDOWN:
		::OnMouseDown(1);
		return true;

	case WM_RBUTTONUP:
		::OnMouseUp(1);		
		return true;
	}

	return ::DefWindowProc(hWnd, message, wParam, lParam);
}

HWND AppInitialize(HINSTANCE hInstance)
{
	::appInstance = hInstance;

	::CreateConsole();

	WNDCLASS wndClass;
	wndClass.style = CS_CLASSDC;
	wndClass.lpfnWndProc = WindowProc;
	wndClass.cbClsExtra = NULL;
	wndClass.cbWndExtra = NULL;
	wndClass.hInstance = hInstance;
	wndClass.hIcon = NULL;
	wndClass.hCursor = ::LoadCursor(NULL, IDC_ARROW);
	wndClass.hbrBackground = NULL;
	wndClass.lpszMenuName = NULL;
	wndClass.lpszClassName = "Window";
	::RegisterClass(&wndClass);

	RECT rect;
	rect.left = 0;
	rect.top = 0;
	rect.right = 640;
	rect.bottom = 480;
	::AdjustWindowRect(&rect, WS_THICKFRAME | WS_VISIBLE, false);

	::appWindow = ::CreateWindowEx(
		NULL,
		"Window",
		"LiveCreate",
		WS_THICKFRAME | WS_VISIBLE,
		CW_USEDEFAULT, CW_USEDEFAULT,
		rect.right - rect.left, rect.bottom - rect.top,
		NULL,
		NULL,
		hInstance,
		NULL);

	if (!::appWindow)
	{
		::UnregisterClass("Window", hInstance);
		return NULL;
	}

	return ::appWindow;
}

void AppShutdown()
{
	if (::appWindow)
		::UnregisterClass("Window", ::appInstance);
	::appWindow = NULL;
	::appInstance = NULL;

	::FreeConsole();
}

bool AppRun()
{
	MSG message;
	if (!::PeekMessage(&message, NULL, 0, 0, PM_NOREMOVE))
		return true;

	if (!::GetMessage(&message, NULL, 0, 0))
		return false;

	::TranslateMessage(&message);
	::DispatchMessage(&message);

	return true;
}
