#ifndef HEADER_Camera
#define HEADER_Camera

class CCamera
{
public:
	Vec3f32 target;
	Vec3f32 angles;
	Vec3f32 scale;

	Vec3f32 position;
	Mat33f32 orientation;

public:
	CCamera()
	{
		angles = Vec3f32(0.0f, 0.0f, 0.0f);
		position = Vec3f32(0.0f, 0.0f, 0.0f);
		orientation.Identity();
	}

public:
	void Update()
	{
		orientation =
			Mat33f32::RotationX(angles.x) *
			Mat33f32::RotationZ(angles.y);
	}

	Mat44f32 GetViewMatrix() const
	{
		return Mat44f32::Translation(-position.x, -position.y, -position.z) * Mat44f32(orientation.Transposed());
	}
};

#endif // HEADER_Camera
