#include <Windows.h>
#include <gl/GL.h>

#pragma comment(lib, "opengl32.lib")

//

HWND glWindow = NULL;
HDC glDC = NULL;
HGLRC glContext = NULL;

//

bool glInitialize(HWND hWindow)
{
	PIXELFORMATDESCRIPTOR pixelFormatDesc;
	pixelFormatDesc.nSize = sizeof(PIXELFORMATDESCRIPTOR);
	pixelFormatDesc.nVersion = 1;
	pixelFormatDesc.dwFlags = PFD_DRAW_TO_WINDOW | PFD_SUPPORT_OPENGL | PFD_DOUBLEBUFFER;
	pixelFormatDesc.iPixelType = PFD_TYPE_RGBA;
	pixelFormatDesc.cColorBits = 32;
	pixelFormatDesc.cRedBits = NULL;
	pixelFormatDesc.cRedShift = NULL;
	pixelFormatDesc.cGreenBits = NULL;
	pixelFormatDesc.cGreenShift = NULL;
	pixelFormatDesc.cBlueBits = NULL;
	pixelFormatDesc.cBlueShift = NULL;
	pixelFormatDesc.cAlphaBits = NULL;
	pixelFormatDesc.cAlphaShift = NULL;
	pixelFormatDesc.cAccumBits = NULL;
	pixelFormatDesc.cAccumRedBits = NULL;
	pixelFormatDesc.cAccumGreenBits = NULL;
	pixelFormatDesc.cAccumBlueBits = NULL;
	pixelFormatDesc.cAccumAlphaBits = NULL;
	pixelFormatDesc.cDepthBits = 24;
	pixelFormatDesc.cStencilBits = 8;
	pixelFormatDesc.cAuxBuffers = NULL;
	pixelFormatDesc.iLayerType = PFD_MAIN_PLANE;
	pixelFormatDesc.bReserved = NULL;
	pixelFormatDesc.dwLayerMask = NULL;
	pixelFormatDesc.dwVisibleMask = NULL;
	pixelFormatDesc.dwDamageMask = NULL;

	::glWindow = hWindow;
	::glDC = ::GetDC(::glWindow);
	if (!::glDC)
		return false;

	int pixelFormat = ::ChoosePixelFormat(::glDC, &pixelFormatDesc);
	::SetPixelFormat(::glDC, pixelFormat, &pixelFormatDesc);

	::glContext = ::wglCreateContext(::glDC);
	if (!::glContext)
		return false;

	::wglMakeCurrent(::glDC, ::glContext);
	return true;
}

void glShutdown()
{
	if (::glContext)
	{
		::wglMakeCurrent(::glDC, NULL);
		::wglDeleteContext(::glContext);
		::glContext = NULL;
	}
	if (::glDC)
	{
		::ReleaseDC(glWindow, glDC);
		::glDC = NULL;
		::glWindow = NULL;
	}
}

void glPresent()
{
	::SwapBuffers(::glDC);
}
