#ifndef HEADER_Scene
#define HEADER_Scene

#include <vector>
#include <string>

#include "Actor.h"

class CScene :
	public ILCScene
{
public:
	CScene()
	{
		m_actors.reserve(16);
	}

	~CScene()
	{
		while (!m_actors.empty())
		{
			m_actors.back()->Release();
			m_actors.pop_back();
		}
	}

public:
	size_t GetActorCount() { return m_actors.size(); }
	CActor& GetActor(size_t index) { return *m_actors[index]; }

	// ILCScene
public:
	ILCActor* CreateActor(LCString name, const LCSet* pSet)
	{
		CActor* pActor = CActor::Create(name, pSet);
		if (!pActor)
			return NULL;

		m_actors.push_back(pActor);
		return pActor;
	}

private:
	std::vector<CActor*> m_actors;
};

#endif // HEADER_Scene
