#ifndef HEADER_Biped
#define HEADER_Biped

struct SViconNode
{
	const char* name;
	LCi32 parent;

	LCi32 x;
	LCi32 y;
	LCi32 z;
};

static const SViconNode viconBipedNodes[] =
{
	{ "Pelvis",		-1,		+3, +1, +2, }, // 0
	{ "Thorax",		0,		+3, +1, +2, }, // 1
	{ "Spine",		1,		+3, +1, +2, }, // 2 (not always supported)
	{ "Head",		2,		+3, +1, +2, }, // 3
	{ "Lclavicle",	2,		+2, -1, +3, }, // 4
	{ "Lhumerus",	4,		-3, -1, +2, }, // 5
	{ "Lradius",	5,		-3, -1, +2, }, // 6
	{ "Lhand",		6,		-3, -2, -1, }, // 7
	{ "Rclavicle",	2,		-2, -1, -3, }, // 8
	{ "Rhumerus",	8,		-3, -1, +2, }, // 9
	{ "Rradius",	9,		-3, -1, +2, }, // 10
	{ "Rhand",		10,		-3, +2, +1, }, // 11
	{ "Lfemur",		0,		-3, +1, -2, }, // 12
	{ "Ltibia",		12,		-3, +1, -2, }, // 13
	{ "Lfoot",		13,		-3, +1, -2, }, // 14
	{ "Ltoes",		14,		+1, +3, -2, }, // 15
	{ "Rfemur",		0,		-3, +1, -2, }, // 16
	{ "Rtibia",		16,		-3, +1, -2, }, // 17
	{ "Rfoot",		17,		-3, +1, -2, }, // 18
	{ "Rtoes",		18,		+1, +3, -2, }, // 19
};

class CViconBipedSet :
	public LCSet
{
	// LCSet
public:
	LCu32 GetNodeCount() const { return sizeof(::viconBipedNodes) / sizeof(SViconNode); }
	LCString GetNodeName(LCu32 index) const { return ::viconBipedNodes[index].name; }
	LCi32 GetNodeParent(LCu32 index) const { return ::viconBipedNodes[index].parent; }
} viconBipedSet;

#endif // HEADER_Biped
