#ifndef HEADER_Client
#define HEADER_Client

#include <vector>
#include <map>
#include <string>
#include <functional>
#include <assert.h>

#include "../Library/Library.h"
#include <LiveCreate.h>

#include "Connection.h"

class CClient
{
private:
	enum ERequest
	{
		eRequest_Close	= 0,
		eRequest_Info	= 1,
		eRequest_Data	= 2,
	};

private:
	struct SJoint
	{
	public:
		std::string name;
		LCu32 ax, ay, az;
		LCu32 tx, ty, tz;

	public:
		SJoint(const char* name) :
			name(name),
			ax(0), ay(0), az(0),
			tx(0), ty(0), tz(0)
		{
		}
	};

	struct SMarker
	{
	public:
		std::string name;
		LCi32 x, y, z;

	public:
		SMarker(const char* name) :
			name(name),
			x(0), y(0), z(0)
		{
		}
	};

public:
	CClient();
	~CClient();

public:
	bool Connect(const char* address);
	bool IsConnected();
	void Disconnect();

	void Update(ILCScene &scene);

private:
	SJoint& AddJoint(const char* name);
	SMarker& AddMarker(const char* name);

	bool AddChannel(const char* type, const char* name, LCu32 index);

	bool SendPacketHeader(ERequest eRequest);
	bool ReceivePacketHeader(ERequest eFromRequest);
	bool Request(ERequest eRequest);

	bool ReceiveInformation(std::vector<std::string> &information);
	bool ParseInformation(const std::vector<std::string> &information);

	bool ReceiveData();
	bool ParseData(ILCScene &scene);

	ILCActor* GetActor(ILCScene &scene, const char* name, LCSet* pSet);

private:
	CConnection m_connection;

	std::vector<SJoint> m_joints;
	std::vector<SMarker> m_markers;

	LCu32 m_dataCount;
	std::vector<LCf64> m_data;

	std::map<std::string, ILCActor*> m_actors;
};

#endif // HEADER_Client
