#include "Client.h"
#include "Connection.h"

extern ILCSystem* pSystem;

#pragma comment(lib, "ws2_32.lib")

/*

  CConnection

*/

CConnection::CConnection()
{
	m_socket = INVALID_SOCKET;
}

CConnection::~CConnection()
{
	if (m_socket != INVALID_SOCKET)
		::closesocket(m_socket);
}

//

bool CConnection::Error(const char* message)
{
	Disconnect();

	if (message)
		::pSystem->Log(message);

	return false;
}

//

bool CConnection::Connect(const char* address, LCu16 port)
{
	static bool bOnce = true;
	if (bOnce)
	{
		WSADATA wsaData;
		if (::WSAStartup(MAKEWORD(2, 0), &wsaData))
			return Error("ViconClient: Socket initialization error.\n");

		bOnce = false;
	}

	struct protoent* pProtocol = ::getprotobyname("tcp");
	assert(pProtocol);

	m_socket = ::socket(PF_INET, SOCK_STREAM, pProtocol->p_proto);
	if (m_socket == INVALID_SOCKET)
		return Error("ViconClient: Socket creation error.\n");

	::pSystem->Log("ViconClient: Connecting to address: %s\n", address);

	struct sockaddr_in addr;
	addr.sin_family	= AF_INET;
	addr.sin_port = ::htons(port);

	if (struct hostent* pHost = gethostbyname(address))
		memcpy(&addr.sin_addr, pHost->h_addr, pHost->h_length);
//		addr.sin_addr.s_addr = ((in_addr*)(pHost->h_addr))->s_addr;
	else
		addr.sin_addr.s_addr = inet_addr(address);

	if (addr.sin_addr.s_addr == INADDR_NONE)
		return Error("ViconClient: Bad address\n");

	if (::connect(m_socket, (struct sockaddr*)&addr, sizeof(addr)) == SOCKET_ERROR)
		return Error("ViconClient: Failed to create socket\n");

	::pSystem->Log("ViconClient: Connected to server.\n");
	return true;
}

void CConnection::Disconnect()
{
	if (m_socket == INVALID_SOCKET)
		return;

	::closesocket(m_socket);
	m_socket = INVALID_SOCKET;
}

LCu32 CConnection::Send(const void* pBuffer, LCu32 length)
{
	if (m_socket == INVALID_SOCKET)
		return NULL;

	// TODO: Make sure full length is sent.
	if (::send(m_socket, (const char*)pBuffer, length, NULL) == SOCKET_ERROR)
		return Error();

	return length;
}

LCu32 CConnection::Receive(void* pBuffer, LCu32 length)
{
	if (m_socket == INVALID_SOCKET)
		return NULL;

	LCu8* p = (LCu8*)pBuffer;
	LCu8* e = (LCu8*)pBuffer + length;
	while (p != e)
	{
		LCi32 result = ::recv(m_socket, (char*)p, e-p, NULL);
		if (result < 0)
		{
			if (::WSAGetLastError() == 0x2733)
				return false;

			return Error();
		}

		p += result;
	}

	return length;
}
