#ifndef HEADER_Connection
#define HEADER_Connection

#include <LiveCreate.h>

#include <winsock2.h>

class CConnection
{
public:
	CConnection();
	~CConnection();

public:
	bool Connect(const char* address, LCu16 port);
	void Disconnect();

	bool IsConnected() { return m_socket != INVALID_SOCKET; }

	LCu32 Send(const void* pBuffer, LCu32 length);
	LCu32 Receive(void* pBuffer, LCu32 length);

	bool MakeNonBlocking()
	{
		// Make the connection non-blocking.
		u_long arg = 1;
		::ioctlsocket(m_socket , FIONBIO, &arg);
		return true;
	}

private:
	bool Error(const char* message = NULL);

public:
	SOCKET m_socket;
};

#endif // HEADER_Connection
