#include <string>

#include "../../../SDKs/LiveCreate/LiveCreate.h"

#include "Client.h"

#include <stdio.h>
#include <Windows.h>

class CVicon :
	public LCLiveCreate
{
public:
	static CVicon* Create()
	{
		return  new CVicon();
	}

public:
	CVicon()
	{
		m_pScene = NULL;

		m_bConnect = true;
	}

	// LCLiveCreate
public:
	void Release() { delete this; }

	bool Connect(LCString address, ILCScene& scene)
	{
		if (!address)
			return false;

		m_bConnect = true;
		m_address = address;

		m_pScene = &scene;

		if (!m_client.Connect(address))
			return false;

		return true;
	}

	void Disconnect()
	{
		m_client.Disconnect();
		m_bConnect = false;
	}

	bool Update()
	{
		if (m_bConnect && !m_client.IsConnected())
		{
			if (!m_client.Connect(m_address.c_str()))
				return false;
		}

		m_client.Update(*m_pScene);
		return true;
	}

private:
	ILCScene* m_pScene;

	CClient m_client;
	bool m_bConnect;
	std::string m_address;
};

ILCSystem* pSystem = NULL;
extern "C" __declspec(dllexport) LCLiveCreate* LiveCreate(ILCSystem* pSystem)
{
	::pSystem = pSystem;
	return CVicon::Create();
}
