
// MainFrm.cpp : implementation of the CMainFrame class
//

#include "stdafx.h"
#include "LoadingProfilerViewer.h"

#include "MainFrm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

#define IDR_PANE_REPORT (AFX_IDW_PANE_FIRST+1)

// CMainFrame

IMPLEMENT_DYNCREATE(CMainFrame, CMainFrameBase)

const int  iMaxUserToolbars = 10;
const UINT uiFirstUserToolBarId = AFX_IDW_CONTROLBAR_FIRST + 40;
const UINT uiLastUserToolBarId = uiFirstUserToolBarId + iMaxUserToolbars - 1;

BEGIN_MESSAGE_MAP(CMainFrame, CMainFrameBase)
	ON_WM_CREATE()
	ON_MESSAGE(XTPWM_DOCKINGPANE_NOTIFY, OnDockingPaneNotify)
	ON_NOTIFY(NM_DBLCLK, REPORT_ALL, OnReportItemDblClick)
	ON_NOTIFY(NM_DBLCLK, REPORT_PARENT, OnReportItemDblClick)
	ON_NOTIFY(NM_DBLCLK, REPORT_CHILDREN, OnReportItemDblClick)
	ON_NOTIFY(NM_DBLCLK, REPORT_SELF, OnReportItemDblClick)
	ON_NOTIFY(NM_DBLCLK, REPORT_TREE, OnReportItemDblClick)
END_MESSAGE_MAP()

static UINT indicators[] =
{
	ID_SEPARATOR,           // status line indicator
	ID_INDICATOR_CAPS,
	ID_INDICATOR_NUM,
	ID_INDICATOR_SCRL,
};

// CMainFrame construction/destruction

CMainFrame::CMainFrame()
{
	// TODO: add member initialization code here
}

CMainFrame::~CMainFrame()
{
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CMainFrameBase::OnCreate(lpCreateStruct) == -1)
		return -1;


	if (!m_wndStatusBar.Create(this) ||
		!m_wndStatusBar.SetIndicators(indicators,
		  sizeof(indicators)/sizeof(UINT)))
	{
		TRACE0("Failed to create status bar\n");
		return -1;      // fail to create
	}

	if (!InitCommandBars())
		return -1;

	XTPPaintManager()->SetTheme(xtpThemeOfficeXP);

	CXTPCommandBars* pCommandBars = GetCommandBars();

	pCommandBars->SetMenu(_T("Menu Bar"), IDR_MAINFRAME);

	/*
	CXTPToolBar* pCommandBar = (CXTPToolBar*)pCommandBars->Add(_T("Standard"), xtpBarTop);
	if (!pCommandBar ||	!pCommandBar->LoadToolBar(IDR_MAINFRAME))
	{
		TRACE0("Failed to create toolbar\n");
		return -1;
	}
	*/

	// control bars objects have been created and docked.
	m_paneManager.InstallDockingPanes(this);

	// Create docking panes.
	{
		CXTPDockingPane *pPane = m_paneManager.CreatePane( IDR_PANE_REPORT + REPORT_CHILDREN, CRect(0, 0,210, 200), xtpPaneDockTop);
		pPane->SetTitle( "Child Calls" );
		pPane->SetOptions(xtpPaneNoCloseable|xtpPaneNoHideable|xtpPaneNoFloatable);
		pPane->SetMinTrackSize( CSize(100,200) );
	}
	{
		CXTPDockingPane *pPane = m_paneManager.CreatePane( IDR_PANE_REPORT + REPORT_SELF, CRect(0, 0,210, 50), xtpPaneDockTop);
		pPane->SetTitle( "Self" );
		pPane->SetOptions(xtpPaneNoCloseable|xtpPaneNoHideable|xtpPaneNoFloatable);
		pPane->SetMinTrackSize( CSize(100,50) );
	}
	{
		CXTPDockingPane *pPane = m_paneManager.CreatePane( IDR_PANE_REPORT + REPORT_PARENT, CRect(0, 0,210, 200), xtpPaneDockTop);
		pPane->SetTitle( "Parent Calls" );
		pPane->SetOptions(xtpPaneNoCloseable|xtpPaneNoHideable|xtpPaneNoFloatable);
		pPane->SetMinTrackSize( CSize(100,200) );
	}

	CXTPDockingPane *pAlPane = 0;
	{
		CXTPDockingPane *pPane = m_paneManager.CreatePane( IDR_PANE_REPORT + REPORT_ALL, CRect(0, 0,210, 300), xtpPaneDockTop);
		pAlPane = pPane;
		pPane->SetTitle( "All Calls" );
		pPane->SetOptions(xtpPaneNoCloseable|xtpPaneNoHideable);
		pPane->SetMinTrackSize( CSize(100,300) );
	}

	{
		CXTPDockingPane *pPane = m_paneManager.CreatePane( IDR_PANE_REPORT + REPORT_TREE, CRect(0, 0,800, 200), xtpPaneDockTop);
		pPane->SetTitle( "Call Stack" );
		pPane->SetOptions(xtpPaneNoCloseable|xtpPaneHasMenuButton);
		//pPane->SetMinTrackSize( CSize(100,200) );
		m_paneManager.AttachPane(pAlPane,pPane);
	}

	m_paneManager.SetTheme(xtpPaneThemeOffice2003);


	for (int i = 0; i < REPORT_COUNT; i++)
	{
		m_wndReport[i].Create(WS_CHILD|WS_VISIBLE,CRect(0, 0, 0, 0), this, REPORT_ALL+i);
	}

	m_wndReport[REPORT_PARENT].Init(REPORT_PARENT);
	m_wndReport[REPORT_CHILDREN].Init(REPORT_CHILDREN);
	m_wndReport[REPORT_SELF].Init(REPORT_SELF);
	m_wndReport[REPORT_ALL].Init(REPORT_ALL);
	m_wndReport[REPORT_TREE].Init(REPORT_TREE);

	return 0;
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	if( !CMainFrameBase::PreCreateWindow(cs) )
		return FALSE;
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return TRUE;
}

BOOL CMainFrame::LoadFrame(UINT nIDResource, DWORD dwDefaultStyle, CWnd* pParentWnd, CCreateContext* pContext) 
{
	// base class does the real work

	if (!CMainFrameBase::LoadFrame(nIDResource, dwDefaultStyle, pParentWnd, pContext))
	{
		return FALSE;
	}

	return TRUE;
}


LRESULT CMainFrame::OnDockingPaneNotify(WPARAM wParam, LPARAM lParam)
{
	if (wParam == XTP_DPN_SHOWWINDOW)
	{
		CXTPDockingPane* pPane = (CXTPDockingPane*)lParam;


		if (!pPane->IsValid())
		{
			int index = pPane->GetID() - IDR_PANE_REPORT;

			pPane->Attach(&m_wndReport[index]);
			m_wndReport[index].SetOwner(this);

		}

		return TRUE;

	}
	return FALSE;
}

//////////////////////////////////////////////////////////////////////////
void CMainFrame::ReloadProfileData()
{
	for (int i = 0; i < REPORT_COUNT; i++)
	{
		m_wndReport[i].Reload();
	}
}

//////////////////////////////////////////////////////////////////////////
void CMainFrame::ReloadCurrentFunctionData()
{
	m_wndReport[REPORT_SELF].Reload();
	m_wndReport[REPORT_CHILDREN].Reload();
	m_wndReport[REPORT_PARENT].Reload();
}


// Handles double clicking ReportControl item.
// If "Read" attribute is False, changes it to True
void CMainFrame::OnReportItemDblClick(NMHDR * pNotifyStruct, LRESULT *result)
{
	XTP_NM_REPORTRECORDITEM* pItemNotify = (XTP_NM_REPORTRECORDITEM*) pNotifyStruct;

	if (pItemNotify->pRow)
	{
		TRACE(_T("Double Click on row %d\n"),
			pItemNotify->pRow->GetIndex());

		CMessageRecord* pRecord = DYNAMIC_DOWNCAST(CMessageRecord, pItemNotify->pRow->GetRecord());
		if (pRecord)
		{
			if (pRecord->name)
			{
				CProfilerDatabase::Instance()->SetCurrentFunction( pRecord->name );
				ReloadCurrentFunctionData();
			}
		}
	}
}
