
#include "stdafx.h"
#include "ProfileData.h"
#include "xml\Xml.h"


CProfilerDatabase* CProfilerDatabase::m_sInstance = 0;

//////////////////////////////////////////////////////////////////////////
CProfilerDatabase* CProfilerDatabase::Instance()
{
	if (!m_sInstance)
		m_sInstance = new CProfilerDatabase;
	return m_sInstance;
}

//////////////////////////////////////////////////////////////////////////
CProfilerDatabase::CProfilerDatabase()
{
	m_pCurrentFunction = 0;

}

//////////////////////////////////////////////////////////////////////////
CProfilerDatabase::~CProfilerDatabase()
{

}

//////////////////////////////////////////////////////////////////////////
bool CProfilerDatabase::Load( const char *filename )
{
	XmlParser xml;
	XmlNodeRef root = xml.parse( filename );
	if (!root)
	{
		AfxMessageBox( "Cannot open profiler xml data",MB_OK );
		return false;
	}

	ParseNode( root,0 );
	GenerateFunctions();

	return true;
}

//////////////////////////////////////////////////////////////////////////
void CProfilerDatabase::ParseNode( XmlNodeRef &node,CProfilerSample *pParent )
{
	CProfilerSample *pEntry = new CProfilerSample;
	pEntry->name = node->getTag();

	pEntry->name.Replace( "__","::" );

	pEntry->data.percentage = 0;
	node->getAttr( "count",pEntry->data.calls );
	node->getAttr( "selfTime",pEntry->data.selfTime );
	node->getAttr( "totalTime",pEntry->data.totalTime );
	node->getAttr( "selfMemory",pEntry->data.selfMemory );
	node->getAttr( "totalMemory",pEntry->data.totalMemory );

	node->getAttr( "selfSeeks",pEntry->data.selfSeeks );
	node->getAttr( "selfReads",pEntry->data.selfReads );
	node->getAttr( "selfOpens",pEntry->data.selfOpens );
	node->getAttr( "totalSeeks",pEntry->data.totalSeeks );
	node->getAttr( "totalReads",pEntry->data.totalReads );
	node->getAttr( "totalOpens",pEntry->data.totalOpens );
	node->getAttr( "selfDiskSize",pEntry->data.selfDiskSize );
	node->getAttr( "totalDiskSize",pEntry->data.totalDiskSize );

	if (pParent)
	{
		pEntry->parentName = pParent->name;
		pParent->childs.push_back(pEntry);
	}
	pEntry->pParent = pParent;
	m_samples.push_back(pEntry);

	// Add childs.
	for (int i = 0; i < node->getChildCount(); i++)
	{
		ParseNode( node->getChild(i),pEntry );
	}	
}

//////////////////////////////////////////////////////////////////////////
void CProfilerDatabase::GenerateFunctions()
{
	std::map<CString,CProfilerFunction*> mapFuntions;

	double totalTime = 0;
	for (int i = 0; i < (int)m_samples.size(); i++)
	{
		CProfilerSample *pSample = m_samples[i];
		if (!pSample->pParent)
			totalTime += pSample->data.totalTime;
		CProfilerFunction *pFunc = stl::find_in_map(mapFuntions,pSample->name,0);
		if (!pFunc)
		{
			pFunc = new CProfilerFunction;
			pFunc->name = pSample->name;
			mapFuntions[pFunc->name] = pFunc;
			pFunc->data = pSample->data;
			m_functions.push_back(pFunc);
		}
		else
		{
			// Add this new sampler to existing function.
			pFunc->data.Add(pSample->data);
		}
	}
	if (totalTime == 0)
		totalTime = 1;

	// Calculate percentage.
	for (int i = 0; i < (int)m_functions.size(); i++)
	{
		CProfilerFunction *pFunction = m_functions[i];
		pFunction->data.percentage = float(pFunction->data.totalTime / totalTime) * 100.f;
	}
}

//////////////////////////////////////////////////////////////////////////
void CProfilerDatabase::SetCurrentFunction( const CString &functionName )
{
	m_pCurrentFunction = 0;

	for (int i = 0; i < (int)m_functions.size(); i++)
	{
		if (m_functions[i]->name == functionName)
		{
			m_pCurrentFunction = m_functions[i];
			break;;
		}
	}
	if (!m_pCurrentFunction)
		return;

	CProfilerFunction *pFunction = m_pCurrentFunction;

	// Recalculate childs/parents
	pFunction->childs.clear();
	pFunction->parents.clear();

	for (int i = 0; i < (int)m_samples.size(); i++)
	{
		CProfilerSample *pSample = m_samples[i];

		// Check if this sample is our parent.
		for (int k = 0; k < (int)pSample->childs.size(); k++)
		{
			CProfilerSample *pChildSample = pSample->childs[k];
			if (pChildSample->name == pFunction->name)
			{
				// This is our parent.
				CProfilerFunction::SubFunction sub;
				sub.name = pSample->name;
				sub.data = pChildSample->data;
				pFunction->parents.push_back(sub);
				break;
			}
		}
		if (pSample->parentName == pFunction->name)
		{
			// This is our child.
			CProfilerFunction::SubFunction sub;
			sub.name = pSample->name;
			sub.data = pSample->data;
			pFunction->childs.push_back(sub);
		}
	}

	// Combine similar samples.
	for (int i = 0; i < (int)pFunction->childs.size(); i++)
	{
		for (int j = i+1; j < (int)pFunction->childs.size(); j++)
		{
			if (pFunction->childs[i].name == pFunction->childs[j].name)
			{
				pFunction->childs[i].data.Add(pFunction->childs[j].data);
				pFunction->childs.erase( pFunction->childs.begin()+j );
				j--;
			}
		}
	}
	for (int i = 0; i < (int)pFunction->parents.size(); i++)
	{
		for (int j = i+1; j < (int)pFunction->parents.size(); j++)
		{
			if (pFunction->parents[i].name == pFunction->parents[j].name)
			{
				pFunction->parents[i].data.Add(pFunction->parents[j].data);
				pFunction->parents.erase( pFunction->parents.begin()+j );
				j--;
			}
		}
	}

	// Calculate percentages.
	double totalTime = 0;
	for (int i = 0; i < (int)pFunction->childs.size(); i++)
	{
		totalTime += pFunction->childs[i].data.totalTime;
	}
	for (int i = 0; i < (int)pFunction->childs.size(); i++)
	{
		pFunction->childs[i].data.percentage = float(pFunction->childs[i].data.totalTime/totalTime)*100;
	}

	totalTime = 0;
	for (int i = 0; i < (int)pFunction->parents.size(); i++)
	{
		totalTime += pFunction->parents[i].data.totalTime;
	}
	for (int i = 0; i < (int)pFunction->parents.size(); i++)
	{
		pFunction->parents[i].data.percentage = float(pFunction->parents[i].data.totalTime/totalTime)*100;
	}

}
