#ifndef _ProfileData_h_
#define _ProfileData_h_
#pragma once;

#include <vector>

struct SProfilerData
{
	int calls;
	float percentage;
	float selfTime;
	float totalTime;
	int selfMemory;
	int totalMemory;

	int selfSeeks;
	int selfReads;
	int selfOpens;
	int totalSeeks;
	int totalReads;
	int totalOpens;
	int selfDiskSize;
	int totalDiskSize;

	//////////////////////////////////////////////////////////////////////////
	void Add( SProfilerData &from )
	{
		calls += from.calls;
		selfTime += from.selfTime;
		totalTime += from.totalTime;
		selfMemory += from.selfMemory;
		totalMemory += from.totalMemory;

		selfSeeks += from.selfSeeks;
		selfReads += from.selfReads;
		selfOpens += from.selfOpens;
		totalSeeks += from.totalSeeks;
		totalReads += from.totalReads;
		totalOpens += from.totalOpens;
		selfDiskSize += from.selfDiskSize;
		totalDiskSize += from.totalDiskSize;
	}
};

class CProfilerSample
{
public:
	CString name;
	CString parentName;
	
	CProfilerSample* pParent;
	std::vector<CProfilerSample*> childs;

	SProfilerData data;
};

//////////////////////////////////////////////////////////////////////////
class CProfilerFunction
{
public:
	CString name;
	SProfilerData data;

	struct SubFunction
	{
		CString name;
		SProfilerData data;
	};
	std::vector<SubFunction> parents;
	std::vector<SubFunction> childs;
};

//////////////////////////////////////////////////////////////////////////
class CProfilerDatabase
{
public:
	static CProfilerDatabase* Instance();

	bool Load( const char *filename );

	int GetSampleCount() const { return (int)m_samples.size(); }
	CProfilerSample* GetSample( int nIndex ) { return m_samples[nIndex]; }

	int GetFunctionCount() const { return (int)m_functions.size(); }
	CProfilerFunction* GetFunction( int nIndex ) { return m_functions[nIndex]; }

	void SetCurrentFunction( const CString &name );
	CProfilerFunction* GetCurrentFunction() const { return m_pCurrentFunction; };

	void GenerateFunctions();

private:
	CProfilerDatabase();
	~CProfilerDatabase();
	void ParseNode( class XmlNodeRef &node,CProfilerSample *pParent );
	void AddData( SProfilerData &to,SProfilerData &from );

private:
	std::vector<CProfilerSample*> m_samples;
	std::vector<CProfilerFunction*> m_functions;
	CProfilerFunction* m_pCurrentFunction;

	static CProfilerDatabase* m_sInstance;
};


#endif //_ProfileData_h_