// ReportControl.cpp: implementation of the CReportControl class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ReportControl.h"

IMPLEMENT_DYNAMIC(CMessageRecord, CXTPReportRecord)

struct SProfilerColumn
{
	int id;
	int width;
	const char *name;
};

//Function	Self (sec)	Total (sec)	Calls	Memory (Mb)	Read file size	Bandwith self (Kb/s)	Bandwith total (Kb/s)	FOpens self	FReads self	FSeeks self	FOpens total	FReads total	FSeeks total


static SProfilerColumn s_columns[] = 
{
	{ 0,300,"Function" },
	{ 1,30,"%" },
	{ 2,50,"Calls" },
	{ 3,50,"Self Time(s)" },
	{ 4,50,"Total Time(s)" },
	{ 5,50,"Self Memory(MB)" },
	{ 6,50,"Total Memory(MB)" },

	{ 7,50,"Self Seeks" },
	{ 8,50,"Total Seeks" },
	{ 9,50,"Self Reads" },
	{ 10,50,"Total Reads" },
	{ 11,50,"Self Opens" },
	{ 12,50,"Total Opens" },
	
	{ 13,50,"Self Disk Read(MB)" },
	{ 14,50,"Total Disk Read(MB)" },
	
	
	
	
	/*
	{ 6,100,"Read File Size" },
	{ 7,100,"Bandwidth Self (Kb/s)" },
	{ 8,100,"Bandwidth Total (Kb/s)" },
	{ 9,100,"FOpen Self" },
	{ 10,100,"FOpen Total" },
	{ 11,100,"FRead Self" },
	{ 12,100,"FRead Total" },
	{ 13,100,"FSeek Self" },
	{ 14,100,"FSeek Total" },
	*/
};

CMessageRecord::CMessageRecord()
{
	pFunction = 0;
	pSample = 0;
}

//////////////////////////////////////////////////////////////////////////
void CMessageRecord::AddFloatItem( float val )
{
	AddItem(new CXTPReportRecordItemNumber(val))->SetFormatString("%.3f");
}

//////////////////////////////////////////////////////////////////////////
void CMessageRecord::AddIntItem( int val )
{
	AddItem(new CXTPReportRecordItemNumber(val));
}

void CMessageRecord::CreateItems()
{
	// Initialize record items with empty values
	CXTPReportRecordItem *pText = AddItem(new CXTPReportRecordItemText(name));
	pText->SetBold(TRUE);
	AddItem(new CXTPReportRecordItemNumber(data.percentage))->SetAlignment(1);
	AddItem(new CXTPReportRecordItemNumber(data.calls));
	AddFloatItem(data.selfTime);
	AddFloatItem(data.totalTime);
	AddIntItem(data.selfMemory);
	AddIntItem(data.totalMemory);
	AddIntItem( data.selfSeeks );
	AddIntItem( data.totalSeeks );
	AddIntItem( data.selfReads );
	AddIntItem( data.totalReads );
	AddIntItem( data.selfOpens );
	AddIntItem( data.totalOpens );
	AddIntItem(data.selfDiskSize/(1024*1024));
	AddIntItem(data.totalDiskSize/(1024*1024));
}

CMessageRecord::~CMessageRecord()
{
}

//////////////////////////////////////////////////////////////////////////
void CMessageRecord::SetFromProfileSample( CProfilerSample *inEntry )
{
	pSample = inEntry;
	name = pSample->name;
	data = pSample->data;
	CreateItems();
}

//////////////////////////////////////////////////////////////////////////
void CMessageRecord::SetFromProfileFunction( CProfilerFunction *pFunc )
{
	pFunction = pFunc;
	name = pFunc->name;
	data = pFunc->data;
	CreateItems();
}

//////////////////////////////////////////////////////////////////////
void CMessageRecord::SetData( const CString &_name,const SProfilerData &_data )
{
	name = _name;
	data = _data;
	CreateItems();
}

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CReportControl::CReportControl()
{
	m_pFocusedRecord = NULL;
	m_pTopRow = NULL;
}

CReportControl::~CReportControl()
{
	if(m_pFocusedRecord)
		m_pFocusedRecord = NULL;
}


/////////////////////////////////////////////////////////////////////////////
// Message map

BEGIN_MESSAGE_MAP(CReportControl, CXTPReportControl)
END_MESSAGE_MAP()


BOOL CReportControl::OnFocusChanging(CXTPReportRow* pNewRow, CXTPReportColumn* pNewCol)
{
	/*
	CXTPReportControl::OnFocusChanging(pNewRow, pNewCol);

	// apply changes
	CXTPReportRow* pFocusedRow = GetFocusedRow();
	if(pFocusedRow && pFocusedRow->GetType() == xtpRowTypeHeader && pNewRow != GetFocusedRow() && m_pFocusedRecord && pNewRow->GetType() != xtpRowTypeHeader)
	{
		*(CMessageRecord*)m_pFocusedRecord = *(CMessageRecord*)pFocusedRow->GetRecord();

		UpdateRecord(m_pFocusedRecord, FALSE);

	}
	// set new header row
	if(!pNewRow || pNewRow == GetFocusedRow() || pNewRow->GetType() == xtpRowTypeHeader)
		return TRUE;
	if(m_pFocusedRecord)
		m_pFocusedRecord = NULL;
	if(!pNewRow->GetRecord())
	{
		GetHeaderRecords()->RemoveAll();
		GetHeaderRecords()->Add(new CMessageRecord());
		PopulateHeaderRows();
		return TRUE;
	}
	m_pFocusedRecord = pNewRow->GetRecord();
	GetHeaderRecords()->RemoveAll();
	GetHeaderRecords()->Add(new CMessageRecord(MessageRecord*)m_pFocusedRecord));
	PopulateHeaderRows();
	*/

	return TRUE;
}

void CReportControl::InitColumns()
{
	for (int i = 0; i < sizeof(s_columns)/sizeof(s_columns[0]); i++)
	{
		SProfilerColumn &clm = s_columns[i];
		CXTPReportColumn *pColumn = AddColumn(new CXTPReportColumn(i, clm.name, clm.width));

		if (i == 0 && m_type == REPORT_TREE)
		{
			pColumn->SetTreeColumn(true);
			pColumn->SetSortable(FALSE);
		}
	}
}

//////////////////////////////////////////////////////////////////////////
void CReportControl::Init( EReportControlType type )
{
	m_type = type;
	GetPaintManager()->SetColumnStyle(xtpReportColumnOffice2007);
	AllowEdit(FALSE);
	EditOnClick(FALSE);
	//AllowColumnRemove(FALSE);

	GetReportHeader()->AllowColumnRemove(FALSE);
	if (type == REPORT_TREE)
	{
		GetReportHeader()->AllowColumnSort(FALSE);
	}

	InitColumns();
}

//////////////////////////////////////////////////////////////////////////
void CReportControl::Reload()
{
	GetRecords()->RemoveAll();

	CProfilerDatabase *pd = CProfilerDatabase::Instance();
	CProfilerFunction *pCurrentFunction = pd->GetCurrentFunction();

	if (m_type == REPORT_ALL)
	{
		int num = pd->GetFunctionCount();
		for (int i = 0; i < num; i++)
		{
			CProfilerFunction *pe = pd->GetFunction(i);
			CMessageRecord *pRec = (CMessageRecord*)AddRecord( new CMessageRecord() );
			pRec->SetFromProfileFunction(pe);
		}

	}
	else if (m_type == REPORT_SELF)
	{
		if (pCurrentFunction)
		{
			CMessageRecord *pRec = (CMessageRecord*)AddRecord( new CMessageRecord() );
			pRec->SetFromProfileFunction(pCurrentFunction);
		}
	}
	else if (m_type == REPORT_PARENT)
	{
		if (pCurrentFunction)
		{
			for (int i = 0; i < (int)pCurrentFunction->parents.size(); i++)
			{
				CProfilerFunction::SubFunction &sub = pCurrentFunction->parents[i];
				CMessageRecord *pRec = (CMessageRecord*)AddRecord( new CMessageRecord() );
				pRec->SetData(sub.name,sub.data);
			}
		}
	}
	else if (m_type == REPORT_CHILDREN)
	{
		if (pCurrentFunction)
		{
			for (int i = 0; i < (int)pCurrentFunction->childs.size(); i++)
			{
				CProfilerFunction::SubFunction &sub = pCurrentFunction->childs[i];
				CMessageRecord *pRec = (CMessageRecord*)AddRecord( new CMessageRecord() );
				pRec->SetData(sub.name,sub.data);
			}
		}
	}
	else if (m_type == REPORT_TREE)
	{
		std::map<CProfilerSample*,CMessageRecord*> mapRecords;
		int num = pd->GetSampleCount();
		for (int i = 0; i < num; i++)
		{
			CProfilerSample *pSample = pd->GetSample(i);

			CMessageRecord *pRec = new CMessageRecord();
			pRec->SetFromProfileSample(pSample);

			CMessageRecord *pParentRecord = 0;
			if (pSample->pParent)
			{
				pParentRecord = stl::find_in_map(mapRecords,pSample->pParent,0);
			}
			mapRecords[pSample] = pRec;

			if (pParentRecord)
			{
				pParentRecord->GetChilds()->Add( pRec );
			}
			else
			{
				AddRecord( pRec );
			}
		}
	}


	Populate();
}
