// ReportControl.h: interface for the CReportControl class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_REPORTCONTROL_H__7361D7E3_7483_4EAC_BDC2_15CA2BC0F49B__INCLUDED_)
#define AFX_REPORTCONTROL_H__7361D7E3_7483_4EAC_BDC2_15CA2BC0F49B__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "ProfileData.h"

enum EReportControlType
{
	REPORT_ALL = 0,
	REPORT_PARENT = 1,
	REPORT_CHILDREN = 2,
	REPORT_SELF = 3,
	REPORT_TREE = 4,
	REPORT_COUNT = 5,
};

class CMessageRecord : public CXTPReportRecord
{
	DECLARE_DYNAMIC(CMessageRecord)
public:
	CProfilerSample *pSample;
	CProfilerFunction *pFunction;
	CString name;
	SProfilerData data;

public:
	// Construct record object using empty values on each field
	CMessageRecord();

	// Clean up internal objects
	virtual ~CMessageRecord();

	// Create record fields using empty values
	virtual void CreateItems();

	void SetFromProfileSample( CProfilerSample *pEntry );
	void SetFromProfileFunction( CProfilerFunction *pFunc );
	void SetData( const CString &name,const SProfilerData &data );
	void AddFloatItem( float val );
	void AddIntItem( int val );
};


#define WM_ADD_RECORD_EX (WM_USER + 1)

class CReportControl : public CXTPReportControl  
{
public:
	CReportControl();
	virtual ~CReportControl();

	void Init( EReportControlType type );
	void Reload();
	EReportControlType GetType() const { return m_type; }

protected:
	void InitColumns();

// Attributes
public:
protected:
	EReportControlType m_type;
	CXTPReportRecord* m_pFocusedRecord;
	CXTPReportRow* m_pTopRow;


// Implementation
public:
	virtual BOOL OnFocusChanging(CXTPReportRow* pNewRow, CXTPReportColumn* pNewCol);

	// Generated message map functions
protected:
	DECLARE_MESSAGE_MAP()
};

#endif // !defined(AFX_REPORTCONTROL_H__7361D7E3_7483_4EAC_BDC2_15CA2BC0F49B__INCLUDED_)
