#ifndef __CRYEXPORTER_H__
#define __CRYEXPORTER_H__

#include "ExportSource.h"
#include "Export/ColladaExportWriter.h"

#include <fbsdk/fbsdk.h>

class CryExportTool : public FBTool
{
	FBToolDeclare(CryExportTool, FBTool);

public:
	// MB construction and destruction.
	virtual bool FBCreate();
	virtual void FBDestroy();

private:
	void CreateUI();

	void OnExportClicked(HISender pSender, HKEvent pEvent);
	void OnConfigRCClicked(HISender pSender, HKEvent pEvent);

	ExportSource m_source;
	ColladaExportWriter m_writer;

	FBLabel m_LabelExport;
	FBButton m_ButtonExport;
	FBButton m_ButtonConfigRC;
};

#endif //__CRYEXPORTER_H__
