#############################################################################
## Crytek Source File
## Copyright (C) 2006, Crytek Studios
##
## Creator: Sascha Demetrio
## Date: May 2, 2007
## Description: GNU-make based build system
#############################################################################

# Settings specific to the CryCG code analysis and instrumentation tool.

# Filename extension for the generated index files.
ifndef EXT_CCG
 EXT_CCG := ccg
endif

# Filename extension for the generated dependency files.
ifndef EXT_D
 EXT_D := d
endif
ifdef EXT_D_TMP
 ext_d := $(EXT_D_TMP)
else
 ext_d := $(EXT_D)
endif

ifneq ($(HOST_SYSTEM),linux)
 EXE_EXT := .exe
endif

ifneq ($(MKOPTION_USE_PREGEN_SPUFILES),1)
  ifeq ($(MKOPTION_CRYCGPROFILE),1)
    CRYCG := $(MAKE_TOOLS_BINDIR)/crycg_profile$(EXE_EXT)
  else
    CRYCG := $(MAKE_TOOLS_BINDIR)/crycg$(EXE_EXT)
  endif
else
  CRYCG := $(PERL) $(MAKE_ROOT)/Tools/crycg_wrapper.pl
endif

# crycg default include directories 
CRYCG_DEFAULT_INCLUDE_DIRS := '$(MAKE_ROOT)/Tools/crycg/ppu/include,$(CELL_SDK)/target/common/include,$(CELL_SDK)/target/spu/include'

# FIXME:
# The -R option makes crycg read back the generated CCG file and compare the
# tree hash and CRCs to verify that the serialization worked as expected.
# This increases the running time by a few seconds and should be removed after
# a testing period.
export CRYCGFLAGS := \
	-c $(MAKE_ROOT)/Tools/crycg.conf -R \
	-CTmpDir:$(BUILD_TEMP) \
	-DTARGET=$(TARGET) -DBUILD_ROOT=$(BUILD_ROOT)

# OPTION_CRYCG_FRONTEND_COMPILER 
# set this value in Config.mk to the path in which the modified
# frontend compiler for crycg can be found.
ifdef OPTION_CRYCG_FRONTEND_COMPILER 
 CRYCGFLAGS += \
	-DFRONTEND_ROOT=$(MAKE_ROOT)/Tools/$(HOST_BINDIR)/$(OPTION_CRYCG_FRONTEND_COMPILER)/bin
else
 CRYCGFLAGS += \
	-DFRONTEND_ROOT=$(MAKE_ROOT)/Tools/$(HOST_BINDIR)/ppu-crycg/bin 
endif 

# OPTION_CRYCG_SYSTEM_INCLUDEDIR
# set this value to the path in which the system include header file
# can be found for the modified frontend compiler 
ifdef OPTION_CRYCG_SYSTEM_INCLUDEDIRS
 CRYCGFLAGS += \
	-CSystemIncludeDirs:'$(OPTION_CRYCG_SYSTEM_INCLUDEDIRS)'
else 
 CRYCGFLAGS += \
	-CSystemIncludeDirs:'$(CRYCG_DEFAULT_INCLUDE_DIRS)'
endif

# OPTION_CRCYG_SYSTEM_HEADERS
# Set this value to a system header that will be included first for
# every file that is compiled with the frontend compiler by crycg
ifdef OPTION_CRYCG_SYSTEM_HEADERS
 CRYCGFLAGS += -CSystemHeaders:'$(foreach header,$(OPTION_CRYCG_SYSTEM_HEADERS),$(header),)'
endif 

ifneq ($(MKOPTION_VERBOSE),1)
 CRYCGFLAGS += -CLogLevel:notice
endif

ifeq ($(OPTION_DEVIRTUALIZE),1)
 CRYCGFLAGS += \
	-CVirtualMapping:'$(BUILD_ROOT)/../DeVirtCache/crycg_virtual_functions_list'
endif

ifdef OPTION_PS3_CRYCGFLAGS
 CRYCGFLAGS += $(OPTION_PS3_CRYCGFLAGS)
 $(warning user specified flags for crycg: $(OPTION_PS3_CRYCGFLAGS))
endif

SCAN_CXX = \
	$(CRYCG) scan/c++ $(CRYCGFLAGS) -o '$(3)' \
	  -- $(4) $(CFLAGS_SCAN) $(CXXFLAGS_SCAN) $(CPPFLAGS_SCAN) \
	  -MP -MMD \
	  -MF '$(patsubst %.$(EXT_CCG),%.$(ext_d),$(3))' \
	  -MQ '$(3)' \
	  -o '$(patsubst %.$(EXT_CCG),%.s,$(3))' \
	  '$(2)' && rm -f '$(patsubst %.$(EXT_CCG),%.s,$(3))'

SCAN_C = \
	$(CRYCG) scan/c $(CRYCGFLAGS) -o '$(3)' \
	  -- $(4) $(CFLAGS_SCAN) $(CXXFLAGS_SCAN) $(CPPFLAGS_SCAN) \
	  -MP -MMD \
	  -MF '$(patsubst %.$(EXT_CCG),%.$(ext_d),$(3))' \
	  -MQ '$(3)' \
	  -o '$(patsubst %.$(EXT_CCG),%.s,$(3))' \
	  '$(2)' && rm -f '$(patsubst %.$(EXT_CCG),%.s,$(3))'

SCAN_MODULE_NAME = $(addsuffix .ccgindex,$(1))

SCAN_PROGRAM_NAME = $(addsuffix .ccgindex,$(1))

SCAN_MODULE_CLEAN = \
	$(call SCAN_MODULE_NAME,$(1)) \
	$(addsuffix .elt,$(1))

SCAN_PROGRAM_CLEAN = \
	$(call SCAN_PROGRAM_NAME,$(1)) \
	$(addsuffix .elt,$(1))

# XXX OBSOLETE
SCAN_OUTPUT_TO_ELEMENT = $(error SCAN_OUTPUT_TO_ELEMENT is obsolete)

SCANINDEX_MODULE = \
	$(CRYCG) index $(CRYCGFLAGS) -o '$(1)' $(2)

SCANINDEX_PROGRAM = \
	$(CRYCG) index $(CRYCGFLAGS) \
	  -o '$(1)' \
	  -E '$(patsubst %.ccgindex,%.elt,$(1))' \
	  $(2)

# Link a translation unit together from the prelinked spu code blob 
# Arguments: 
# $1 - the name of translation unit (job name)
# $2 - the full path to the output file 
# $3 - the full path to the input prelinked code file 
# $3 - the list of element hashes to extract from the prelinked code file
# Not used for crycg, creates an empty file to satisfy make dependencies
SCAN_LINK_JOB = mkdir -p `dirname $2` && touch $2

# Arch/CryCG.mk
# vim:ts=8:sw=2


