#############################################################################
## Crytek Source File
## Copyright (C) 2010, Crytek Studios
##
## Creator: Chris Raine 
## Date: it's cold outside
## Description: GNU-make based build system
#############################################################################

# CryCG CM replacement dropin specific settings.

# Filename extension for the generated code files 
ifndef EXT_CCG
 EXT_CCG := code
endif

# Filename extension for generated dependency files.
ifndef EXT_D
 EXT_D := d
endif
ifdef EXT_D_TMP
 ext_d := $(EXT_D_TMP)
else
 ext_d := $(EXT_D)
endif

# Binary flags 
CM := $(MAKE_TOOLS_BINDIR)/cm
CM_SPU_SYMTAB := $(MAKE_TOOLS_BINDIR)/cm_spu_symtab
CM_FLAGS_SCAN = --platform ps3 --no-exceptions --no-rtti -DCRYCG_CM=1

# Temporary define.  To be removed after switching to CryCG_CM.
ARCH_CPPFLAGS += -DUSING_CRYCG_CM=1

# Default include directories for crycg 
#CRYCG_DEFAULT_INCLUDE_DIRS := \
#	$(CELL_SDK)/target/common/include \
#	$(CELL_SDK)/target/spu/include

# OPTION_CRYCG_SYSTEM_INCLUDEDIR
# set this value to the path in which the system include header file
# can be found for the modified frontend compiler 
#ifdef OPTION_CRYCG_SYSTEM_INCLUDEDIRS
# CM_FLAGS_SCAN += $(foreach directory,$(OPTION_CRYCG_SYSTEM_INCLUDEDIRS),\
#	--system-include-path $(directory))
#else 
# CM_FLAGS_SCAN += $(foreach directory,$(CRYCG_DEFAULT_INCLUDE_DIRS),\
#	--system-include-path $(directory))
#endif

# OPTION_CRCYG_SYSTEM_HEADERS
# Set this value to a system header that will be included first for
# every file that is compiled with the frontend compiler by crycg
#ifdef OPTION_CRYCG_SYSTEM_HEADERS
# CM_FLAGS_SCAN += $(foreach header,$(OPTION_CRYCG_SYSTEM_HEADERS),--include $(header))
#endif 

export CM_TARGET_SYSTEM_DIR := $(MAKE_ROOT)/Tools/codemirror/0.0/sys/PS3/$(HOST_BINDIR)

ifeq ($(OPTION_DEVIRTUALIZE),1)
  export CM_CRYCG_VIRTUAL_MAPPING = $(BUILD_ROOT)/../DeVirtCache/crycg_virtual_functions_list
endif

# Functions to scan code to convert c/c++ files into codemirror code files 
SCAN_CXX = \
	$(CM) scan --language c++ $(CM_FLAGS_SCAN) -o '$(3)' '$(2)' \
		--depfile '$(patsubst %.$(EXT_CCG),%.$(ext_d),$(3))' \
		$(patsubst -O%,,$(patsubst -f%,,$(subst -iquote,-I,$(4)))) \
                $(CPPFLAGS_SCAN) 
SCAN_C = \
	$(CM) scan --language c $(CM_FLAGS_SCAN) -o '$(3)' '$(2)' \
		--depfile '$(patsubst %.$(EXT_CCG),%.$(ext_d),$(3))' \
		$(patsubst -O%,,$(patsubst -f%,,$(subst -iquote,-I,$(4)))) \
                $(CPPFLAGS_SCAN) 

SCAN_MODULE_NAME = $(addsuffix .code,$(1))

SCAN_PROGRAM_NAME = $(addsuffix .code,$(1))

SCAN_MODULE_CLEAN = \
	$(call SCAN_MODULE_NAME,$(1)) \

SCAN_PROGRAM_CLEAN = \
	$(call SCAN_PROGRAM_NAME,$(1)) \

SCAN_OUTPUT_TO_ELEMENT = $(error SCAN_OUTPUT_TO_ELEMENT is obsolete)

# Create a pre-linked a module file from the scanned input files 
#
# Arguments : 
# $1 - output file 
# $2 - input files 
SCANINDEX_MODULE = \
	$(CM) link -o '$(1)' -n '$1' $(2)

# Create a pre-linked code file from all scanned translation units  
#
# Arguments : $1 - output file 
#
# Note: This step also creates the elt file required for
# postscan.pl/Elements.pm
SCANINDEX_PROGRAM = \
	$(CM) link -p guid \
	  -o '$(1)' \
	  -n '$(1)' \
	  $(2) &&  \
	$(CM_SPU_SYMTAB) \
		-i '$(1)' -o '$(patsubst %.code,%.elt,$(1))'

# Link a translation unit together from the prelinked spu code blob 
# Arguments: 
# $1 - the name of translation unit (job name)
# $2 - the full path to the output file 
# $3 - the full path to the input prelinked code file 
# $3 - the list of element hashes to extract from the prelinked code file
SCAN_LINK_JOB = \
	$(CM) link -p canonical-inline -p lower -n $1 -o $2 $3 $(foreach symbol,$4,-s $(symbol))
