#############################################################################
## Crytek Source File
## Copyright (C) 2006, Crytek Studios
##
## Creator: Sascha Demetrio
## Date: Jul 31, 2006
## Description: GNU-make based build system
#############################################################################

# GCC specific settings.

# Filename extension for compiled object files.
ifndef EXT_O
 EXT_O := o
endif

# Filename extension for precompiled header files.
ifndef EXT_PCH
 EXT_PCH := h.gch
endif

# Filename extension for linker map files.
ifndef EXT_MAP
 EXT_MAP := map
endif

# Add -fPIC for shared modules.  However, on PS3 PPU, -fPIC may _not_ be used.
ifeq ($(OPTION_MODULE_LINKMODE),shared)
 ifneq ($(ARCH),PS3-cell)
  ARCH_CFLAGS += -fPIC
 endif
endif

# Filename extension for generated dependency files.
ifndef EXT_D
 EXT_D := d
endif
ifdef EXT_D_TMP
 ext_d := $(EXT_D_TMP)
else
 ext_d := $(EXT_D)
endif

# Support for ccache and distcc.
ifeq ($(MKOPTION_CCACHE),1)
 CCACHE ?= ccache
 ifeq ($(MKOPTION_DISTCC),1)
  # Note: The CCACHE_PREFIX environment variable (typically used to invoke
  # 'distcc' from 'ccache') causes problems with the compilers from the Cell
  # SDK, so we're simply embedding the 'distcc' call into the 'ccache' call.
  DISTCC ?= distcc
  CCACHE_PREFIX := $(DISTCC)
  export CCACHE_PREFIX
  CPREFIX := $(CCACHE)
 else
  CPREFIX := $(CCACHE)
 endif
else
 ifeq ($(MKOPTION_DISTCC),1)
  DISTCC ?= distcc
  CPREFIX := $(DISTCC)
 endif
 ifeq ($(MKOPTION_INCREDIBUILD),1)
  CPREFIX := $(PERL) '$(MAKE_ROOT)/Tools/incredibuild.pl' '$(INCREDIBAT)' 'size'
 endif
endif
CPREFIX ?=
ifeq ($(MKOPTION_DISTRIBUTED),1)
 # For distributed builds, we must rely on the compiler being in the
 # executable search path of the machine running the compiler.
 CPREFIX_CXX := $(CPREFIX) $(notdir $(CXX))
 CPREFIX_CC := $(CPREFIX) $(notdir $(CC))
else
 # For non distributed builds, we must *also* rely on the compiler being 
 # in the executable search path of the machine running the compiler. 
 CPREFIX_CXX := $(CPREFIX) $(notdir $(CXX))
 CPREFIX_CC := $(CPREFIX) $(notdir $(CC))
endif

ifneq ($(MKOPTION_NOPCH),1)
 CXXPCHFLAGS = -include $(PROJECT_BUILD)/$(PROJECT_SOURCE_PCH)
 CPCHFLAGS =
 gccpch_flags =
 ifeq ($(MKOPTION_DISTCC),1)
  export DISTCC_PCH = 1
  export DISTCC_PCH_PROXY = 1
  gccpch_flags += -dD
 endif
else
 CXXPCHFLAGS =
 CPCHFLAGS =
 gccpch_flags =
endif

# Compile functions.
COMPILE_CXX = \
	$(CPREFIX_CXX) \
	  $(4) $(CFLAGS) $(CXXFLAGS) $(CPPFLAGS) \
	  -MP -MMD \
	  -MF '$(patsubst %.$(EXT_O),%.$(ext_d),$(3))' \
	  -MQ '$(3)' \
	  -c '$(2)' -o '$(3)'
COMPILE_C = \
	$(CPREFIX_CC) \
	  $(4) $(CFLAGS) $(CPPFLAGS) \
	  -MP -MMD \
	  -MF '$(patsubst %.$(EXT_O),%.$(ext_d),$(3))' \
	  -MQ '$(3)' \
	  -c '$(2)' -o '$(3)'
COMPILE_PCH = \
	$(CPREFIX_CXX) \
	  $(gccpch_flags) \
	  -w $(4) $(CFLAGS) $(CXXFLAGS) $(CPPFLAGS) \
	  -MP -MMD \
	  -MF '$(patsubst %.$(EXT_PCH),%.h.$(ext_d),$(3))' \
	  -MQ '$(3)' \
	  -c '$(2)' -o '$(3)'

# 'module' projects.
LINK_MODULE_NAME_shared = $(addsuffix .so,$(1))
LINK_MODULE_NAME_static = $(addsuffix .o,$(1))
ifeq ($(OPTION_MODULE_LINKMODE),shared)
 # When linking a module to a shared object, we'll include the project
 # specific libraries but skip the rest.  Everyting in $(LDLIBS) will be
 # linked to the final program executable, so there's no need to add this
 # here.
 COMPILE_MODULE_NAME :=
 COMPILE_MODULE :=
 LINK_MODULE_NAME = $(LINK_MODULE_NAME_shared)
 LINK_MODULE = $(CXX) $(PROJECT_LDFLAGS) -shared $(LDSFLAGS) -Wl,-soname,./$(notdir $(1)) -o $(1) $(2) \
	$(PROJECT_LDLIBS)
endif # OPTION_MODULE_LINKMODE == shared
ifeq ($(OPTION_MODULE_LINKMODE),static)
 # Static linking using 'ld -r'.
 COMPILE_MODULE_NAME :=
 COMPILE_MODULE :=
 LINK_MODULE_NAME = $(LINK_MODULE_NAME_static)
 # Note that we don't add libraries to the invocation when linking a module
 # statically.
 LINK_MODULE = $(LD) -r $(LDRFLAGS) $(PROJECT_LDFLAGS) -o '$(1)' $(2)
endif # OPTION_MODULE_LINKMODE == static
ifndef LINK_MODULE
 $(error Unrecognized module link mode '$(OPTION_MODULE_LINKMODE)')
endif

# 'program' projects.
COMPILE_PROGRAM_NAME :=
COMPILE_PROGRAM :=
LINK_PROGRAM_NAME = $(1)
ifneq ($(OPTION_PS3_EXEC_NAME),)
  MAP_PROGRAM_NAME = $(output_dir)/$(OPTION_PS3_EXEC_NAME)$(output_suffix).$(EXT_MAP)
else
  MAP_PROGRAM_NAME = $(1).$(EXT_MAP)
endif

ifeq ($(OPTION_LD_MAPFILE),1)
 LINK_PROGRAM = $(CXX) $(LDFLAGS) -o '$(1)' \
	'-Wl,-Map,$(MAP_PROGRAM_NAME)' \
	$(2) $(LDLIBS)
else
 LINK_PROGRAM = $(CXX) $(LDFLAGS) -o '$(1)' $(2) $(LDLIBS)
endif

# Some GCC specifics.
ifneq ($(STAGE),gccxml)
 ARCH_CPPFLAGS += -Winvalid-pch
endif

# User specific code enabled via USER_$(USERNAME).
ifneq ($(OPTION_USER),)
 ARCH_CPPFLAGS += -DUSER_$(shell echo -n '$(OPTION_USER)' |tr a-z A-Z)
endif

# Handle build options.
ifeq ($(OPTION_DEBUG),1)
 ARCH_CFLAGS += -g
 ARCH_LDFLAGS += -g
 ARCH_LDRFLAGS += -g
endif # OPTION_DEBUG

ARCH_CFLAGS += -fvisibility=hidden

ifeq ($(OPTION_GPROF),1)
 ARCH_CFLAGS += -pg
 ARCH_LDFLAGS += -pg
 ARCH_CPPFLAGS += -D__GPROF__
endif

ifeq ($(OPTION_GCOV),1)
 ARCH_CFLAGS += -ftest-coverage -fprofile-arcs
 ARCH_CPPFLAGS += -D__GCOV__
 OPTION_LINK_GCOV := 1
endif
ifeq ($(OPTION_LINK_GCOV),1)
 ARCH_LDFLAGS += -fprofile-arcs
 ARCH_CPPFLAGS += -D__LINK_GCOV__
endif

ifneq ($(OPTION_DEBUG),1)
  ifneq ($(OPTION_NODEBUGSYM),1)
   ARCH_CFLAGS += -g
  endif
endif # !OPTION_DEBUG

ifeq ($(OPTION_RELEASE),1)
 ARCH_XFLAGS += -O3
else
  ifeq ($(OPTION_PROFILE),1)
    ifeq ($(findstring Linux,$(ARCH)),Linux)
      ARCH_XFLAGS += -march=nocona -mfpmath=sse -msse3 -O3
    endif
  endif
endif

# Indicate that the compiler is GCC.
COMPILER_IS_GCC := 1

# Arch/GCC.mk
# vim:ts=8:sw=8

