#############################################################################
## Crytek Source File
## Copyright (C) 2006, Crytek Studios
##
## Creator: Sascha Demetrio
## Date: Jul 31, 2006
## Description: GNU-make based build system
#############################################################################

# Architecture specific makefile for Linux systems in general.

# Build tools.
CC := gcc
CXX := g++
MAKEDEPEND := makedepend

COMPRESS := gzip
EXT_Z := .gz

TOUCH := touch
MKDIR_P := mkdir -p
PERL := perl

# Warning flags.
warn_cflags := -Wformat -Wmissing-braces -Wreturn-type \
	-Wno-multichar -Wsequence-point
ifneq ($(STAGE),gccxml)
warn_cxxflags := -Wno-invalid-offsetof
else
warn_cxxflags :=
endif

# Architecture specific command flags.
ARCH_CFLAGS := $(warn_cflags)
ARCH_CXXFLAGS := $(warn_cxxflags) \
	-fpermissive -fms-extensions -fno-rtti
ifneq ($(OPTION_AUTO_TESTS), 1)
ARCH_CXXFLAGS := $(ARCH_CXXFLAGS) -fno-exceptions
endif
ARCH_CPPFLAGS := -DLINUX -DENABLE_TYPE_INFO
ARCH_CXXFLAGS_module := -fvisibility=hidden -fvisibility-inlines-hidden
ARCH_LDFLAGS :=
ARCH_LDLIBS := -ldl -lpthread -lncurses -lrt
ifeq ($(OPTION_PROFILE),1)
	ARCH_XFLAGS := -march=nocona -mfpmath=sse -msse3 -O3
else
	ARCH_XFLAGS := 
endif


ARCH_CPPFLAGS_COMMON := -DEXE_VERSION_INFO_0=$(BUILD_VER)
ifeq ($(OPTION_AUTO_TESTS), 1)
ARCH_CPPFLAGS_COMMON := $(ARCH_CPPFLAGS_COMMON) -DCRY_UNIT_TESTING
endif

include $(MAKE_ROOT)/Arch/GCC.mk

# Arch/Linux.mk
# vim:ts=8:sw=8

