#############################################################################
## Crytek Source File
## Copyright (C) 2006, Crytek Studios
##
## Creator: Sascha Demetrio
## Date: Jul 31, 2006
## Description: GNU-make based build system
#############################################################################

# Architecture specific makefile for PS3.

# Default option values.
default_STAGES := compile link
default_MKOPTION_UNITYBUILD := 1
default_MKOPTION_NOPCH := 1
default_MKOPTION_STRIP_DEAD_CODE := 1
ifeq ($(HOST_SYSTEM),Linux)
 default_MKOPTION_LOGROTATE := 1
else
 default_MKOPTION_LOGROTATE := 0
endif
default_OPTION_NODEBUGSYM := 0
default_OPTION_WARN_LHS_MICRO := 0
default_OPTION_SUPP_FP_EXCEPTION := 0
default_OPTION_PS3_GCSECTIONS := 1
default_OPTION_PS3_SNTUNER := 0
default_OPTION_PS3_GCMHUD := 0
default_OPTION_PS3_GCMDEBUG := 0
default_OPTION_PS3_SPU_PROFILE := 0
default_OPTION_PS3_PROFILE_LOCKS := 0
default_OPTION_INCLUDE_FACEGEN := 0
default_MKOPTION_RELEASE := 0
default_OPTION_PS3_NOMEMMAN := 0
default_OPTION_PS3_NOPRXEXPORTPICKUP := 1
default_OPTION_PS3_PRXSTRIP := 1
default_OPTION_PS3_SPU_SNDEBUG := 1
default_OPTION_PS3_SPU_NO_BRANCH_HINT := 0
default_OPTION_PS3_USE_STLPORT := 1
default_OPTION_LD_MAPFILE := 0
default_MKOPTION_PS3_COPYMAP := 0
default_OPTION_SPU_REP_SIZE_KB := 1750
default_OPTION_MAIN_THREAD_STACK_SIZE_KB := 64
default_OPTION_MAIN_STACK_SIZE_KB := 256
default_OPTION_SPU_PAGESIZE_KB := 64
default_OPTION_SPU_INITIAL_PAGESIZE_KB := 3
default_OPTION_PS3_USE_SNLD := 1
default_OPTION_PS3_SPU_SNDEBUG := 1
default_OPTION_PS3_OPTIMIZED_CODE := 1
default_OPTION_PS3_GCMREPLAY := 0
default_OPTION_PS3_DEBUG_FILEHANDLER := 0
default_OPTION_DEVIRTUALIZE := 1
default_OPTION_CRYCG_DEFAULT_PAGEMODE := Single 
default_OPTION_ASSERT := 0
default_OPTION_PS3_SPU_MEM_CHECK := 0
default_MKOPTION_NOILINE := 0
default_MKOPTION_INCREDIBUILD_SHOWCONSOLE := 1
default_MKOPTION_PS3_ENABLE_UNITTESTS := 0
default_MKOPTION_USE_PREGEN_SPUFILES := 0
default_MKOPTION_USE_CM := 0
default_MKOPTION_CRYCG_CM := 0
default_MKOPTION_CRYSIZER_HEAP_TRAVERSAL := 0

# Select the CELL SDK to be used.
# We'll the Cell SDK from Code/SDKs/PS3, even if $(CELL_SDK) is specified (via
# environment or explicit override request).
# If you really want to use another Cell SDK, point $(CELL_SDK) to the
# alternative SDK and set $(CELL_SDK_OVERRIDE) to 1.
set_cell_sdk := 0
override_cell_sdk := 0
ifneq ($(origin CELL_SDK),undefined)
 ifeq ($(CELL_SDK_OVERRIDE),1)
#  $(warning CELL_SDK override requested, using CELL_SDK=$(CELL_SDK))
 else
  set_cell_sdk := 1
  override_cell_sdk := 1
 endif
else
 set_cell_sdk := 1
endif

ifeq ($(set_cell_sdk),1)
 # KNOWN BUG:
 # On Cygwin/Win32 systems, CELL_SDK should be set in Windows notation, not
 # Cygwin notation.
 # Workaround: Set a system-wide CELL_SDK environment on Windows systems.
 ifneq ($(origin DEPOT_MAIN),undefined)
  cell_sdk := $(DEPOT_MAIN)/Code/SDKs/PS3/cell
 else
  cell_sdk := $(CODE_ROOT)/SDKs/PS3/cell
 endif
 #ifeq ($(override_cell_sdk),1)
 # ifneq ($(cell_sdk),$(CELL_SDK))
 #  $(warning using CELL_SDK=$(cell_sdk))
 # endif
 #endif
 CELL_SDK := $(cell_sdk)
endif # set_cell_sdk

export CELL_SDK

cell_tooldir := $(CELL_SDK)/$(HOST_BINDIR)


### Set default option for each compile option(must happend before they are used) ###

ifndef OPTION_PS3_USE_SNLD
 OPTION_PS3_USE_SNLD = $(default_OPTION_PS3_USE_SNLD)
endif
ifeq ($(MKOPTION_SNC),1)
  OPTION_PS3_USE_SNLD := 1
endif

ifndef MKOPTION_USE_CM
  MKOPTION_USE_CM := default_MKOPTION_USE_CM
endif

ifndef MKOPTION_CRYCG_CM
  MKOPTION_CRYCG_CM := default_MKOPTION_CRYCG_CM
endif


ifndef MKOPTION_PS3_ENABLE_UNITTESTS
  MKOPTION_PS3_ENABLE_UNITTESTS = $(default_MKOPTION_PS3_ENABLE_UNITTESTS)
endif 

ifndef MKOPTION_USE_PREGEN_SPUFILES
  MKOPTION_USE_PREGEN_SPUFILES = $(default_MKOPTION_USE_PREGEN_SPUFILES)
endif 

ifeq ($(MKOPTION_USE_PREGEN_SPUFILES),1)
  ifndef MKOPTION_PREGEN_ARCHIVE
   $(error MKOPTION_USE_PREGEN_SPUFILES active but MKOPTION_PREGEN_ARCHIVE not set)
  endif
endif

ifndef OPTION_PS3_SPU_MEM_CHECK
 OPTION_PS3_SPU_MEM_CHECK = $(default_OPTION_PS3_SPU_MEM_CHECK)
endif

ifndef OPTION_CRYCG_DEFAULT_PAGEMODE
 OPTION_CRYCG_DEFAULT_PAGEMODE = $(default_OPTION_CRYCG_DEFAULT_PAGEMODE)
endif 

# Devirtualization is now enabled by default for ps3 builds. To
# disable it, put OPTION_DEVIRTUALIZE := 0 into your Config.mk
ifndef OPTION_DEVIRTUALIZE
	OPTION_DEVIRTUALIZE := $(default_OPTION_DEVIRTUALIZE)
endif 

ifndef MKOPTION_CRYSIZER_HEAP_TRAVERSAL
	MKOPTION_CRYSIZER_HEAP_TRAVERSAL := $(default_MKOPTION_CRYSIZER_HEAP_TRAVERSAL)
endif

ifndef OPTION_PS3_OPTIMIZED_CODE
 OPTION_PS3_OPTIMIZED_CODE := $(default_OPTION_PS3_OPTIMIZED_CODE)
endif

ifndef MKOPTION_UNITYBUILD
 MKOPTION_UNITYBUILD := $(default_MKOPTION_UNITYBUILD)
endif

ifndef MKOPTION_NOPCH
 MKOPTION_NOPCH := $(default_MKOPTION_NOPCH)
endif

ifndef MKOPTION_STRIP_DEAD_CODE
 MKOPTION_STRIP_DEAD_CODE := $(default_MKOPTION_STRIP_DEAD_CODE)
endif

ifndef MKOPTION_LOGROTATE
 MKOPTION_LOGROTATE := $(default_MKOPTION_LOGROTATE)
endif

ifndef OPTION_NODEBUGSYM
 OPTION_NODEBUGSYM := $(default_OPTION_NODEBUGSYM)
endif

ifndef OPTION_WARN_LHS_MICRO
 OPTION_WARN_LHS_MICRO := $(default_OPTION_WARN_LHS_MICRO)
endif

ifndef OPTION_SUPP_FP_EXCEPTION
 OPTION_SUPP_FP_EXCEPTION := $(default_OPTION_SUPP_FP_EXCEPTION)
endif

ifndef OPTION_PS3_GCSECTIONS
 OPTION_PS3_GCSECTIONS := $(default_OPTION_PS3_GCSECTIONS)
 ifeq ($(OPTION_PS3_USE_SNLD),1)
  OPTION_PS3_GCSECTIONS := 0
 endif
endif

ifndef OPTION_PS3_NOPRXEXPORTPICKUP
 OPTION_PS3_NOPRXEXPORTPICKUP := $(default_OPTION_PS3_NOPRXEXPORTPICKUP)
endif

ifndef OPTION_PS3_PRXSTRIP
 OPTION_PS3_PRXSTRIP := $(default_OPTION_PS3_PRXSTRIP)
endif

ifndef OPTION_LD_MAPFILE
 OPTION_LD_MAPFILE := $(default_OPTION_LD_MAPFILE)
endif

ifndef MKOPTION_PS3_COPYMAP
 MKOPTION_PS3_COPYMAP := $(default_MKOPTION_PS3_COPYMAP)
endif

ifndef OPTION_ASSERT
 OPTION_ASSERT := $(default_OPTION_ASSERT)
endif

ifndef OPTION_PS3_SNTUNER
 OPTION_PS3_SNTUNER := $(default_OPTION_PS3_SNTUNER)
endif

ifndef OPTION_PS3_GCMHUD
 OPTION_PS3_GCMHUD := $(default_OPTION_PS3_GCMHUD)
endif

ifndef OPTION_PS3_GCMREPLAY
	OPTION_PS3_GCMREPLAY := $(default_OPTION_PS3_GCMREPLAY)
endif

ifndef OPTION_PS3_GCMDEBUG
 OPTION_PS3_GCMDEBUG := $(default_OPTION_PS3_GCMDEBUG)
endif

ifndef MKOPTION_NOILINE
 MKOPTION_NOILINE := $(default_MKOPTION_NOILINE)
endif

ifndef MKOPTION_INCREDIBUILD_SHOWCONSOLE
 MKOPTION_INCREDIBUILD_SHOWCONSOLE := $(default_MKOPTION_INCREDIBUILD_SHOWCONSOLE)
endif

# If to use the spu profiling lib, define flags for PPU and SPU
ifndef OPTION_PS3_SPU_PROFILE
 OPTION_PS3_SPU_PROFILE := $(default_OPTION_PS3_SPU_PROFILE)
endif


ifndef OPTION_PS3_PROFILE_LOCKS
 OPTION_PS3_PROFILE_LOCKS := $(default_OPTION_PS3_PROFILE_LOCKS)
endif

ifndef OPTION_INCLUDE_FACEGEN
 OPTION_INCLUDE_FACEGEN := $(default_OPTION_INCLUDE_FACEGEN)
endif

ifndef MKOPTION_RELEASE
 MKOPTION_RELEASE := $(default_MKOPTION_RELEASE)
endif

ifndef OPTION_PS3_SPU_NO_BRANCH_HINT
 OPTION_PS3_SPU_NO_BRANCH_HINT := $(default_OPTION_PS3_SPU_NO_BRANCH_HINT)
endif

ifndef OPTION_PS3_USE_STLPORT
 OPTION_PS3_USE_STLPORT = $(default_OPTION_PS3_USE_STLPORT)
endif

ifndef OPTION_PS3_NOMEMMAN
 OPTION_PS3_NOMEMMAN = $(default_OPTION_PS3_NOMEMMAN)
endif

ifndef OPTION_PS3_SPU_SNDEBUG
 OPTION_PS3_SPU_SNDEBUG := $(default_OPTION_PS3_SPU_SNDEBUG)
endif

ifndef OPTION_SPU_REP_SIZE_KB
 OPTION_SPU_REP_SIZE_KB := $(default_OPTION_SPU_REP_SIZE_KB)
endif	

ifndef OPTION_MAIN_THREAD_STACK_SIZE_KB
 OPTION_MAIN_THREAD_STACK_SIZE_KB := $(default_OPTION_MAIN_THREAD_STACK_SIZE_KB)
endif	

ifndef OPTION_MAIN_STACK_SIZE_KB
 OPTION_MAIN_STACK_SIZE_KB := $(default_OPTION_MAIN_STACK_SIZE_KB)
endif	

ifndef OPTION_SPU_PAGESIZE_KB
 OPTION_SPU_PAGESIZE_KB := $(default_OPTION_SPU_PAGESIZE_KB)
endif 

ifndef OPTION_SPU_INITIAL_PAGESIZE_KB
 OPTION_SPU_INITIAL_PAGESIZE_KB := $(default_OPTION_SPU_INITIAL_PAGESIZE_KB)
endif 


# Build tools (PPU).
_COMPILER_SET = 0
ifeq ($(MKOPTION_SNC),1)
  CC := $(cell_tooldir)/sn/bin/ps3ppusnc$(BUILD_EXE_EXT)
  CXX := $(cell_tooldir)/sn/bin/ps3ppusnc$(BUILD_EXE_EXT)
  AS := $(cell_tooldir)/sn/bin/ps3ppuas$(BUILD_EXE_EXT)
  OPTION_PS3_USE_SNLD := 1
  _COMPILER_SET = 1
endif

ifeq ($(MKOPTION_USE_CM),1)
  CC := $(MAKE_TOOLS_BINDIR)/cm_wrapper$(BUILD_EXE_EXT)
  CXX := $(MAKE_TOOLS_BINDIR)/cm_wrapper$(BUILD_EXE_EXT) 
  AS := $(cell_tooldir)/ppu/bin/ppu-lv2-as$(BUILD_EXE_EXT)
  _COMPILER_SET = 1
endif

ifeq ($(_COMPILER_SET),0)
  CC := $(cell_tooldir)/ppu/bin/ppu-lv2-gcc$(BUILD_EXE_EXT)
  CXX := $(cell_tooldir)/ppu/bin/ppu-lv2-g++$(BUILD_EXE_EXT)
  AS := $(cell_tooldir)/ppu/bin/ppu-lv2-as$(BUILD_EXE_EXT)
endif

MKOPTION_LDFILES := 1
MKOPTION_LDFILES_ALL := 1
ifeq ($(OPTION_PS3_USE_SNLD),1)
 # The SN ld currently does not support 'ld -r' linking.
 # The SN linker currently does not support 'ld -r', so we're using the GNU
 # linker for that.
 #LD := $(cell_tooldir)/sn/bin/ps3ppuld
 LD := $(cell_tooldir)/ppu/bin/ppu-lv2-ld$(BUILD_EXE_EXT)
else
 LD := $(cell_tooldir)/ppu/bin/ppu-lv2-ld$(BUILD_EXE_EXT)
endif
OBJCOPY := $(cell_tooldir)/ppu/bin/ppu-lv2-objcopy$(BUILD_EXE_EXT)
STRIP := $(cell_tooldir)/ppu/bin/ppu-lv2-strip$(BUILD_EXE_EXT)
NM := $(cell_tooldir)/ppu/bin/ppu-lv2-nm$(BUILD_EXE_EXT)
AR := $(cell_tooldir)/ppu/bin/ppu-lv2-ar$(BUILD_EXE_EXT)
RANLIB := $(cell_tooldir)/ppu/bin/ppu-lv2-ranlib$(BUILD_EXE_EXT)

# Build tools for PRX support.
STRIP_PRX := $(cell_tooldir)/bin/ppu-lv2-prx-strip$(BUILD_EXE_EXT)

# Build tools (SPU).
CC_SPU := $(cell_tooldir)/spu/bin/spu-lv2-gcc$(BUILD_EXE_EXT)
CXX_SPU := $(cell_tooldir)/spu/bin/spu-lv2-g++$(BUILD_EXE_EXT)
LD_SPU := $(cell_tooldir)/spu/bin/spu-lv2-ld$(BUILD_EXE_EXT)
NM_SPU := $(cell_tooldir)/spu/bin/spu-lv2-nm$(BUILD_EXE_EXT)
SIZE_SPU := $(cell_tooldir)/spu/bin/spu-lv2-size$(BUILD_EXE_EXT)

# Generic CELL SDK build tools for making a self
MAKE_FSELF := $(cell_tooldir)/bin/make_fself$(BUILD_EXE_EXT)

# UNSELF Cell SDK tool
UNSELF := $(cell_tooldir)/bin/unfself$(BUILD_EXE_EXT)

# Other build tools.
ifeq ($(HOST_SYSTEM),Linux)
  PERL := perl -I'$(MAKE_ROOT)/Tools'
else
  PERL_INCLUDES := $(shell $(MAKE_ROOT)/Tools/host-win32/msys/1.0/bin/perl \
	$(MAKE_ROOT)/Tools/msys_perl_includes.pl \
	-I'$(MAKE_ROOT)/Tools' \
	-I'$(MAKE_ROOT)/Tools/host-win32/msys/1.0/lib/perl5/5.6.1')
  PERL := $(MAKE_ROOT)/Tools/host-win32/msys/1.0/bin/perl $(PERL_INCLUDES)
#  PERL := perl -I'$(MAKE_ROOT)/Tools' -I'$(MAKE_ROOT)/Tools/host-win32/msys/1.0/lib/perl5/5.6.1/'
#  PERL := perl -I'$(MAKE_ROOT)/Tools' -I'$(MAKE_ROOT)/Tools/host-win32/cygwin/perl5/5.8/'
endif

# Build tools info (PPU).
gcc_version_tool := \
	$(PERL) $(MAKE_ROOT)/Tools/gcc_version.pl -a ppu-lv2 -m -p GCC_
MKOPTION_PS3_GCC_VERSION := 4.1.1	
#ifdef MKOPTION_PS3_GCC_VERSION
 GCC_VERSION := $(MKOPTION_PS3_GCC_VERSION)
#else
# $(eval $(shell $(gcc_version_tool) -qversion $(CC)))
#endif

MKOPTION_PS3_GCC_LIBDIR = $(CELL_SDK)/$(HOST_BINDIR)/ppu/lib/gcc/ppu-lv2
#ifdef MKOPTION_PS3_GCC_LIBDIR
 GCC_LIBDIR := $(MKOPTION_PS3_GCC_LIBDIR)
#else
# $(eval $(shell $(gcc_version_tool) -qlibdir $(CC)))
#endif

MKOPTION_PS3_GCC_LIBEXECDIR = $(CELL_SDK)/$(HOST_BINDIR)/ppu/libexec/gcc/ppu-lv2
#ifdef MKOPTION_PS3_GCC_LIBEXECDIR
 GCC_LIBEXECDIR := $(MKOPTION_PS3_GCC_LIBEXECDIR)
#else
# $(eval $(shell $(gcc_version_tool) -qlibexecdir $(CC)))
#endif

# Warning flags.
ifneq ($(MKOPTION_SNC),1)
  warn_cflags := -Wformat -Wmissing-braces -Wno-return-type \
	  -Wno-multichar -Wsequence-point
  warn_cxxflags := -Wno-invalid-offsetof 	  
else
  warn_cflags := 
	#disable warnings:
	#  has virtual functions but non-virtual destructor
	#  Potential uninitialized reference to
	#  statement is unreachable
	#  pointless comparison of unsigned integer with zero
	#  multicharacter character literal
	#  extra text after expected end of preprocessing directive
	#  will not be called for implicit or explicit conversions
	#  nested comment is not allowed
	#  overloaded virtual function is only partially overridden in class
	#  controlling expression is constant
	#  function is hidden by virtual function override intended, should be fixed
	#  support for trigraphs is disabled
	#  attribute visibility ignored
	#  white space between backslash and newline in line splice ignored
	#  asm names for functions are not supported
	#  invalid format string conversion
	#  integer conversion resulted in a change of sign
	#  signed bit field of length 1
	#  NULL reference is not allowed
	warn_cxxflags := -Xmultibytechars=1\
	  --diag_suppress=1700\
	  --diag_suppress=1669\
	  --diag_suppress=112\
	  --diag_suppress=187\
	  --diag_suppress=1437\
	  --diag_suppress=14\
	  --diag_suppress=556\
	  --diag_suppress=9\
	  --diag_suppress=613\
	  --diag_suppress=237\
	  --diag_suppress=1011\
	  --diag_suppress=1421\
	  --diag_suppress=1111\
	  --diag_suppress=1411\
	  --diag_suppress=1698\
	  --diag_suppress=227\
	  --diag_suppress=68\
	  --diag_suppress=109\
	  --diag_suppress=285
 ifeq ($(OPTION_DEBUG),1)
	#disable more warnings for debug:
	#  variable was declared but never referenced
	#  variable was set but never used
	#  subscript out of range (due to templates)
	#  argument of type is incompatible with parameter of type
	#  loop is not reachable from preceding code
	warn_cxxflags += --diag_suppress=178\
		--diag_suppress=552\
		--diag_suppress=176\
		--diag_suppress=1628\
		--diag_suppress=129
 endif
endif
#-Wstrict-aliasing

# Architecture specific command flags.
ARCH_CFLAGS_COMMON = $(warn_cflags)
ifeq ($(MKOPTION_SNC),1)
  ARCH_CFLAGS = -Xoveralign=1 -Xc=gnuext
else
  ARCH_CFLAGS_COMMON +=  -fsigned-char
  ARCH_CFLAGS = -maltivec -mno-gen-microcode
endif
ARCH_CFLAGS_SPU_COMMON = \
	-ffixed-70 -ffixed-71 -ffixed-72 \
	-ffixed-73 -ffixed-74 -ffixed-75 \
	-ffixed-76 -ffixed-77 -ffixed-78 \
	-mdouble=fast -fsingle-precision-constant -mhint-max-nops=4

#	-falign-functions=64

#_DEBUG must be set since it must build against the addresses of the debug driver
ifeq ($(OPTION_PS3_SPU_ASSERT),1)
	ARCH_CFLAGS_SPU_COMMON += -ffixed-67 -D_DEBUG
endif

ifeq ($(OPTION_PS3_SPU_MEM_CHECK),1)
	ARCH_CFLAGS_SPU_COMMON += -DSPU_LS_MEM_CHECK
endif

ifeq ($(MKOPTION_NOILINE),1)
	ARCH_CFLAGS_COMMON += -DNO_ILINE
endif

ifneq ($(OPTION_NODEBUGSYM),1)
 ARCH_CFLAGS += -g
endif

ifeq ($(OPTION_PS3_MTRACE),1)
 ARCH_CFLAGS_COMMON += -fno-inline
endif

ifeq ($(OPTION_WARN_LHS_MICRO),1)
 ARCH_CFLAGS += -mwarn-microcode -mwarn-lhs
endif

ifneq ($(OPTION_PS3_USE_SNLD),1)
# -mminimal-toc required for linking the the GNU linker.
ARCH_CFLAGS += -mminimal-toc
else
#increases code size, use only where required
#ARCH_CFLAGS += -mbase-toc -mall-base-toc
endif

ARCH_CFLAGS_SPUJOB = $(ARCH_CFLAGS_SPU_COMMON) -fPIC 
ARCH_CFLAGS_SCAN = 

ifeq ($(OPTION_PROFILE),1)
 ifeq ($(OPTION_PS3_SPU_PROFILE),1)
  ARCH_CFLAGS_SPU_COMMON += -DDO_SPU_PROFILING
  ARCH_CFLAGS += -DDO_SPU_PROFILING
  ARCH_CFLAGS_SCAN += -DDO_SPU_PROFILING
 endif
endif


ifeq ($(OPTION_PS3_PROFILE_LOCKS),1)
 ARCH_CFLAGS += -DPS3_PROFILE_LOCKS
endif

ifeq ($(OPTION_INCLUDE_FACEGEN),1)
 ARCH_CFLAGS += -DINCLUDE_FACEGEN
endif

ifeq ($(MKOPTION_RELEASE),1)
 ARCH_CFLAGS += -D_RELEASE
 ARCH_CFLAGS_SPU_COMMON += -D_RELEASE
 ARCH_CFLAGS_SCAN += -D_RELEASE
endif

ifeq ($(MKOPTION_CRYSIZER_HEAP_TRAVERSAL),1)
	ARCH_CFLAGS += -DPS3_CRYSIZER_HEAP_TRAVERSAL
endif

ARCH_CFLAGS_SPU = $(ARCH_CFLAGS_SPU_COMMON)

ifneq ($(MKOPTION_SNC),1)
  ARCH_CXXFLAGS_COMMON = \
	  $(warn_cxxflags) -fpermissive -fms-extensions -fno-rtti -fno-exceptions
else
  ARCH_CXXFLAGS_COMMON = \
	  $(warn_cxxflags) -Xc-=exceptions -Xc-=rtti
endif	  

ARCH_CXXFLAGS = 
ARCH_CXXFLAGS_SPU =
ARCH_CXXFLAGS_SPUJOB = 
ARCH_CXXFLAGS_SCAN =

ARCH_CPPFLAGS_COMMON = \
	-DPS3 -DNO_VECIDX -DENABLE_TYPE_INFO
ifeq ($(OPTION_PS3_OPTIMIZED_CODE),1)
 ARCH_CPPFLAGS_COMMON += -DPS3OPT
 ARCH_CFLAGS_SPU_COMMON += -DPS3OPT
endif
ARCH_CPPFLAGS =
ARCH_CPPFLAGS_SPU = -D__SPU__

ifeq ($(MKOPTION_SNC),1)
  ARCH_CPPFLAGS_COMMON += -I$(CELL_SDK)/host-win32/sn/ppu/include
else  
  ARCH_CPPFLAGS_COMMON += -I$(CELL_SDK)/$(HOST_BINDIR)/ppu/lib/gcc/ppu-lv2/4.1.1/include
endif

ARCH_CPPFLAGS_SPUJOB = \
	-D_SPU_JOB -include SPU/SPUJob.h -mraw

ifneq ($(OPTION_PS3_SPU_NO_BRANCH_HINT),1)	
 ARCH_CPPFLAGS_SPUJOB += -DSUPP_BRANCH_HINTS
 ARCH_CPPFLAGS_SCAN += -DSUPP_BRANCH_HINTS
 ARCH_CFLAGS_SCAN += -DSUPP_BRANCH_HINTS
else	
 ARCH_CPPFLAGS_SPUJOB += -msafe-hints
 ARCH_CPPFLAGS_SCAN += -msafe-hints
 ARCH_CFLAGS_SCAN += -msafe-hints
endif

ARCH_CPPFLAGS_SCAN = -D__SPU__ -D__CRYCG__
ifneq ($(OPTION_PS3_SPU_ASSERT),1)
 ARCH_CPPFLAGS_SPUJOB += -D_NO_SPU_ASSERT -D_NO_SPU_CACHE_ASSERT
 ARCH_CPPFLAGS_SCAN		+= -D_NO_SPU_ASSERT -D_NO_SPU_CACHE_ASSERT
endif
ifeq ($(OPTION_PS3_OPTIMIZED_CODE),1)
 ARCH_CPPFLAGS_SCAN += -DPS3OPT
endif
ifneq ($(OPTION_PS3_SPUCACHE_HAZARD_CHECK),1)
 ARCH_CPPFLAGS_SPUJOB += -D_NO_SPU_CACHE_HAZ_CHECK
endif

ARCH_LDFLAGS = \
	-L$(CELL_SDK)/$(HOST_BINDIR)/ppu/lib/gcc/ppu-lv2/4.1.1/fno-exceptions/fno-rtti \
	-L$(CELL_SDK)/target/ppu/lib/fno-exceptions/fno-rtti 

ifeq ($(OPTION_PS3_MEMREPLAY),1)
ARCH_LDFLAGS += \
	-Wl,--wrap=malloc \
	-Wl,--wrap=free \
	-Wl,--wrap=realloc \
	-Wl,--wrap=reallocalign \
	-Wl,--wrap=memalign \
	-Wl,--wrap=calloc
ARCH_CPPFLAGS += -DENABLE_MEMREPLAY
endif

ARCH_LDRFLAGS =
ARCH_LDLIBS =

ifeq ($(OPTION_PS3_USE_SNLD),0)
 ARCH_LDFLAGS += -mno-sn-ld
endif

ARCH_XFLAGS_COMMON =
ARCH_XFLAGS =
ARCH_XFLAGS_SPU_COMMON =

ARCH_XFLAGS_SPU_COMMON += -save-temps

ifneq ($(OPTION_DEBUG),1)
 ifneq ($(OPTION_SUPP_FP_EXCEPTION),1)
   ifneq ($(MKOPTION_SNC),1)
     PS3_MATHOPT := -ffast-math
   else
     PS3_MATHOPT := -Xfastmath=1
   endif
 else
  ifneq ($(MKOPTION_SNC),1)
    PS3_MATHOPT := -ftrapping-math
  endif
    PS3_MATHOPT += -DSUPP_FP_EXC
 endif
else
 PS3_MATHOPT :=  
endif 

ARCH_XFLAGS_SPU = $(ARCH_XFLAGS_SPU_COMMON)
ARCH_XFLAGS_SPUJOB = $(ARCH_XFLAGS_SPU_COMMON)
ARCH_XFLAGS_SCAN =
ifneq ($(OPTION_DEBUG),1)
 ifneq ($(MKOPTION_SNC),1)
   ARCH_XFLAGS = -Os -fstrict-aliasing -fschedule-insns2 -fschedule-insns
 else
   ARCH_XFLAGS = -Os -Xrelaxalias=2
 endif
 ARCH_CPPFLAGS_COMMON += -DNDEBUG
endif
ARCH_XFLAGS += $(PS3_MATHOPT)
ifeq ($(OPTION_DEBUG),1)
 #OPTION_PS3_NOMEMMAN := 1
endif

ifeq ($(OPTION_PS3_USE_SNLD),1)
	ifeq ($(MKOPTION_STRIP_DEAD_CODE),1)
		ARCH_LDFLAGS += -Wl,-strip-duplicates -Wl,-strip-unused-data
		ARCH_LDFLAGS += -Wl,-strip-duplicates -Wl,-strip-unused
		ARCH_LDFLAGS += -Wl,--keep=$(MAKE_ROOT)/Tools/keep_symbol_list
		ARCH_LDFLAGS += -Wl,--no-keep-eh-data
	#	ARCH_LDFLAGS += -Wl,--strip-report=e:/stripreport.txt		
	endif
endif

ARCH_XFLAGS_SPU += \
-fgcse-after-reload -fgcse-las -fgcse-sm -fgcse-lm -fsched2-use-superblocks\
-ftracer -fsplit-ivs-in-unroller -fvariable-expansion-in-unroller

# STL port.
ifeq ($(OPTION_PS3_USE_STLPORT),1)
 ifdef DEPOT_MAIN
  STLPORT_DIR := $(DEPOT_MAIN)/Code/SDKs/STLPORT/stlport
 else
  STLPORT_DIR := $(CODE_ROOT)/SDKs/STLPORT/stlport
 endif
 ARCH_CPPFLAGS_COMMON := \
	-DUSING_STLPORT -D_HAS_C9X \
	$(ARCH_CPPFLAGS_COMMON)
 _need_stlport_include := 0
 ifneq ($(MKOPTION_CRYCG_CM),1)
  # CM uses our STLPORT by default, having it in the include path twice causes
  # problems with STLPORT's #include_next hacks.
  _need_stlport_include := 1
 endif
 ifneq ($(STAGE),scan)
  _need_stlport_include := 1
 endif
 ifneq ($(STAGE),MakeTools)
  _need_stlport_include := 1
 endif
 ifeq ($(_need_stlport_include),1)
  ARCH_CPPFLAGS_COMMON += -I$(STLPORT_DIR)
 endif

endif

#scan should optimize regardless of actuall backend optimization flags
ARCH_XFLAGS_SCAN += -O3 -fno-inline
ifneq ($(OPTION_PS3_SPU_NOOPTIMIZE),1)
 ARCH_CPPFLAGS_COMMON += -DPS3_SPUOPT
 ARCH_XFLAGS_SPU_COMMON += \
	-O2 -ffast-math -finline-functions-called-once \
	-fgcse-after-reload -fstrict-aliasing -fomit-frame-pointer \
	-DPS3_SPUOPT
 ifeq ($(OPTION_DEBUG),1)
  ARCH_CPPFLAGS_SPU += -DNDEBUG
  ARCH_CPPFLAGS_SPUJOB += -DNDEBUG
  ARCH_CPPFLAGS_SCAN += -DNDEBUG
 endif
ifeq ($(OPTION_PS3_SPU_ASSERT),1) 
 ARCH_XFLAGS_SPU_COMMON += -Os
endif
ifeq ($(OPTION_PS3_SPU_PROFILE),1) 
 ARCH_XFLAGS_SPU_COMMON += -Os
endif
else
 ARCH_XFLAGS_SPU_COMMON += \
  -O0 -finline-functions -fdefault-inline -fif-conversion -fif-conversion2\
  -funit-at-a-time -fmerge-constants
endif

# Memory manager.
ifeq ($(OPTION_PS3_NOMEMMAN),1)
 ARCH_CPPFLAGS_COMMON += -DNOT_USE_CRY_MEMORY_MANAGER
endif
ifneq ($(MKOPTION_SNC),1)
 ARCH_CXXFLAGS += -fglobal-new-align=8
else
 ARCH_CXXFLAGS += -Xnewalign=8
endif

# CryCG_CM support
ifeq ($(MKOPTION_CRYCG_CM),1)
  ARCH_CPPFLAGS_COMMON += -DCRYCG_CM_USED=1
endif

#ARCH_CPPFLAGS += -fpropagate-restrict

# PS3 job manager.
ifdef DEPOT_MAIN
 ps3_jobman_dir := $(DEPOT_MAIN)/Code/Tools/PS3JobManager
else
 ps3_jobman_dir := $(CODE_ROOT)/Tools/PS3JobManager
endif
ARCH_CPPFLAGS_COMMON += -I$(ps3_jobman_dir)


ifeq ($(OPTION_PS3_SPU_SNDEBUG),1)
 ARCH_CFLAGS_SPU_COMMON += -g -DSUPP_SN -I$(ps3_jobman_dir)/lib
 ARCH_CPPFLAGS_COMMON += -DSUPP_SN
else 
 ARCH_CFLAGS_SPU_COMMON += -I$(ps3_jobman_dir)/lib 
endif

ifeq ($(OPTION_ASSERT),1)
	ARCH_CPPFLAGS_COMMON += -DSUPP_ASSERT
endif

ifeq ($(OPTION_DEBUG),1)
#	ARCH_CPPFLAGS_COMMON += -DENABLE_FP
endif

ARCH_CPPFLAGS_COMMON += -DSPU_REP_SIZE=$(OPTION_SPU_REP_SIZE_KB)
ARCH_CPPFLAGS_COMMON += -DMAIN_THREAD_STACK_SIZE=$(OPTION_MAIN_THREAD_STACK_SIZE_KB)
ARCH_CPPFLAGS_COMMON += -DMAIN_STACK_SIZE=$(OPTION_MAIN_STACK_SIZE_KB)


ifeq ($(MKOPTION_INCREDIBUILD),1)
 INCREDI_PREFIX := $(PERL) '$(MAKE_ROOT)/Tools/incredibuild.pl' '$(INCREDIBAT_SPU)' 'compile'
 INCREDI_PREFIX_SIZE := $(PERL) '$(MAKE_ROOT)/Tools/incredibuild.pl' '$(INCREDIBAT_SPU)' 'size'
 _INCREDI_PREFIX_SIZE := 'size'
 _INCREDI_PREFIX_COMPILE := 'compile'
else
 INCREDI_PREFIX := 
 INCREDI_PREFIX_SIZE := 
endif

# SN Systems build tools.

ifdef DEPOT_MAIN
 SPUMODGEN := $(DEPOT_MAIN)/Code/Tools/PS3JobManager/lib/$(HOST_BINDIR)/spumodgen
else
 SPUMODGEN := $(CODE_ROOT)/Tools/PS3JobManager/lib/$(HOST_BINDIR)/spumodgen
endif

# SNTuner support.
ARCH_LDFLAGS_program += -L$(ps3_jobman_dir)/lib
ps3_link_prof_stub := 0
ifeq ($(OPTION_GPROF),1)
 ps3_link_prof_stub := 1
endif
ifeq ($(OPTION_PROFILE),1)
 ps3_link_prof_stub := 1
endif
ifeq ($(OPTION_DEBUG),1)
 ps3_link_prof_stub := 1
endif
ifeq ($(ps3_link_prof_stub),1)
 # Removed lprof_stub since it doesnt work on debugging stations
 # ARCH_LDLIBS_program += -Wl,--whole-archive -lprof_stub -Wl,--no-whole-archive
	ARCH_LDLIBS_program += -Wl,--whole-archive -Wl,--no-whole-archive
endif
ps3_jobman_lib := cryjobmanspu
ifeq ($(OPTION_PS3_SPU_PROFILE),1)
  ps3_jobman_lib := cryjobmanspu_profile
endif	
ifeq ($(OPTION_DEBUG),1)
  ps3_jobman_lib := cryjobmanspu_debug
endif
ifeq ($(OPTION_PS3_SPU_ASSERT),1)
  ps3_jobman_lib := cryjobmanspu_debug
endif
ARCH_LDLIBS_program += -l$(ps3_jobman_lib)
ARCH_LIBDEPS_program += $(ps3_jobman_dir)/lib/lib$(ps3_jobman_lib).a
ifeq ($(OPTION_PS3_SNTUNER),1)
 ARCH_CPPFLAGS += -DSNTUNER
 ARCH_LDLIBS_program += -lsntuner
endif
ARCH_LDLIBS_program += -lsn

ifeq ($(OPTION_PS3_DEBUG_FILEHANDLER),1)
 ARCH_CPPFLAGS += -DDEBUG_FILEHANDLER
endif


# GCM HUD support.
ifeq ($(OPTION_PS3_GCMHUD),1)
 ARCH_CPPFLAGS_COMMON += -DCRY_USE_GCM_HUD
endif

ifeq ($(OPTION_PS3_GCMREPLAY),1)
 ARCH_CPPFLAGS_COMMON += -DCRY_USE_GCM_REPLAY
endif

ifeq ($(OPTION_PS3_GCMDEBUG),1)
 ARCH_CPPFLAGS_COMMON += -DCELL_GCM_DEBUG
endif

# GCM command buffer checking.
gcmdebug_cmdbuffercheck :=
ifndef OPTION_PS3_GCMDEBUG_CMDBUFFERCHECK
 OPTION_PS3_GCMDEBUG_CMDBUFFERCHECK := 0
 gcmdebug_cmdbuffercheck := 0
else
 ifeq ($(OPTION_PS3_GCMDEBUG_CMDBUFFERCHECK),1)
  # Basic checking.
  gcmdebug_cmdbuffercheck := 1
 else
  ifeq ($(OPTION_PS3_GCMDEBUG_CMDBUFFERCHECK),2)
   gcmdebug_cmdbuffercheck := 2
  endif
 endif
endif
ifeq ($(gcmdebug_cmdbuffercheck),)
 $(warning Invalid value for OPTION_PS3_GCMDEBUG_CMDBUFFERCHECK)
 gcmdebug_cmdbuffercheck := 0
endif

ifneq ($(gcmdebug_cmdbuffercheck),0)
 ARCH_CPPFLAGS_COMMON += -DGCM_DEBUG_CMDBUFFER
 ifeq ($(gcmdebug_cmdbuffercheck),2)
  ARCH_CPPFLAGS_COMMON += -DGCM_DEBUG_CMDBUFFER_FULL
 endif
endif


# For PS3 the generated program file has the extension .elf (following the
# Cell SDK convention).
PROGRAM_NAME = $(addsuffix .elf,$(1))

# Arch/PS3-cell.mk
# vim:ts=8:sw=2

