#############################################################################
## Crytek Source File
## Copyright (C) 2006, Crytek Studios
##
## Creator: Sascha Demetrio
## Date: Wed Jun 27, 2007
## Description: GNU-make based build system
#############################################################################

# PRX support.
ifeq ($(OPTION_PS3_PRX),1)
 ifeq ($(PROJECT_PS3_PRX),1)
  ifneq ($(OPTION_PS3_PRX_$(TARGET)),1)
   $(error PRX config mismatch for target $(TARGET))
  endif
 else # PROJECT_PS3_PRX
  ifeq ($(OPTION_PS3_PRX_$(TARGET)),1)
   $(error PRX config mismatch for target $(TARGET))
  endif
 endif # PROJECT_PS3_PRX
else # else OPTION_PS3_PRX
 ARCH_CPPFLAGS += -DPS3_NOPRX
endif # else OPTION_PS3_PRX

ifeq ($(OPTION_PS3_PRX_$(TARGET)),1)
 ARCH_CPPFLAGS += -DPS3_PRX
 OPTION_MODULE_LINKMODE := shared
 ifeq ($(PROJECT_TYPE),module)
  PROJECT_SOURCES_CPP_ADD += $(TARGET)_PRX.cpp
 endif # PROJECT_TYPE == module
else
 ARCH_CPPFLAGS += -D_LIB
 OPTION_MODULE_LINKMODE := static
endif

ifeq ($(OPTION_PS3_MTRACE),1)
 ARCH_CPPFLAGS += -DSUPP_MTRACE
endif

export OPTION_MODULE_LINKMODE

ifeq ($(PROJECT_TYPE),module)
 PROJECT_STUB_SOURCES_CPP += $(TARGET)_PRX.cpp
endif

output_suffix :=
ifeq ($(origin OPTION_PS3_OUTPUT_SUFFIX),undefined)
 ifeq ($(OPTION_DEBUG),1)
  output_suffix := $(output_suffix)_debug
	ARCH_CPPFLAGS += -DPS3_OUTPUT_SUFFIX=$(output_suffix)
 endif
 ifeq ($(OPTION_GPROF),1)
  output_suffix := $(output_suffix)_gprof
	ARCH_CPPFLAGS += -DPS3_OUTPUT_SUFFIX=$(output_suffix)
 endif
else
 output_suffix := $(OPTION_PS3_OUTPUT_SUFFIX)
endif
ifeq ($(strip $(OPTION_PS3_OUTPUT_DIR)),)
 output_dir := $(CODE_ROOT)/../BinPS3
else
 output_dir := $(OPTION_PS3_OUTPUT_DIR)
endif

ifeq ($(OPTION_DEVIRTUALIZE),1)

 # When using the Eval-SDK, the devirtualized header are stored in the
 # SDK folder, not in the build folder
 ifeq ($(BUILD_WITH_PS3_SDK),1)
	DEVIRTULIZED_HEADER_DIR := \
	$(foreach dir,$(UNIQUE_IFACE_DIR), -iquote$(PS3_SDK_ROOT)/$(dir) )\
	$(foreach dir,$(UNIQUE_IFACE_DIR), -I$(PS3_SDK_ROOT)/$(dir) ) \
	-I$(CODE_ROOT)
 else
	DEVIRTULIZED_HEADER_DIR :=\
	$(foreach dir,$(UNIQUE_IFACE_DIR), -iquote$(EFFECTIVE_BUILD_ROOT)/$(dir) )\
	$(foreach dir,$(UNIQUE_IFACE_DIR), -I$(EFFECTIVE_BUILD_ROOT)/$(dir) )\
	-I$(CODE_ROOT)
 endif

 CPPFLAGS_DEVIRTUALIZE = \
	-D_DEVIRTUALIZE_ \
        $(DEVIRTULIZED_HEADER_DIR)        
 ARCH_LDFLAGS_program += \
	-Wl@$(DEVIRTULIZED_HEADER_DIR)/devirt.ld
else
 CPPFLAGS_DEVIRTUALIZE :=
endif

# When building on Windows we'll need to fix the generated dependency files
# for Cygwin.  We'll do that by extending the COMPILE_* functions.
ifeq ($(HOST_SYSTEM),Cygwin)
  ifeq ($(MAKE_SYSTEM),Cygwin)
    option_fixdeps := 1
  endif
endif 
ifeq ($(HOST_SYSTEM),MingW)
  ifeq ($(MAKE_SYSTEM),MinGW)
    option_fixdeps := 1
  endif
endif
ifndef option_fixdeps
  option_fixdeps := 0
endif 


ifeq ($(option_fixdeps),1)
 EXT_D_TMP := d_
endif

_COMPILER_FOUND=0
ifeq ($(MKOPTION_SNC),1)
  include $(MAKE_ROOT)/Arch/SNC.mk
	_COMPILER_FOUND=1
endif 
ifeq ($(MKOPTION_USE_CM),1)
  include $(MAKE_ROOT)/Arch/CM.mk
	_COMPILER_FOUND=1
endif 
ifeq ($(_COMPILER_FOUND),0)
  include $(MAKE_ROOT)/Arch/GCC.mk
endif  

ifeq ($(MKOPTION_CRYCG_CM),1)
 include $(MAKE_ROOT)/Arch/CryCG_CM.mk
else 
 include $(MAKE_ROOT)/Arch/CryCG.mk
endif 

include $(MAKE_ROOT)/Arch/PageDist.mk
include $(MAKE_ROOT)/Arch/PRX.mk

ifeq ($(OPTION_PS3_PRX_$(TARGET)),1)
 ifneq ($(COMPILER_IS_GCC),1)
  $(error PRX supported only with GCC)
 endif
endif

ifneq ($(MKOPTION_SNC),1)
  ARCH_CPPFLAGS += -Wno-endif-labels
endif

# Support for SPU compiling.  The SPU compiler relevant variables and
# functions are tagged with an _SPU suffix.
ifeq ($(MKOPTION_DISTRIBUTED),1)
 # For distributed builds, we must rely on the compiler being in the
 # executable search path of the machine running the compiler.
 CPREFIX_CXX_SPU := $(notdir $(CXX_SPU))
 CPREFIX_CC_SPU := $(notdir $(CC_SPU))
else
 CPREFIX_CXX_SPU := $(CXX_SPU)
 CPREFIX_CC_SPU := $(CC_SPU)
endif
# Note that SPU compilation does not create dependency files.
COMPILE_CXX_SPUJOB = $(INCREDI_PREFIX_SIZE)\
$(CPREFIX_CXX_SPU) \
	$(CFLAGS_SPUJOB) $(CXXFLAGS_SPUJOB) $(CPPFLAGS_SPUJOB) $(4) \
	-c '$(2)' -o '$(3)'
COMPILE_CXX_SPUJOB_NO_PREFIX = \
$(CPREFIX_CXX_SPU) \
	$(CFLAGS_SPUJOB) $(CXXFLAGS_SPUJOB) $(CPPFLAGS_SPUJOB) $(4) \
	-c '$(2)' -o '$(3)'

ifeq ($(option_fixdeps),1)
 # Note: When incredibuild support is active, the actual compilation
 # rules will not have produced the dependency files at the point when
 # fixdeps is executed. Therefore there are extra rules that are
 # executed as post compile step *after* incredibuild has finished. 
 ifneq ($(MKOPTION_INCREDIBUILD),1)
   fixdeps ?= $(PERL) "$(MAKE_ROOT)/Tools/fixdeps.pl" --host-system $(HOST_SYSTEM)

   ifdef CYGWIN_BASEDIR
    fixdeps += -b '$(subst ','\'','$(CYGWIN_BASEDIR)')'
   endif

   # Note: The '&&' is appended to the COMPILE_* functions unquoted.  The
   # 'fixdeps' part of the command is _not_ passed to the $(BUILD) script and
   # will not be echoed, even if 'MKOPTION_VERBOSE' is set.
   COMPILE_CXX += && (touch '$(patsubst %.$(EXT_O),%.$(EXT_D_TMP),$(3))' \
			&& $(fixdeps) \
			<'$(patsubst %.$(EXT_O),%.$(EXT_D_TMP),$(3))' \
    	>'$(patsubst %.$(EXT_O),%.$(EXT_D),$(3))' \
    	&& rm -f '$(patsubst %.$(EXT_O),%.$(EXT_D_TMP),$(3))')
    
   COMPILE_C += && (touch '$(patsubst %.$(EXT_O),%.$(EXT_D_TMP),$(3))'\
    	&& $(fixdeps) \
    	<'$(patsubst %.$(EXT_O),%.$(EXT_D_TMP),$(3))' \
    	>'$(patsubst %.$(EXT_O),%.$(EXT_D),$(3))' \
    	&& rm -f '$(patsubst %.$(EXT_O),%.$(EXT_D_TMP),$(3))')
    
   COMPILE_PCH += && $(fixdeps) \
    	<'$(patsubst %.$(EXT_PCH),%.h.$(EXT_D_TMP),$(3))' \
    	>'$(patsubst %.$(EXT_PCH),%.h.$(EXT_D),$(3))' \
    	&& rm -f '$(patsubst %.$(EXT_PCH),%.h.$(EXT_D_TMP),$(3))'
    
   SCAN_CXX += && $(fixdeps) \
    	<'$(patsubst %.$(EXT_CCG),%.$(EXT_D_TMP),$(3))' \
    	>'$(patsubst %.$(EXT_CCG),%.$(EXT_D),$(3))' \
    	&& rm -f '$(patsubst %.$(EXT_CCG),%.$(EXT_D_TMP),$(3))'
    
   SCAN_C += && $(fixdeps) \
    	<'$(patsubst %.$(EXT_CCG),%.$(EXT_D_TMP),$(3))' \
    	>'$(patsubst %.$(EXT_CCG),%.$(EXT_D),$(3))' \
    	&& rm -f '$(patsubst %.$(EXT_CCG),%.$(EXT_D_TMP),$(3))'
  endif # ifneq ($(MKOPTION_INCREDIBUILD),1)
endif # option_fixdeps == 1

# The name of the (generated) SPU jobs exec makefile.  The file is generated in the
# post-scan step and will contain all relevant information to generate
# the exec files for the spujobs 
SPUJOBS_EXEC_MK = $(PS3_SPU_ROOT)/SPUJobsExec.mk

# The name of the (generated) SPU code pages makefile.  The file is generated in the
# post-scan step and will contain all relevant information to generate
# the code page files for the spujobs. The generation of this makefile
# is carried out AFTER the $(SPUJOBS_EXEC_MK) has been generated. 
SPUJOBS_PAGE_MK = $(PS3_SPU_ROOT)/SPUJobsPages.mk

# The name of the per-target element file name.
ifeq ($(BUILD_WITH_PS3_SDK),1)
	SPU_ELEMENT_FILE = $(PS3_SPU_ROOT)/$(TARGET).elt
else	
	SPU_ELEMENT_FILE = $(EFFECTIVE_BUILD_ROOT)/Lib/$(TARGET).elt
endif

# The name of the PPU symbol file.
SPU_PPUSYM_FILE = $(PS3_SPU_ROOT)/$(TARGET).sym
SPU_PPUSYMLIST_FILE = $(PS3_SPU_ROOT)/$(TARGET).symlist
SPU_JOB_ROOT := $(PS3_SPU_ROOT)/$(TARGET)/spujob

PPU_ELF_FILE := $(BUILD_ROOT)/Bin/$(TARGET)

# Setup the post-scan steps. Note that the post-scan hooks are
# executed twice! The first post-scan hook generates a spu job exec
# makefile, which in turn creates 
PROJECT_POSTSCAN = $(SILENT) :
ifeq ($(PROJECT_TYPE),program)
 PROJECT_POSTSCAN += \
	&& mkdir -p '$(dir $(SPUJOBS_EXEC_MK))' \
	&& rm -f '$(SPUJOBS_EXEC_MK)' \
	&& $(_BUILD_SILENT) $(PERL) '$(MAKE_ROOT)/Tools/postscan.pl' \
	  --gen_exec \
	  --element-file='$(SPU_ELEMENT_FILE)' \
	  --makefile='$(SPUJOBS_EXEC_MK)' \
	  --target='$(TARGET)' \
	  --ppu-sym='$$(SPU_PPUSYM_FILE)' \
	  --ppu-sym-list='$$(SPU_PPUSYMLIST_FILE)' \
  	--ppu-sym-file='$(SPU_PPUSYM_FILE)' \
	  --ppu-sym-list-file='$(SPU_PPUSYMLIST_FILE)' \
	  --ppu-elf='$$(PPU_ELF_FILE)' \
	  --prefix='$$(BUILD_ROOT)=$(BUILD_ROOT)' \
	  --prefix='$$(CODE_ROOT)=$(CODE_ROOT)' \
	  --prefix='$$(PROJECT_CODE)=$(PROJECT_CODE)' \
		$(if $(filter 1,$(MKOPTION_CRYCG_CM)),--cm_backend,) \
		--verbose \
	&& $(MAKE) \
	  -f "$(COMMON_MK)" \
	  $(MAKE_FLAGS) \
	  $(COMMON_ARGS) \
	  EXEC_PROJECT_POSTSCAN=scan_genexec \
	  _exec_project_postscan \
	&& mkdir -p '$(dir $(SPUJOBS_PAGE_MK))' \
	&& rm -f '$(SPUJOBS_PAGE_MK)' \
	&& $(_BUILD_SILENT) $(PERL) '$(MAKE_ROOT)/Tools/postscan.pl' \
	  --gen_pages \
	  --element-file='$(SPU_ELEMENT_FILE)' \
	  --makefile='$(SPUJOBS_PAGE_MK)' \
	  --target='$(TARGET)' \
	  --ppu-sym='$$(SPU_PPUSYM_FILE)' \
	  --ppu-sym-list='$$(SPU_PPUSYMLIST_FILE)' \
  	  --ppu-sym-file='$(SPU_PPUSYM_FILE)' \
	  --ppu-sym-list-file='$(SPU_PPUSYMLIST_FILE)' \
	  --ppu-elf='$$(PPU_ELF_FILE)' \
	  --prefix='$$(BUILD_ROOT)=$(BUILD_ROOT)' \
	  --prefix='$$(CODE_ROOT)=$(CODE_ROOT)' \
	  --prefix='$$(PROJECT_CODE)=$(PROJECT_CODE)' \
		$(if $(filter 1,$(MKOPTION_CRYCG_CM)),--cm_backend,) \
	  --verbose \
	&& $(MAKE) \
	  -f "$(COMMON_MK)" \
	  $(MAKE_FLAGS) \
	  $(COMMON_ARGS) \
	  EXEC_PROJECT_POSTSCAN=scan_genpage \
	  _exec_project_postscan 

 LINK_CLEAN_$(TARGET) += $(SPUJOBS_EXEC_MK) $(SPUJOBS_PAGES_MK) 
endif # PROJECT_TYPE == program

# For all support stages, the variable $(EXEC_PROJECT_POST) indicate that a
# post stage step is executing.
ifdef EXEC_PROJECT_POSTSCAN
 EXEC_PROJECT_POST := scan
endif
ifdef EXEC_PROJECT_POSTCOMPILE
 EXEC_PROJECT_POST := compile
endif
ifdef EXEC_PROJECT_POSTLINK
 EXEC_PROJECT_POST := link
endif

SPUJOB_REPOSITORY := $(BUILD_ROOT)/Lib/SPURepository.bin

# The post scan is driven by make ($(MAKE) invocation in $(PROJECT_POSTSCAN)).
# The make action is implemented by the _project_postscan target.
#
# At the time the post-scan make invocation is performed, the
# 'SPUJobExec.mk' and the # 'SPUJobPage.mk' makefiles exist.  For all
# # other post-$(STAGE) make invocations, we'll do a -include, so the
# # 'compile' and 'link' stages still work even if the build does not
# # require a 'scan' stage.
ifdef EXEC_PROJECT_POST

 # $(ps3_jobman_dir) is defined 'PS3-cell.mk'.
 spujob_deps := $(ps3_jobman_dir)/SPU/SPUJob.h
 SPUJOB_JOB_DEPS := $(spujob_deps)
 SPUJOB_PAGE_DEPS := $(spujob_deps)

 ifdef EXEC_PROJECT_POSTSCAN
    ifeq ($(EXEC_PROJECT_POSTSCAN),scan_genexec)
	  # Generated by '$(MAKE_ROOT)/Tools/postscan.pl'.
      include $(SPUJOBS_EXEC_MK)
    endif 
    ifeq ($(EXEC_PROJECT_POSTSCAN),scan_genpage)
	  # Generated by '$(MAKE_ROOT)/Tools/postscan.pl' during the
	  # first submake invokation (scan_genexec)
      include $(SPUJOBS_EXEC_MK)
	  # Generated by '$(MAKE_ROOT)/Tools/postscan.pl'. during the 
	  # second submake invokation (scan_genpage)
      include $(SPUJOBS_PAGE_MK)
    endif 
 else
  -include $(SPUJOBS_EXEC_MK)
  -include $(SPUJOBS_PAGE_MK)
 endif

 genspujob = $(PERL) '$(MAKE_ROOT)/Tools/genspujob.pl' \
	--index-file '$(BUILD_ROOT)/Lib/$(TARGET).ccgindex' \
	--host-system '$(HOST_SYSTEM)' --make-system '$(MAKE_SYSTEM)'
 ifeq ($(MKOPTION_USE_PREGEN_SPUFILES),1)
  genspujob += --crycg-wrapper='$(MAKE_ROOT)/Tools/crycg_wrapper.pl'
 endif 
 ifeq ($(MKOPTION_CRYCG_CM),1)
  genspujob += --code-mirror 
 endif 
 ifneq ($(PERL),)
	genspujob += --perl='$(subst ','\'',$(PERL))'
 endif 
 ifeq ($(MKOPTION_INCREDIBUILD),1)
  genspujob += --incredibat=$(INCREDIBAT_SPU)
 endif
 ifeq ($(MKOPTION_CRYCGPROFILE),1)
  genspujob += --profile
 endif
 genspujob += -CEnableExternalCallMask
 ifeq ($(MKOPTION_VERBOSE),1)
  genspujob += -v
 endif
 ifeq ($(HOST_SYSTEM),Cygwin)
  ifdef CYGWIN_BASEDIR
   genspujob += -b '$(subst ','\'','$(CYGWIN_BASEDIR)')'
  endif
 endif
 ifneq ($(CRYCG_VALGRIND),)
  genspujob += --exec-prefix '$(CRYCG_VALGRIND_PREFIX)'
 endif 
 ifeq ($(OPTION_DEVIRTUALIZE),1)
   genspujob += --virtualmap \
	'$(DEVIRT_CACHE_DIR)/$(DEVIRT_VIRTUAL_MAPFILE)'
 endif 
 genspujob += -DTARGET=$(TARGET)
 genspujob += -DBUILD_ROOT=$(BUILD_ROOT)

 ifeq ($(OPTION_PS3_SPU_ASSERT),1)
  spujob_driver_suffix := _debug
 else
  ifeq ($(OPTION_DEBUG),1)
   spujob_driver_suffix := _debug
  else
   ifeq ($(OPTION_PS3_SPU_PROFILE),1)
    spujob_driver_suffix := _profile
   else
    spujob_driver_suffix :=    
   endif
  endif
 endif
 spujob_driver_lib := -lDriverSPU$(spujob_driver_suffix)

 spujob_link_ldflags = -nostartfiles -L $(ps3_jobman_dir)/lib
 spujob_link_ldlibs =
# ifeq ($(OPTION_PS3_SPU_SNDEBUG),1)
  spujob_link_ldflags += -T $(ps3_jobman_dir)/lib/spu_module.ld -Wl,-q
 # Currently we need to apply a workarround script which comntains both sections for 
 #  raw spu debugging and tuning.
# spujob_link_ldflags += -T $(ps3_jobman_dir)/lib/spu_module_sec2.ld -Wl,-q  
# endif
 
 spujob_link_ldflags += \
  -L$(CELL_SDK)/target/spu/lib/pic \
	$(CELL_SDK)/target/spu/lib/pic/libc.a \
	$(CELL_SDK)/target/spu/lib/pic/libstdc++.a \
  -L$(CELL_SDK)/target/spu/lib/ \
	$(spujob_driver_lib)

 spujob_linkpage_ldflags = $(spujob_link_ldflags) 
 spujob_linkpage_ldlibs = $(spujob_link_ldlibs)
 spujob_linkexec_ldflags = $(spujob_link_ldflags)
 spujob_linkexec_ldlibs = $(spujob_link_ldlibs)

 ifneq ($(OPTION_PS3_SPUJOB_ADDITIONAL_LIBS),)
  spujob_linkexec_ldlibs += $(addprefix -l,$(OPTION_PS3_SPUJOB_ADDITIONAL_LIBS))
  spujob_linkpage_ldlibs += $(addprefix -l,$(OPTION_PS3_SPUJOB_ADDITIONAL_LIBS))
 endif 

 SPUJOB_EXECUTE_SYMBOL := Execute

 SPUJOB_MANGLE_STUBS = $(PERL) '$(MAKE_ROOT)/Tools/stubmangler.pl' \
	-i $(1) -o $(2) -n $(3)

 SPUJOB_PAGETABLE = $(genspujob) \
	-o $(1) -E '$(2)' -j $(3) -t \
	-p $(5) \
	$(patsubst %,-E '%',$(4))

 SPUJOB_GENEXEC = $(genspujob) \
	-o $(1) -E '$(2)' -j $(3) -x \
	-d $(patsubst %.cpp,%.d,$(1)) \
	-H '$(patsubst %.cpp,%.h,$(1))' \
	$(patsubst %,-E '%',$(4)) \
	$(patsubst %,-C '%',$(5)) \
	$(if $(6),--incredi-prefix=$(6),)

 SPUJOB_GENPAGE = $(genspujob) \
	-o $(1) -E '$(2)' -j $(3) \
	-d $(5) \
	-H '$(patsubst %.cpp,%.h,$(1))' \
	-p $(6) \
	$(patsubst %,-C '%',$(7)) \
	$(patsubst %,-E '%',$(4)) \
	$(if $(8),-s,) \
	$(if $(9),--incredi-prefix=$(9),)

 SPUJOB_GENPAGEHDR = \
	$(BUILD_SILENT) $(PERL) $(MAKE_ROOT)/Tools/genpagehdr.pl \
	  -o '$(1)' \
	  --element-file='$(SPU_ELEMENT_FILE)' \
	  --job='$(2)' \
	  --ppu-sym='$(SPU_PPUSYM_FILE)'

 SPUJOB_GENEXECHDR = \
	$(BUILD_SILENT) $(PERL) $(MAKE_ROOT)/Tools/genexechdr.pl \
	  -o '$(1)' \
	  --element-file='$(SPU_ELEMENT_FILE)' \
	  --job='$(2)' \
	  --ppu-sym='$(SPU_PPUSYM_FILE)'

 SPUJOB_LINKPAGE_CMD_FILE = $(MAKE_ROOT)/spu_link_page_cmd

 SPU_PAGEGEN_VERBOSE_OPT = 
ifeq ($(MKOPTION_VERBOSE),1)
  SPU_PAGEGEN_VERBOSE_OPT := -v
 endif

SPUJOB_GENPAGEDESC = \
	$(PERL) $(MAKE_ROOT)/Tools/genpagedesc.pl \
	  --object-file='$(1)' \
	  --desc-file='$(2)' \
	  --target='$(TARGET)' \
	  --element-file='$(SPU_ELEMENT_FILE)' \
	  --job='$(3)' \
	  --ppu-sym='$(SPU_PPUSYM_FILE)' \
	  --pagegen-tool='$(subst ','\'',$(MAKE_TOOLS_BINDIR)/PageGen \
				-m -g $(SPU_PAGEGEN_VERBOSE_OPT)\
				-W$(output_dir) -S$(SPUMODGEN)\
				-C$(SPUJOB_LINKPAGE_CMD_FILE))' \
	  $(if $(4),--incredi-prefix=$(4),) 

ifeq ($(MKOPTION_INCREDIBUILD),1)
  SPUJOB_GENPAGEDESC += --incredibat='$(INCREDIBAT_SPU)'
endif

 SPUJOB_PATCHEXEC = \
	$(BUILD_LINK) $(MAKE_TOOLS_BINDIR)/PageGen -W$(output_dir) -S$(SPUMODGEN) \
		-f'$(1)' -s -g -m -j $(SPU_PAGEGEN_VERBOSE_OPT) \
		-A$(ps3_jobman_dir)/lib/SPUDriverAddr$(spujob_driver_suffix).txt \
		-c$(SPUJOB_PAGE_COUNT)

 SPUJOB_GENPPUSYM = \
	$(BUILD_LINK) '$(MAKE_TOOLS_BINDIR)/GetSym' \
	  '$(BUILD_ROOT)/Bin/$(TARGET)' '$(1)' '$(2)'

 SPUJOB_LINKPAGE = \
		$(CXX_SPU) \
	  $(CXXFLAGS_SPUJOB) \
	  $(XFLAGS_SPUJOB) \
	  -Wl,-entry=0x20 \
	  $(spujob_linkpage_ldflags) \
	  $(spujob_linkpage_ldlibs)

 SPUJOB_LINKEXEC = \
	$(BUILD_LINK) $(CXX_SPU) \
	  $(CXXFLAGS_SPUJOB) \
	  $(CFLAGS_SPUJOB) \
	  -Wl,-entry=$(SPUJOB_EXECUTE_SYMBOL) \
	  -Wl,--unresolved-symbols=ignore-in-object-files \
	  -Wl,--warn-unresolved-symbols \
	  -Wl,--start-group $(1) -Wl,--end-group \
	  $(RESPONSE_FILE_PREFIX)$(3) \
	  -o $(2) \
	  $(spujob_linkexec_ldflags) \
	  $(spujob_linkexec_ldlibs) \
	  $(4)

 SPUJOB_GENFNRESOLVE = \
	$(BUILD_SILENT) $(PERL) '$(MAKE_ROOT)/Tools/genfntable.pl' \
	  --target=$(TARGET) \
	  --element-file='$(SPU_ELEMENT_FILE)' \
	  --ppu-sym='$(SPU_PPUSYM_FILE)' \
	  --job='$(1)' \
	  --fnresolve='$(2)'

 SPUJOB_GENPAGETABLE = \
	$(BUILD_SILENT) $(PERL) '$(MAKE_ROOT)/Tools/genpagetable.pl' \
	  --max-page-size=$(4) \
	  --initial-page-size=$(5) \
	  --size-file='$(1)' \
	  --pagetable='$(2)' \
	  --output='$(3)'

 SPUJOB_SN_MODPAGE = $(BUILD_LINK) $(SPUMODGEN) -q $(1) $(2)

 SPUJOB_SN_MODEXEC = $(BUILD_LINK) $(SPUMODGEN) -q $(1) $(2)

 SPUJOB_REPOSITORY_DEPS = \
	$(SPUJOB_PAGETABLE_FILES) \
	$(SPUJOB_PAGEDESC_FILES) \
	$(SPUJOB_JOBDESC_FILES) \
	$(SPUJOB_JOBFNC_FILES) \
	$(SPUJOB_ELF_FILES) \
	$(SPUJOB_OBJECTS) \
	$(SPUJOB_SIZETABLES)

#$(SPUJOB_PAGETABLE_FILES) 


# ifeq ($(OPTION_PS3_SPU_SNDEBUG),1)	
  SPUJOB_REPOSITORY_DEPS += $(SPUJOB_BIN_FILES)
# endif

 spu_jobgen_options := -m
 ifeq ($(MKOPTION_VERBOSE),1)
  spu_jobgen_options += -v
 endif
 #enable function pointer debugging
 ifeq ($(OPTION_PS3_SPU_ASSERT),1)
  spu_jobgen_options += -d
 endif
# ifeq ($(OPTION_PS3_SPU_SNDEBUG),1)
  spu_jobgen_options += -g
# endif
 spu_jobgen_options += \
	-A $(ps3_jobman_dir)/lib/SPUDriverAddr$(spujob_driver_suffix).txt
 spu_jobgen_options += -S $(SPUMODGEN) -W $(output_dir)

ifneq ($(BUILD_WITH_PS3_SDK),1)
 spu_jobgen_list_file = $(EFFECTIVE_BUILD_ROOT)/Lib/$(TARGET)/spujob/Files.list
else
 spu_jobgen_list_file = $(PS3_SPU_ROOT)/$(TARGET)/spujob/Files.list
endif

 spu_jobgen_create_list_file = \
	$(PERL) $(MAKE_ROOT)/Tools/echo.pl -l -H $(HOST_SYSTEM)
 ifeq ($(HOST_SYSTEM),Cygwin)
  ifdef CYGWIN_BASEDIR
   spu_jobgen_create_list_file += -b '$(CYGWIN_BASEDIR)'
  endif
 endif
 spu_jobgen_create_list_file += --

 EXEC_JOBGEN = $(MAKE_TOOLS_BINDIR)/JobGen -i -m

$(SPUJOB_REPOSITORY): $(SPUJOB_REPOSITORY_DEPS) $(SPUJOB_FILE_LISTS) $(PROJECT_OUTPUT) 
	$(SILENT) mkdir -p $(output_dir)/ProfilingData
	$(SILENT) $(RM) $(spu_jobgen_list_file)
	$(SILENT) cat $(SPUJOB_FILE_LISTS) | grep -v _fnresolve.o > $(spu_jobgen_list_file)
	$(SILENT) $(spu_jobgen_create_list_file) $(PROJECT_OUTPUT) >> $(spu_jobgen_list_file)
	$(SILENT) touch '$(PROJECT_OUTPUT).timestamp' -r '$(PROJECT_OUTPUT)'
ifeq ($(MKOPTION_INCREDIBUILD),1)
	$(SILENT) if [ -f '$(INCREDIBAT_SPU)' ]; then \
		$(PERL) $(MAKE_ROOT)/Tools/invoke_incredibuild.pl \
			--MaxCPUS=128 \
			$(SHOW_INCREDIBUILD_CONSOLE)\
			--NoLogo --command='$(INCREDIBAT_SPU)'; \
	fi
endif
	$(BUILD_LINK) \
	  $(EXEC_JOBGEN) \
	    $(spu_jobgen_options) \
	    -l $(spu_jobgen_list_file) \
	    -o $(SPUJOB_REPOSITORY) \
	    -e $(PROJECT_OUTPUT)\
		  -c $(SPUJOB_PAGE_COUNT)\
		  -n 2
ifeq ($(OPTION_PS3_SPU_PROFILE),1)			  
	-$(SILENT) cp -f $(DEPOT_MAIN)/BinPS3/CacheAnalyser.exe $(output_dir)/CacheAnalyser.exe
	$(SILENT) touch $(LOGDIR)/scan/cache_dummy.log
	$(SILENT) cp -f $(LOGDIR)/scan/cache_*.log $(output_dir)/ProfilingData
endif	
	$(SILENT) touch '$(PROJECT_OUTPUT).changed' -r '$(PROJECT_OUTPUT)'
	$(SILENT) $(RM) $(spu_jobgen_list_file)
	$(SILENT) touch '$(PROJECT_OUTPUT)' -r '$(PROJECT_OUTPUT).timestamp'
	$(SILENT) $(RM) '$(PROJECT_OUTPUT).timestamp'

 postscan_deps := $(SPUJOB_SOURCES) $(SPUJOB_PAGETABLE_FILES) | $(CRYCG_SYNC) $(CRYCG_SIZE_SYNC)

 postlink_deps := $(SPUJOB_REPOSITORY) 

.PHONY: _exec_project_post$(STAGE)
_exec_project_post$(STAGE): $(post$(STAGE)_deps)
ifneq ($(MKOPTION_COMPACT),1)
	$(SILENT) echo '* Post-$(STAGE) $(TARGET) complete'
endif

else
 -include $(SPUJOBS_EXEC_MK)
 -include $(SPUJOBS_PAGE_MK)
endif # EXECUTE_PROJECT_POST

ifeq ($(PROJECT_TYPE),program)
 LINK_CLEAN_$(TARGET) += \
	$(SPUJOB_REPOSITORY) \
	$(patsubst %.bin,%.log,$(SPUJOB_REPOSITORY))
endif

# ChrisR: 
# Disabled for now because of realloc issues needing a prelink step !
#SPUJOB_ENABLE ?= 0
#ifeq ($(OPTION_PS3_USE_SNLD),1)  
# ifneq ($(OPTION_PS3_MTRACE),1)
#  ifneq ($(BUILD_HAS_SPUJOBS),1)
#    LINK_DIRECT_SELF := 1
#  endif
# endif
#endif

# Setup the post-link steps.
PROJECT_POSTLINK = $(SILENT) :
ifeq ($(PROJECT_TYPE),program)
 ifeq ($(SPUJOB_ENABLE),1)
  PROJECT_POSTLINK += \
	&& $(MAKE) \
	  -f "$(COMMON_MK)" \
	  $(MAKE_FLAGS) \
	  $(COMMON_ARGS) \
	  EXEC_PROJECT_POSTLINK=1 \
	  PROJECT_OUTPUT='$(PROJECT_OUTPUT)' \
	  _exec_project_postlink
 endif
endif
ifneq ($(OPTION_PS3_NOMAKEFSELF),1)
 ifeq ($(PROJECT_TYPE),module)
  ifeq ($(OPTION_PS3_PRX_$(TARGET)),1)
   ifeq ($(MKOPTION_PS3_COPYELF),1)
    PROJECT_POSTLINK += \
	&& rm -f $(output_dir)/$(TARGET)$(output_suffix).prx \
	&& cp \
	  $(PROJECT_OUTPUT) \
	  $(output_dir)/$(TARGET)$(output_suffix).prx
   endif
   ifeq ($(OPTION_PS3_PRXSTRIP),1)
    PROJECT_POSTLINK += \
	&& $(_BUILD_LINK) $(STRIP_PRX) $(PROJECT_OUTPUT)
   endif
   PROJECT_POSTLINK += \
	&& $(_BUILD_SILENT) mkdir -p $(output_dir) \
	&& \
	if [ $(PROJECT_OUTPUT) -nt $(output_dir)/$(TARGET)$(output_suffix).sprx ]; \
	then \
	  rm -f $(output_dir)/$(TARGET)$(output_suffix).sprx \
	  && $(_BUILD_LINK) $(MAKE_FSELF) \
	    $(PROJECT_OUTPUT) \
	    $(output_dir)/$(TARGET)$(output_suffix).sprx; \
        else \
	  :; \
	fi
   ifeq ($(MKOPTION_PS3_COPYELF),1)
    PROJECT_POSTLINK += \
	&& \
	if [ $(PROJECT_OUTPUT) -nt $(output_dir)/$(TARGET)$(output_suffix).prx ]; \
	then \
	  rm -f $(output_dir)/$(TARGET)$(output_suffix).prx \
	  && cp \
	    $(PROJECT_OUTPUT) \
	    $(output_dir)/$(TARGET)$(output_suffix).prx; \
	else \
	  :; \
	fi
   endif
  endif
 endif # PROJECT_TYPE == program
 
 ifneq ($(OPTION_PS3_EXEC_NAME),)
   SELF_NAME := $(output_dir)/$(OPTION_PS3_EXEC_NAME)$(output_suffix).self
 else
	 SELF_NAME := $(output_dir)/$(TARGET)$(output_suffix).self
 endif
 
 ifeq ($(PROJECT_TYPE),program)
  ifeq ($(MKOPTION_PS3_COPYMAP),1)
   PROJECT_POSTLINK += \
	&& rm -f $(output_dir)/$(TARGET)$(output_suffix).$(EXT_MAP) \
	&& \
	if [ -r $(PROJECT_OUTPUT).$(EXT_MAP) \
	    -a $(PROJECT_OUTPUT).$(EXT_MAP) \
	      -nt $(output_dir)/$(TARGET)$(output_suffix).$(EXT_MAP) ]; \
	then \
	  cp \
	    $(PROJECT_OUTPUT).$(EXT_MAP) \
	    $(output_dir)/$(TARGET)$(output_suffix).$(EXT_MAP); \
        else \
	  :; \
	fi
  endif
  ifeq ($(LINK_DIRECT_SELF),1)  
   PROJECT_POSTLINK += \
 	 && \
	 if [ '$(PROJECT_OUTPUT).changed' -ot '$(PROJECT_OUTPUT)' ]; then \
	  touch '$(PROJECT_OUTPUT).changed' -r '$(PROJECT_OUTPUT)'; \
	 fi
  else
   PROJECT_POSTLINK += \
 	 && $(_BUILD_SILENT) mkdir -p $(output_dir) \
 	 && \
	 if [ '$(PROJECT_OUTPUT).changed' -ot '$(PROJECT_OUTPUT)' ]; then \
	  touch '$(PROJECT_OUTPUT).changed' -r '$(PROJECT_OUTPUT)'; \
	 fi; \
	 if [ '$(PROJECT_OUTPUT).changed' \
	    -nt $(SELF_NAME) ]; \
	 then \
	  rm -f $(SELF_NAME) \
	  && $(_BUILD_LINK) $(MAKE_FSELF) \
	    $(PROJECT_OUTPUT) \
	    $(SELF_NAME); \
	 fi
	endif
	PROJECT_POSTLINK += && $(_BUILD_SILENT) touch '$(BUILD_ROOT)/../../../buildlog.txt'\
		&& $(_BUILD_SILENT) cat '$(BUILD_ROOT)/../../../buildlog.txt'
  ifeq ($(OPTION_PS3_SPU_SNDEBUG),1)
   PROJECT_POSTLINK += \
	&& \
	if [ '$(PROJECT_OUTPUT).changed' \
	    -nt $(output_dir)/SPUDriver$(spujob_driver_suffix).elf ]; \
	then \
	  rm -f $(output_dir)/SPUDriver$(spujob_driver_suffix).elf \
	  && cp \
	    $(ps3_jobman_dir)/lib/SPUDriver$(spujob_driver_suffix).elf \
	    $(output_dir)/SPUDriver$(spujob_driver_suffix).elf; \
	fi
	endif
  ifeq ($(MKOPTION_PS3_COPYELF),1)
   PROJECT_POSTLINK += \
	&& \
	if [ '$(PROJECT_OUTPUT).changed' \
	    -nt $(output_dir)/$(TARGET)$(output_suffix).elf ]; \
	then \
	  rm -f $(output_dir)/$(TARGET)$(output_suffix).elf \
	  && cp \
	    $(PROJECT_OUTPUT) \
	    $(output_dir)/$(TARGET)$(output_suffix).elf; \
	fi
  endif
 endif
endif # OPTION_PS3_NOMAKEFSELF != 1

# Add options for function/data sections garbage collection.
ifneq ($(OPTION_PS3_USE_SNLD),1) 
 ifeq ($(OPTION_PS3_GCSECTIONS),1)
  ifneq ($(OPTION_PS3_PRX_$(TARGET)),1)
   ARCH_CFLAGS += -ffunction-sections -fdata-sections
  endif
  ARCH_LDFLAGS_program += -Wl,--gc-sections
 endif
endif

ifneq ($(OPTION_SUPP_FP_EXCEPTION),1)
 ifeq ($(OPTION_PS3_OPTIMIZED_CODE),1)
  ifneq ($(MKOPTION_SNC),1)
    ARCH_LDFLAGS_program += -Wl,--wrap=sin -Wl,--wrap=cos -Wl,--wrap=tan\
     -Wl,--wrap=sinf -Wl,--wrap=cosf -Wl,--wrap=tanf\
     -Wl,--wrap=asin -Wl,--wrap=asinf -Wl,--wrap=acos -Wl,--wrap=acosf -Wl,--wrap=atan\
     -Wl,--wrap=atanf -Wl,--wrap=atan2 -Wl,--wrap=atan2f
  endif
 endif
endif

# ChrisR: 
# Disabled for now because realloc workaround needs a prelink step!
# ifeq ($(OPTION_PS3_USE_SNLD),1)
#   ifneq ($(BUILD_HAS_SPUJOBS),1)
#    ifneq ($(OPTION_PS3_MTRACE),1)
#     ARCH_LDFLAGS_program += --oformat=fself -Wl,--oformat=fself
#    endif
#   else
#     ARCH_LDFLAGS_program += --oformat=elf -Wl,--oformat=elf
#   endif
# endif
ARCH_LDFLAGS_program += --oformat=elf -Wl,--oformat=elf

# Tag message strings for SPU compiling and linking.  The tags are defined
# independent from the current stage, because the associated actions might be
# moved between stages.
ifneq ($(MKOPTION_COMPACT),1)
 tag_spujob_exec_cxx := SPUJOB/C++
 tag_spujob_page := SPUJOB/PAGE
 tag_spujob_page_cxx := SPUJOB/C++
 tag_spujob_page_asm := SPUJOB/ASM
 tag_spujob_page_h := SPUJOB/H
else
 tag_spujob_exec_cxx := spujob
 tag_spujob_page := spujob
 tag_spujob_page_cxx := spujob
 tag_spujob_page_asm := spujob
 tag_spujob_page_h := spujob
endif

# Support for prelinking 

prelink = $(PERL) $(MAKE_ROOT)/Tools/prelink.pl 
prelink_tmp := $(PROJECT_BUILD)/prelink
prelink += --tmpdir $(prelink_tmp)
prelink += --ppu-nm '$(NM)'
prelink += --ppu-objcopy '$(OBJCOPY)'
prelink += --ppu-ar '$(AR)'
prelink += --ppu-LD '$(LD)'
ifeq ($(MKOPTION_VERBOSE),1)
 prelink += --verbose
endif


# Arch/PS3-cell.setup.mk
# vim:ts=8:sw=2

